/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.schedblock.Target;
import alma.valuetypes.Time;

public class RevisedIntegrationParameters {
    private Target scienceTarget;
    private Time subScanDuration;
    private int noOfSBExecs;
    private Time scienceIntegrationTime;

    public static RevisedIntegrationParametersBuilder builder() {
        return new RevisedIntegrationParametersBuilder();
    }

    public RevisedIntegrationParameters(Target target, Time time, int n, Time time2) {
        this.scienceTarget = target;
        this.subScanDuration = time;
        this.noOfSBExecs = n;
        this.scienceIntegrationTime = time2;
    }

    public Target getScienceTarget() {
        return this.scienceTarget;
    }

    public Time getSubScanDuration() {
        return this.subScanDuration;
    }

    public int getNoOfSBExecs() {
        return this.noOfSBExecs;
    }

    public Time getScienceIntegrationTime() {
        return this.scienceIntegrationTime;
    }

    public void setScienceTarget(Target target) {
        this.scienceTarget = target;
    }

    public void setSubScanDuration(Time time) {
        this.subScanDuration = time;
    }

    public void setNoOfSBExecs(int n) {
        this.noOfSBExecs = n;
    }

    public void setScienceIntegrationTime(Time time) {
        this.scienceIntegrationTime = time;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RevisedIntegrationParameters)) {
            return false;
        }
        RevisedIntegrationParameters revisedIntegrationParameters = (RevisedIntegrationParameters)object;
        if (!revisedIntegrationParameters.canEqual(this)) {
            return false;
        }
        if (this.getNoOfSBExecs() != revisedIntegrationParameters.getNoOfSBExecs()) {
            return false;
        }
        Target target = this.getScienceTarget();
        Target target2 = revisedIntegrationParameters.getScienceTarget();
        if (target == null ? target2 != null : !target.equals(target2)) {
            return false;
        }
        Time time = this.getSubScanDuration();
        Time time2 = revisedIntegrationParameters.getSubScanDuration();
        if (time == null ? time2 != null : !time.equals(time2)) {
            return false;
        }
        Time time3 = this.getScienceIntegrationTime();
        Time time4 = revisedIntegrationParameters.getScienceIntegrationTime();
        return !(time3 == null ? time4 != null : !time3.equals(time4));
    }

    protected boolean canEqual(Object object) {
        return object instanceof RevisedIntegrationParameters;
    }

    public int hashCode() {
        int n = 1;
        n = n * 59 + this.getNoOfSBExecs();
        Target target = this.getScienceTarget();
        n = n * 59 + (target == null ? 43 : target.hashCode());
        Time time = this.getSubScanDuration();
        n = n * 59 + (time == null ? 43 : time.hashCode());
        Time time2 = this.getScienceIntegrationTime();
        n = n * 59 + (time2 == null ? 43 : time2.hashCode());
        return n;
    }

    public String toString() {
        return "RevisedIntegrationParameters(scienceTarget=" + String.valueOf(this.getScienceTarget()) + ", subScanDuration=" + String.valueOf(this.getSubScanDuration()) + ", noOfSBExecs=" + this.getNoOfSBExecs() + ", scienceIntegrationTime=" + String.valueOf(this.getScienceIntegrationTime()) + ")";
    }

    public static class RevisedIntegrationParametersBuilder {
        private Target scienceTarget;
        private Time subScanDuration;
        private int noOfSBExecs;
        private Time scienceIntegrationTime;

        RevisedIntegrationParametersBuilder() {
        }

        public RevisedIntegrationParametersBuilder scienceTarget(Target target) {
            this.scienceTarget = target;
            return this;
        }

        public RevisedIntegrationParametersBuilder subScanDuration(Time time) {
            this.subScanDuration = time;
            return this;
        }

        public RevisedIntegrationParametersBuilder noOfSBExecs(int n) {
            this.noOfSBExecs = n;
            return this;
        }

        public RevisedIntegrationParametersBuilder scienceIntegrationTime(Time time) {
            this.scienceIntegrationTime = time;
            return this;
        }

        public RevisedIntegrationParameters build() {
            return new RevisedIntegrationParameters(this.scienceTarget, this.subScanDuration, this.noOfSBExecs, this.scienceIntegrationTime);
        }

        public String toString() {
            return "RevisedIntegrationParameters.RevisedIntegrationParametersBuilder(scienceTarget=" + String.valueOf(this.scienceTarget) + ", subScanDuration=" + String.valueOf(this.subScanDuration) + ", noOfSBExecs=" + this.noOfSBExecs + ", scienceIntegrationTime=" + String.valueOf(this.scienceIntegrationTime) + ")";
        }
    }
}

