/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ExpectedSpectralLine;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.valuetypes.Frequency;
import alma.valuetypes.KeywordValue;
import alma.valuetypes.Velocity;
import java.util.Optional;
import lombok.NonNull;

public final class SBExpertParameterExpert {
    public static final String N_TUNING_CYCLE = "nTuningCycle";

    private static void setupSolarExpertParameters(@NonNull ScienceGoal scienceGoal, @NonNull SchedBlock schedBlock) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        try {
            if (scienceGoal.isSolarScienceGoal() && scienceGoal.getSpectralSetupParameters().getReceiverBand().getNumber() == 7) {
                for (KeywordValue keywordValue : schedBlock.getExpertParameterList()) {
                    if (!keywordValue.getKeyword().equals("activeSun")) continue;
                    schedBlock.removeExpertParameter(keywordValue);
                    break;
                }
                Object object = KeywordValue.createKeywordValue();
                object.setKeyword("activeSun");
                object.setValue("0");
                schedBlock.addExpertParameter((KeywordValue)((Object)object));
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new WizardSBGenerationException("Unable to determine if solar science goal " + unknownEntityException.getMessage());
        }
    }

    static void setupExpertParameters(@NonNull ScienceGoal scienceGoal, @NonNull SchedBlock schedBlock) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        SBExpertParameterExpert.setPolarizationExpertParameters(scienceGoal, schedBlock);
        SBExpertParameterExpert.setupSolarExpertParameters(scienceGoal, schedBlock);
        SBExpertParameterExpert.setupVLBISpectralLineExpertParameters(scienceGoal, schedBlock);
    }

    private static void setupVLBISpectralLineExpertParameters(@NonNull ScienceGoal scienceGoal, @NonNull SchedBlock schedBlock) {
        Object object;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (!VLBIExpert.isScienceGoalLegalVLBISpectralLine(scienceGoal)) {
            return;
        }
        KeywordValue keywordValue = KeywordValue.createKeywordValue();
        keywordValue.setKeyword("SpecLineBB1Only");
        keywordValue.setValue("1");
        schedBlock.addExpertParameter(keywordValue);
        ScienceSpectralWindow[] scienceSpectralWindowArray = scienceGoal.getSpectralSetupParameters().getScienceSpectralWindowGroup(0);
        if (scienceSpectralWindowArray.length == 0) {
            throw new WizardSBGenerationException("Unable to locate SiO spectral window in group/baseband 0");
        }
        KeywordValue keywordValue2 = KeywordValue.createKeywordValue();
        keywordValue2.setKeyword("SpecLineList");
        Frequency frequency = Frequency.createFrequencyGHZ(0.0);
        TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
        ExpectedSpectralLine[] expectedSpectralLineArray = scienceSpectralWindowArray[0].getExpectedSpectralLine();
        if (expectedSpectralLineArray.length > 0) {
            frequency = expectedSpectralLineArray[0].getRestFrequency();
            object = targetParameters.getSourceVelocity().deepCopy();
            object = object.getVelocityInDefaultReferenceFrame(targetParameters.getFieldCenterCoordinates(), Optional.of(scienceGoal));
            frequency = frequency.dopplerShifted((Velocity)((Object)object));
        }
        object = String.format("tmp.vex:%g:%g:comment", frequency.getContentInGHz(), targetParameters.getExpectedProperties().getExpectedLineWidth().getContentInMHz());
        keywordValue2.setValue((String)object);
        schedBlock.addExpertParameter(keywordValue2);
    }

    private static void setPolarizationExpertParameters(@NonNull ScienceGoal scienceGoal, @NonNull SchedBlock schedBlock) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (scienceGoal.isFullPolarization()) {
            KeywordValue keywordValue = KeywordValue.createKeywordValue();
            keywordValue.setKeyword("SessionControl");
            keywordValue.setValue("1");
            schedBlock.addExpertParameter(keywordValue);
        }
    }

    private SBExpertParameterExpert() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

