/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.intermediatetarget.TPRasterData;
import alma.obsprep.services.generator.refactored.intermediatetarget.TPReferencePositionWorker;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import alma.valuetypes.data.SkyCoordinatesData;
import lombok.NonNull;

public abstract class ScienceIntermediateTargetBuilder {
    protected void modifyScienceTargetForTPArray(@NonNull Target target, @NonNull ScienceGoal scienceGoal) {
        if (target == null) {
            throw new NullPointerException("scienceTarget is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        ScienceParameters scienceParameters = target.getFirstScienceParameters().orElseThrow(() -> new WizardSBGenerationException("Unable to get first science parameters"));
        FieldPattern fieldPattern = target.getFieldSource().getFieldPattern();
        if (fieldPattern instanceof RectanglePattern) {
            Object object;
            Time time;
            Object object2;
            RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldPattern);
            Integer n = target.getSpectralSpec().getReceiverBand().getNumber();
            double d = AlmaPolicies.getInstance().getTpMaxTOSPerSB().getSecs();
            double d2 = CorrelatorExpert.TPCorrelatorConfiguratorHelper.getEstimatedSubscanDuration(n, ObsType.SCIENCE);
            Time time2 = target.getSpectralSpec().getAbstractCorrelatorConfiguration().getIntegrationDuration();
            double d3 = CorrelatorExpert.TPCorrelatorConfiguratorHelper.calcSubscanDuration(d2, time2.getContentInUnits(Time.UNIT_S));
            scienceParameters.setSubScanDuration(Time.createTime((double)d3, (String)Time.UNIT_S));
            double d4 = (double)rectanglePattern.getRowCount() * d3;
            double d5 = Math.floor(d / d4);
            try {
                object2 = new TPRasterData.Builder();
                if (scienceGoal.isSolarScienceGoal()) {
                    time = AlmaPolicies.getInstance().getItosForSolarSource();
                    ((TPRasterData.Builder)object2).n_rowcount(rectanglePattern.getRowCount()).t_osmax(Time.createTimeSec(d)).t_rect(time).isSolarTPSB(true).t_expectedTotalITOS(time);
                } else {
                    time = Time.createTimeSec(d4);
                    ((TPRasterData.Builder)object2).n_rowcount(rectanglePattern.getRowCount()).t_osmax(Time.createTimeSec(d)).t_rect(Time.createTimeSec(d4)).isSolarTPSB(false).t_expectedTotalITOS((Time)time.multiply(d5));
                }
                object = ((TPRasterData.Builder)object2).build();
                scienceParameters.setTPRasterData((TPRasterData)object);
            }
            catch (UnknownEntityException unknownEntityException) {
                throw new WizardSBGenerationException("Unable to determine if science goal is solar " + unknownEntityException.getMessage());
            }
            scienceParameters.getIntegrationTime().setContentAndUnit((ValueUnitPair)time);
            object2 = rectanglePattern.getFieldCenterCoordinates().deepCopy();
            object = target.getFieldSource().getSourceCoordinates();
            object2 = ((SkyCoordinates)object2).getAbsoluteCoordinates((SkyCoordinates)object);
            ((SkyCoordinates)object2).convertToSystem(SkyCoordinatesData.SYSTEM_ICRS);
            if (((SkyCoordinates)object2).isAbsoluteCoordinates()) {
                object2 = ((SkyCoordinates)object2).getOffsetCoordinates((SkyCoordinates)object);
            }
            rectanglePattern.setPatternCenterCoordinates((SkyCoordinates)object2);
        }
        TPReferencePositionWorker.setupReferencePosition(target);
    }
}

