/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.obsparams;

import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.ObservatoryGoalObservingParametersFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.valuetypes.Time;

public class BaselineCalibrationObservingParametersFactory
extends ObservatoryGoalObservingParametersFactory {
    private final Time targetIntegrationTime;

    public BaselineCalibrationObservingParametersFactory(SpectralSpec spectralSpec, TargetWithIntent targetWithIntent, RequestedArray requestedArray, Time time, SBGenerationContext sBGenerationContext) {
        super(spectralSpec, targetWithIntent, requestedArray, sBGenerationContext);
        this.targetIntegrationTime = time.deepCopy();
    }

    @Override
    protected DelayCalParameters getDelayCalParameters(int n) {
        DelayCalParameters delayCalParameters = super.getDelayCalParameters(n);
        if (n == 2) {
            delayCalParameters.setName("Target DelayCalParameters");
            delayCalParameters.setDefaultIntegrationTime(this.targetIntegrationTime.deepCopy());
            double d = this.targetIntegrationTime.getContentInUnits(Time.UNIT_S);
            double d2 = this.integrationTime.getContentInUnits(Time.UNIT_S);
            double d3 = this.correlatorExpert.calcSubscanDuration(d, d2, null);
            delayCalParameters.setSubScanDuration(Time.createTime((double)d3, (String)Time.UNIT_S));
            delayCalParameters.setCycleTime(Time.createTime((double)99999.0, (String)Time.UNIT_H));
        }
        return delayCalParameters;
    }

    @Override
    protected CheckSourceCalParameters getCheckSourceCalParameters(int n) {
        CheckSourceCalParameters checkSourceCalParameters = super.getCheckSourceCalParameters(n);
        if (n == 2) {
            checkSourceCalParameters.setName("Target CheckSourceCalParameters");
            checkSourceCalParameters.setDefaultIntegrationTime(this.targetIntegrationTime.deepCopy());
            double d = this.targetIntegrationTime.getContentInUnits(Time.UNIT_S);
            double d2 = this.integrationTime.getContentInUnits(Time.UNIT_S);
            double d3 = this.correlatorExpert.calcSubscanDuration(d, d2, null);
            checkSourceCalParameters.setSubScanDuration(Time.createTime((double)d3, (String)Time.UNIT_S));
            checkSourceCalParameters.setCycleTime(Time.createTime((double)99999.0, (String)Time.UNIT_H));
        }
        return checkSourceCalParameters;
    }
}

