/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.obsparams;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.AbstractObservingParametersFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import lombok.NonNull;

public class ScienceGoalObservingParametersFactory
extends AbstractObservingParametersFactory {
    public ScienceGoalObservingParametersFactory(@NonNull ScienceGoal scienceGoal, @NonNull SpectralSpec spectralSpec, @NonNull TargetWithIntent targetWithIntent, @NonNull RequestedArray requestedArray, @NonNull SBGenerationContext sBGenerationContext) {
        super(scienceGoal, spectralSpec, targetWithIntent, requestedArray, sBGenerationContext);
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
    }

    @Override
    protected ScienceParameters getScienceParameters(@NonNull SpectralSetupParameters spectralSetupParameters) {
        Object object;
        Frequency frequency;
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (this.sbContext == null) {
            throw new NullPointerException("Illegal argument - the argument sbContext cannot be null");
        }
        BusinessObject businessObject = spectralSetupParameters.getParent();
        if (!(businessObject instanceof ScienceGoal)) {
            throw new IllegalArgumentException("ScienceGoalCalibratorParametersFactory only processes Science Goals!");
        }
        ScienceGoal scienceGoal = (ScienceGoal)businessObject;
        ScienceParameters scienceParameters = ScienceParameters.createScienceParameters();
        scienceParameters.setName("Science Params");
        Frequency frequency2 = scienceGoal.getRepresentativeBandwidth();
        scienceParameters.setRepresentativeBandwidth(frequency2.deepCopy());
        if (scienceGoal.getSpectralSetupParameters().isSingleContinuumSkyFrequency()) {
            frequency = scienceGoal.getRepresentativeFrequency().deepCopy();
        } else if (scienceGoal.getSpectralSetupParameters().isDerivedSSP() || scienceGoal.getSpectralSetupParameters().isSpectralScan()) {
            frequency = spectralSetupParameters.getRepresentativeFrequency().deepCopy();
        } else {
            object = scienceGoal.getRepresentativeFrequency().deepCopy();
            frequency = ((Frequency)((Object)object)).dopplerShifted(scienceGoal.getSourceVelocity());
        }
        scienceParameters.setRepresentativeFrequency(frequency);
        if (this.array.isTP()) {
            this.setTPSubscanDuration(scienceParameters, frequency);
        } else {
            scienceParameters.setSubScanDuration(this.getAlignedSubscanDuration(30.0));
        }
        object = SchedBlockExpert.getInstance(scienceGoal);
        scienceParameters.setSensitivityGoal(((SchedBlockExpert)object).calcAllocatedSensitivity());
        return scienceParameters;
    }

    private void setTPSubscanDuration(@NonNull ScienceParameters scienceParameters, @NonNull Frequency frequency) {
        if (scienceParameters == null) {
            throw new NullPointerException("scienceParameters is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("skyFrequency is marked non-null but is null");
        }
        double d = frequency.getContentInGHz();
        boolean bl = false;
        if (ReceiverBand.getReceiverBand(1) != null) {
            bl = ReceiverBand.getReceiverBand(1).isValidFrequency(d);
        }
        double d2 = bl || ReceiverBand.getReceiverBand(3).isValidFrequency(d) || ReceiverBand.getReceiverBand(4).isValidFrequency(d) ? 20.0 : (ReceiverBand.getReceiverBand(6).isValidFrequency(d) ? 15.0 : (ReceiverBand.getReceiverBand(7).isValidFrequency(d) || ReceiverBand.getReceiverBand(8).isValidFrequency(d) ? 10.0 : (d >= ReceiverBand.getReceiverBand(9).getRFMin() ? 10.0 : (d >= ReceiverBand.getReceiverBand(6).getRFMin() ? 20.0 : 30.0))));
        scienceParameters.setSubScanDuration(this.getAlignedSubscanDuration(d2));
    }

    public static void main(String ... stringArray) throws InvalidFrequencyException, SourceNeverVisibleException {
        InitServices.initModelSupportClasses();
        System.setProperty("Telescope", "Cycle2");
        System.setProperty("otData.dir", "config/otData");
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        Frequency frequency = Frequency.createFrequencyGHZ(650.0);
        spectralSetupParameters.updateSingleContinuumWindows(frequency, Velocity.createVelocity(), ObservingFrequency.FrequencyType.SKY_FREQUENCY, spectralSetupParameters.getCorrPolarization());
        CalObs calObs = CalObs.createCalObs(CalType.Bandpass, scienceGoal);
        calObs.setCalFrequency(frequency);
        calObs.setCalibratorCoordinates(calObs.getSourceCoordinates().deepCopy());
        calObs.setSNR(20.0);
        calObs.setWvChoice(0);
        calObs.configure();
        System.out.println(String.valueOf(calObs) + "\n" + String.valueOf(calObs.rawCalTime()) + "\n" + String.valueOf(calObs.calTime()) + " ");
    }
}

