/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.services.summaryfeedback.PdfExporter;
import alma.obsprep.services.summaryfeedback.SummaryFeedbackView;
import alma.obsprep.services.summaryfeedback.TextPanelHelper;
import alma.obsprep.util.FileUtilities;
import alma.obsprep.util.GUIUtilities;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.JTextComponent;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class DefaultPdfExporter
implements PdfExporter {
    private static DialogId DIALOG_OVERWRITE_FILE = new DialogId("SummaryPDF.OverwriteFile");
    static final int ONE_TEXT_ROW_HEIGHT = 40;
    protected static FontMapper SWING_FONTMAPPER = new FontMapper(){

        public BaseFont awtToPdf(Font font) {
            try {
                int n = font.getStyle() & 3;
                String string = n == 3 ? "BoldItalic" : (n == 1 ? "Bold" : (n == 2 ? "Italic" : "Regular"));
                String string2 = DefaultPdfExporter.class.getPackage().getName().replaceAll("\\.", "/");
                return BaseFont.createFont((String)(string2 + "/resources/LiberationSans-" + string + ".ttf"), (String)"Identity-H", (boolean)true);
            }
            catch (DocumentException | IOException throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public Font pdfToAwt(BaseFont baseFont, int n) {
            return null;
        }
    };
    protected SummaryFeedbackView offlinePDFView;
    final String[] whiteSpace = new String[]{"\n", "\r", " "};

    protected DefaultPdfExporter() {
    }

    protected DefaultPdfExporter(@NonNull SummaryFeedbackView summaryFeedbackView) {
        if (summaryFeedbackView == null) {
            throw new NullPointerException("offlinePDFView is marked non-null but is null");
        }
        this.setOfflinePDFView(summaryFeedbackView);
    }

    protected JPanel addHeaderLabelToView(@NonNull JComponent jComponent, @NonNull JLabel jLabel) {
        if (jComponent == null) {
            throw new NullPointerException("view is marked non-null but is null");
        }
        if (jLabel == null) {
            throw new NullPointerException("headerLabel is marked non-null but is null");
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setBackground(Color.WHITE);
        jLabel.setHorizontalAlignment(4);
        jLabel.setOpaque(true);
        jLabel.setBackground(Color.WHITE);
        jLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.BLACK));
        JLabel jLabel2 = new JLabel(" ");
        jLabel2.setOpaque(true);
        jLabel2.setBackground(Color.WHITE);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)jLabel2, "South");
        jPanel.add(jPanel2);
        jPanel.add(jComponent);
        new JScrollPane(jPanel);
        return jPanel;
    }

    protected int addNewPage(@NonNull Document document, int n) {
        if (document == null) {
            throw new NullPointerException("pdfDocument is marked non-null but is null");
        }
        document.newPage();
        return ++n;
    }

    protected void addPanelToPDFDocument(PdfWriter pdfWriter, JComponent jComponent) {
        Rectangle rectangle = pdfWriter.getPageSize();
        int n = this.getPdfPageMargin();
        float f = rectangle.getWidth();
        float f2 = rectangle.getHeight();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(new JScrollPane(jComponent));
        jFrame.pack();
        float f3 = f;
        float f4 = f2;
        double d = this.getPageFitScale(f, f2, n, jComponent);
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        PdfTemplate pdfTemplate = pdfContentByte.createTemplate(f3, f4);
        PdfGraphics2D pdfGraphics2D = new PdfGraphics2D((PdfContentByte)pdfTemplate, f3, f4, SWING_FONTMAPPER);
        pdfGraphics2D.scale(d, d);
        jComponent.print((Graphics)pdfGraphics2D);
        pdfGraphics2D.dispose();
        pdfContentByte.addTemplate(pdfTemplate, (float)n, (float)(-n));
    }

    private JPanel createAdditionalTextPanel(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setText(string);
        jTextArea.setBorder(BorderFactory.createTitledBorder("Continued ..."));
        jPanel.add((Component)jTextArea, "First");
        return jPanel;
    }

    protected void doLayout(Component component) {
        FutureTask<Void> futureTask = new FutureTask<Void>(() -> {
            this.innerDoLayout(component);
            return null;
        });
        if (SwingUtilities.isEventDispatchThread()) {
            futureTask.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(futureTask);
            }
            catch (InterruptedException interruptedException) {
                try {
                    futureTask.get();
                }
                catch (InterruptedException interruptedException2) {
                }
                catch (ExecutionException executionException) {
                    throw new RuntimeException(interruptedException.getCause());
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
        }
    }

    @Override
    public void exportToPdf() {
        File file;
        block2: {
            int n;
            JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser("pdf");
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("PDF file", "pdf");
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
            do {
                int n2 = jFileChooser.showSaveDialog(null);
                file = jFileChooser.getSelectedFile();
                if (n2 != 0 || file == null) {
                    return;
                }
                if (!file.exists() || (n = GUIUtilities.offer(DIALOG_OVERWRITE_FILE, "File '" + file.getAbsolutePath() + "' already exists, do you want to overwrite it?", "Yes", "No", "Cancel")) == 0) break block2;
            } while (n == 1);
            return;
        }
        String string = file.getAbsolutePath();
        String string2 = FileUtilities.getExtension(string);
        string2 = string2 == null ? ".pdf" : (string2.length() == 0 ? "pdf" : (string2.equals("pdf") ? "" : ".pdf"));
        File file2 = new File(string + string2);
        this.exportToPdf(file2);
    }

    @Override
    public void exportToPdf(@NonNull File file) {
        block4: {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            Rectangle rectangle = this.getPdfPageSize();
            Document document = new Document(rectangle);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)fileOutputStream);
                document.open();
                this.exportToPdfPage(document, pdfWriter, rectangle);
                pdfWriter.close();
                document.close();
                fileOutputStream.close();
            }
            catch (DocumentException | IOException throwable) {
                Log.logger((Object)this).warning(throwable.getMessage());
                GUIUtilities.warning(null, throwable.getMessage());
            }
            catch (ExceptionConverter exceptionConverter) {
                if (document.getPageNumber() <= 0) break block4;
                GUIUtilities.warning(null, exceptionConverter.getMessage());
                Log.logger((Object)this).warning(exceptionConverter.getMessage());
            }
        }
    }

    protected void exportToPdfPage(Document document, PdfWriter pdfWriter, Rectangle rectangle) {
        if (this.offlinePDFView == null) {
            return;
        }
        int n = this.getPdfPageMargin();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(new JScrollPane(this.offlinePDFView));
        jFrame.pack();
        float f = rectangle.getWidth();
        float f2 = rectangle.getHeight();
        double d = this.getPageFitScale(rectangle, n);
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        PdfTemplate pdfTemplate = pdfContentByte.createTemplate(f, f2);
        PdfGraphics2D pdfGraphics2D = new PdfGraphics2D((PdfContentByte)pdfTemplate, f, f2, SWING_FONTMAPPER);
        pdfGraphics2D.scale(d, d);
        this.offlinePDFView.print((Graphics)pdfGraphics2D);
        pdfGraphics2D.dispose();
        pdfContentByte.addTemplate(pdfTemplate, (float)n, (float)(-n));
    }

    protected int fitTextIntoAvailableSpaceInTextPanel(TextPanelHelper textPanelHelper, JComponent jComponent, int n, String string) {
        int n2 = textPanelHelper.addComponentToTextPanel(jComponent);
        if (n <= 40) {
            textPanelHelper.createPage(string);
            n = textPanelHelper.pageHeight;
        }
        if (jComponent instanceof JTextArea && n2 > n) {
            JTextArea jTextArea = (JTextArea)jComponent;
            JPanel jPanel = null;
            StringBuilder stringBuilder = new StringBuilder(jTextArea.getText().trim());
            stringBuilder.append(" ");
            int n3 = stringBuilder.length();
            if (n3 <= 1) {
                return n;
            }
            CharSequence[] charSequenceArray = new String[]{"\n", "\r", " "};
            do {
                String string2 = stringBuilder.substring(0, n3).trim();
                n3 = StringUtils.lastIndexOfAny((CharSequence)string2, (CharSequence[])charSequenceArray);
                jTextArea.setText(string2);
                this.doLayout(jTextArea);
            } while ((n2 = (int)jComponent.getPreferredSize().getHeight()) > n && n3 > 0);
            this.doLayout(textPanelHelper.currentPanel);
            textPanelHelper.createPage(string);
            n = textPanelHelper.pageHeight;
            if (n3 + 1 < stringBuilder.length()) {
                stringBuilder.delete(0, n3 + 1);
                stringBuilder.delete(0, stringBuilder.indexOf(" ") + 1);
                if (stringBuilder.toString().trim().length() > 0) {
                    jPanel = this.createAdditionalTextPanel(stringBuilder.toString().trim());
                    this.fitTextIntoAvailableSpaceInTextPanel(textPanelHelper, (JTextComponent)jPanel.getComponent(0), n, string);
                }
            }
            return n - n2;
        }
        if (n2 > n) {
            textPanelHelper.createPage(string);
            n = textPanelHelper.pageHeight;
        }
        this.doLayout(textPanelHelper.currentPanel);
        n2 = (int)jComponent.getPreferredSize().getHeight();
        return n -= n2;
    }

    protected double getPageFitScale(float f, float f2, float f3, JComponent jComponent) {
        double d;
        double d2 = (f - f3 * 2.0f) / (float)jComponent.getWidth();
        double d3 = Math.min(d2, d = (double)((f2 - f3 * 2.0f) / (float)jComponent.getHeight()));
        d3 = d3 < 1.0 ? d3 : 1.0;
        return d3;
    }

    protected double getPageFitScale(Rectangle rectangle, int n) {
        float f = rectangle.getWidth();
        float f2 = rectangle.getHeight();
        double d = Math.min((f - (float)(n * 2)) / (float)this.offlinePDFView.getWidth(), (f2 - (float)(n * 2)) / (float)this.offlinePDFView.getHeight());
        d = d < 1.0 ? d : 1.0;
        return d;
    }

    protected int getPdfPageMargin() {
        return 40;
    }

    protected Rectangle getPdfPageSize() {
        return defaultPdfPageSize;
    }

    private void innerDoLayout(Component component) {
        component.addNotify();
        component.doLayout();
        if (component.getParent() != null) {
            component.getParent().doLayout();
        }
        if (component instanceof Container) {
            Component[] componentArray;
            for (Component component2 : componentArray = ((Container)component).getComponents()) {
                this.innerDoLayout(component2);
            }
        }
    }

    public void setOfflinePDFView(SummaryFeedbackView summaryFeedbackView) {
        this.offlinePDFView = summaryFeedbackView;
    }

    public static enum TextFitEnum {
        TextDoesNotFitInComponent,
        TextFitsInComponent;

    }

    public static class TextFillParams {
        private int heightNeeded;
        private int idx;

        public TextFillParams() {
        }

        public int getHeightNeeded() {
            return this.heightNeeded;
        }

        public int getIdx() {
            return this.idx;
        }

        public void setHeightNeeded(int n) {
            this.heightNeeded = n;
        }

        public void setIdx(int n) {
            this.idx = n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof TextFillParams)) {
                return false;
            }
            TextFillParams textFillParams = (TextFillParams)object;
            if (!textFillParams.canEqual(this)) {
                return false;
            }
            if (this.getHeightNeeded() != textFillParams.getHeightNeeded()) {
                return false;
            }
            return this.getIdx() == textFillParams.getIdx();
        }

        protected boolean canEqual(Object object) {
            return object instanceof TextFillParams;
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + this.getHeightNeeded();
            n = n * 59 + this.getIdx();
            return n;
        }

        public String toString() {
            return "DefaultPdfExporter.TextFillParams(heightNeeded=" + this.getHeightNeeded() + ", idx=" + this.getIdx() + ")";
        }

        public TextFillParams(int n, int n2) {
            this.heightNeeded = n;
            this.idx = n2;
        }
    }
}

