/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.summaryfeedback.FieldInfo;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.valuetypes.Angle;
import alma.valuetypes.DataRate;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import java.util.Optional;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.StringUtils;

public class FieldInfoTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 627083599435006213L;
    private ScienceGoalSummaryParameters document;
    private final Array array;
    private final String[] longvalues = new String[]{"xxxxxxxxxxxxxxxx", "xxxxxxxxxxxxxxxx", "xxxxxxxxxxxxxxxx", "xxxxxxxxxxxxxxxx", "xxxxxxxxxxxxxxxx", "xxxxxxxxxxxxxxxx", "xxxxxxxxxxxxxxxx", "xxxxxxxxxxxxxxxx", "xxxxxxxxxxxxxxxx", "xxxxx"};

    public FieldInfoTableModel(Array array) {
        this.array = array;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return FieldInfoCols.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public String getColumnName(int n) {
        FieldInfoCols fieldInfoCols = FieldInfoCols.getColumnDescriptor(n);
        if (FieldInfoCols.TOTALTIME == fieldInfoCols) {
            if (Array.ARRAY_12M == this.array) {
                return fieldInfoCols.getColumnName() + "(all configs)";
            }
            if (Array.ARRAY_7M == this.array) {
                return fieldInfoCols.getColumnName() + "(ACA)";
            }
            return fieldInfoCols.getColumnName();
        }
        if (FieldInfoCols.SCIENCETIME == fieldInfoCols) {
            if (Array.ARRAY_12M == this.array) {
                return FieldInfoCols.SCIENCETIME.getColumnName() + this.configurationName();
            }
            if (Array.ARRAY_7M == this.array) {
                return "t_total(7m)";
            }
            return fieldInfoCols.getColumnName();
        }
        if (FieldInfoCols.SPACING == fieldInfoCols) {
            if (Array.ARRAY_12M == this.array) {
                return "12m " + fieldInfoCols.getColumnName();
            }
            if (Array.ARRAY_7M == this.array) {
                return "7m " + fieldInfoCols.getColumnName();
            }
            return fieldInfoCols.getColumnName();
        }
        if (FieldInfoCols.NPOINTINGS == fieldInfoCols) {
            if (Array.ARRAY_12M == this.array) {
                return "#12m " + fieldInfoCols.getColumnName();
            }
            if (Array.ARRAY_7M == this.array) {
                return "#7m " + fieldInfoCols.getColumnName();
            }
            return fieldInfoCols.getColumnName();
        }
        if (FieldInfoCols.OTHERTIME == fieldInfoCols) {
            if (Array.ARRAY_7M == this.array) {
                return "t_total(TP)";
            }
            return FieldInfoCols.OTHERTIME.getColumnName() + this.configurationName();
        }
        return fieldInfoCols.getColumnName();
    }

    private String configurationName() {
        if (this.document != null) {
            try {
                ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(this.document.getScienceGoal());
                assert (scienceGoalConfigurations != null);
                if (scienceGoalConfigurations.isEmpty() || ((ConfigurationSet)scienceGoalConfigurations.get(0)).getTM2Configuration() == null) {
                    return "(2)";
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (ConfigurationSet configurationSet : scienceGoalConfigurations) {
                    Optional<Configuration> optional = configurationSet.getTM2Configuration();
                    if (!optional.isPresent()) continue;
                    stringBuilder.append(optional.get().getCanonicalName() + ",");
                }
                return "(" + StringUtils.chop((String)stringBuilder.toString()) + ")";
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                return "(2)";
            }
        }
        return "(2)";
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ScienceGoalSummaryParameters scienceGoalSummaryParameters = this.getParameters();
        FieldInfoCols fieldInfoCols = FieldInfoCols.getColumnDescriptor(n2);
        if (scienceGoalSummaryParameters == null) {
            return null;
        }
        ScienceGoalSummaryParameters.ArrayScanType arrayScanType = this.getArrayScanType(n);
        FieldInfo fieldInfo = scienceGoalSummaryParameters.fieldInfoList.get((Object)arrayScanType);
        if (fieldInfo == null) {
            return null;
        }
        switch (fieldInfoCols) {
            case TOTALTIME: {
                fieldInfo.totalTime.convertToUnit(Time.UNIT_H);
                return fieldInfo.totalTime;
            }
            case SCIENCETIME: {
                fieldInfo.sciTime.convertToUnit(Time.UNIT_H);
                return fieldInfo.sciTime;
            }
            case OTHERTIME: {
                fieldInfo.otherTime.convertToUnit(Time.UNIT_H);
                return fieldInfo.otherTime;
            }
            case TIMEPERPOINT: {
                return fieldInfo.ppTime.convertToFriendlyUnit();
            }
            case MAPSIZE: {
                return scienceGoalSummaryParameters.isMosaic ? fieldInfo.areaSize : fieldInfo.hpbw.divide(3.0);
            }
            case NPOINTINGS: {
                return fieldInfo.nPointings;
            }
            case SPACING: {
                return fieldInfo.spacing;
            }
            case HPBW: {
                return fieldInfo.hpbw;
            }
            case DATAVOLUME: {
                return fieldInfo.dataVolume.convertToFriendlyUnit();
            }
            case DATARATE: {
                return fieldInfo.dataRate;
            }
        }
        return null;
    }

    public String[] getLongValues() {
        return this.longvalues;
    }

    public ScienceGoalSummaryParameters getParameters() {
        return this.document;
    }

    public void setDocument(ScienceGoalSummaryParameters scienceGoalSummaryParameters) {
        this.document = scienceGoalSummaryParameters;
    }

    private ScienceGoalSummaryParameters.ArrayScanType getArrayScanType(int n) {
        switch (this.array) {
            case ARRAY_12M: {
                return ScienceGoalSummaryParameters.ArrayScanType.ARRAY_12M_SMI;
            }
            case ARRAY_7M: {
                return ScienceGoalSummaryParameters.ArrayScanType.ARRAY_7M_SMI;
            }
            case ARRAY_TP: {
                return ScienceGoalSummaryParameters.ArrayScanType.ARRAY_TP_OTF;
            }
        }
        throw new IllegalArgumentException("Unknown array : " + String.valueOf((Object)this.array));
    }

    public static enum FieldInfoCols {
        TOTALTIME("t_total", Time.class),
        SCIENCETIME("t_science", Time.class),
        OTHERTIME("t_total", Time.class),
        MAPSIZE("Imaged area", ScienceGoalSummaryParameters.Angle2D.class),
        NPOINTINGS("pointing", Integer.class),
        SPACING("Mosaic spacing", String.class),
        HPBW("HPBW", Angle.class),
        TIMEPERPOINT("t_per_point", Time.class),
        DATAVOLUME("Data Vol", StorageVolume.class),
        DATARATE("Avg. Data Rate", DataRate.class);

        public final String columnName;
        public final Class<?> columnClass;

        protected static int getColumnCount() {
            return FieldInfoCols.values().length;
        }

        protected static FieldInfoCols getColumnDescriptor(int n) {
            return FieldInfoCols.values()[n];
        }

        private FieldInfoCols(String string2, Class<?> clazz) {
            this.columnName = string2;
            this.columnClass = clazz;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }
    }
}

