/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.services.summaryfeedback.FieldInfoTableModel;
import alma.obsprep.services.summaryfeedback.SgControlTableModel;
import alma.obsprep.services.summaryfeedback.SingleContinuumSetupTableModel;
import alma.obsprep.services.summaryfeedback.SourcePropertiesTableModel;
import alma.obsprep.services.summaryfeedback.SpectralLineSetupTableModel;
import alma.obsprep.services.summaryfeedback.SpectralScanSetupTableModel;
import alma.obsprep.services.summaryfeedback.SpectralScanTuningsTableModel;
import alma.obsprep.services.summaryfeedback.SpectralTuningsTableModel;
import alma.obsprep.services.summaryfeedback.SummaryTableCellRendererFactory;
import alma.obsprep.services.summaryfeedback.TargetListTableModel;
import alma.valuetypes.Angle;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ScienceGoalSummaryTableFactory {
    private final SummaryTableCellRendererFactory rendererFactory = new SummaryTableCellRendererFactory();

    protected Table makeTable(TableModel tableModel) {
        Table table = new Table(tableModel);
        table.getTableHeader().setReorderingAllowed(false);
        table.setRowSelectionAllowed(false);
        table.getColumnModel().setColumnSelectionAllowed(false);
        table.setCellSelectionEnabled(false);
        return table;
    }

    public JTable createScienceGoalControlTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((SgControlTableModel)tableModel).getLongValues());
        for (SgControlTableModel.SgControlCols sgControlCols : SgControlTableModel.SgControlCols.values()) {
            int n = sgControlCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer = switch (sgControlCols) {
                case SgControlTableModel.SgControlCols.RESOLUTION -> this.rendererFactory.getAngularResolutionRenderer("%.4f\"", Angle.UNIT_ARCSEC);
                case SgControlTableModel.SgControlCols.LARGESTSTRUCTURE -> this.rendererFactory.getVupRenderer("%.1f\"", Angle.UNIT_ARCSEC);
                case SgControlTableModel.SgControlCols.SENSITIVITY -> this.rendererFactory.getARRangeSensitivityRenderer("###0.###", "###0.#");
                case SgControlTableModel.SgControlCols.REPFREQUENCY -> this.rendererFactory.getVupRenderer("%.6f %s", Frequency.UNIT_GHZ);
                case SgControlTableModel.SgControlCols.REFERENCEWIDTH -> this.rendererFactory.getUserFrequencyRenderer("###0.###", "###0.#");
                case SgControlTableModel.SgControlCols.CONTRMS -> this.rendererFactory.getARRangeSensitivityRenderer("###0.###", "###0.#");
                case SgControlTableModel.SgControlCols.CONTBANDWIDTH -> this.rendererFactory.getVupRenderer("%.3f %s");
                default -> this.rendererFactory.getDefaultRenderer();
            };
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createFieldInfoTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((FieldInfoTableModel)tableModel).getLongValues());
        for (FieldInfoTableModel.FieldInfoCols fieldInfoCols : FieldInfoTableModel.FieldInfoCols.values()) {
            int n = fieldInfoCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer = switch (fieldInfoCols) {
                case FieldInfoTableModel.FieldInfoCols.MAPSIZE -> this.rendererFactory.getAreaSizeRenderer();
                case FieldInfoTableModel.FieldInfoCols.SPACING -> this.rendererFactory.getMosaicSpacingRenderer();
                case FieldInfoTableModel.FieldInfoCols.HPBW -> this.rendererFactory.getArcsecRenderer("%.1f");
                case FieldInfoTableModel.FieldInfoCols.TOTALTIME, FieldInfoTableModel.FieldInfoCols.OTHERTIME, FieldInfoTableModel.FieldInfoCols.SCIENCETIME -> this.rendererFactory.getVupRenderer("%.1f %s", Time.UNIT_H, true);
                case FieldInfoTableModel.FieldInfoCols.TIMEPERPOINT -> this.rendererFactory.getVupRenderer("%.1f %s", Time.UNIT_S, true);
                case FieldInfoTableModel.FieldInfoCols.DATAVOLUME -> this.rendererFactory.getVupRenderer("%.1f %s", StorageVolume.UNIT_GB);
                case FieldInfoTableModel.FieldInfoCols.DATARATE -> this.rendererFactory.getVupRenderer("%.1f %s", DataRate.UNIT_MB_S);
                default -> this.rendererFactory.getDefaultRenderer();
            };
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createTargetListTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((TargetListTableModel)tableModel).getLongValues());
        for (TargetListTableModel.TargetListCols targetListCols : TargetListTableModel.TargetListCols.values()) {
            int n = targetListCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer = switch (targetListCols) {
                case TargetListTableModel.TargetListCols.TARGETNAME -> this.rendererFactory.getLeftAlignmentRenderer();
                case TargetListTableModel.TargetListCols.SKYCOORDINATES -> this.rendererFactory.getSkyCoordinatesRenderer();
                case TargetListTableModel.TargetListCols.VELOCITY -> this.rendererFactory.getVelocityRenderer();
                default -> this.rendererFactory.getDefaultRenderer();
            };
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createSourcePropertiesTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((SourcePropertiesTableModel)tableModel).getLongValues());
        for (SourcePropertiesTableModel.SourcePropertiesCols sourcePropertiesCols : SourcePropertiesTableModel.SourcePropertiesCols.values()) {
            int n = sourcePropertiesCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer = switch (sourcePropertiesCols) {
                case SourcePropertiesTableModel.SourcePropertiesCols.LINEWIDTH -> this.rendererFactory.getVupRenderer("%.0f %s", Speed.UNIT_KM_S);
                case SourcePropertiesTableModel.SourcePropertiesCols.PEAKFLUX -> this.rendererFactory.getFluxRenderer();
                case SourcePropertiesTableModel.SourcePropertiesCols.POLARIZATION -> this.rendererFactory.getPolarizationRenderer();
                case SourcePropertiesTableModel.SourcePropertiesCols.SNR, SourcePropertiesTableModel.SourcePropertiesCols.POLSNR -> this.rendererFactory.getSimpleValueRenderer("%.1f");
                case SourcePropertiesTableModel.SourcePropertiesCols.REQLINERMS -> this.rendererFactory.getSensitivityRenderer("###0.##", "###0.#");
                case SourcePropertiesTableModel.SourcePropertiesCols.WIDTHRATIO -> this.rendererFactory.getSignificantDigitRenderer();
                default -> this.rendererFactory.getDefaultRenderer();
            };
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createSpectralLineSetupTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((SpectralLineSetupTableModel)tableModel).getLongValues());
        for (SpectralLineSetupTableModel.SpectralLineSetupCols spectralLineSetupCols : SpectralLineSetupTableModel.SpectralLineSetupCols.values()) {
            int n = spectralLineSetupCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer = switch (spectralLineSetupCols) {
                case SpectralLineSetupTableModel.SpectralLineSetupCols.RESTFREQUENCY -> this.rendererFactory.getSimpleValueRenderer("%.6f");
                case SpectralLineSetupTableModel.SpectralLineSetupCols.BANDWIDTH -> this.rendererFactory.getVupRenderer("%.2f %s", Frequency.UNIT_MHZ);
                case SpectralLineSetupTableModel.SpectralLineSetupCols.RESOLUTION -> this.rendererFactory.getVupRenderer("%.3f %s", Frequency.UNIT_MHZ);
                case SpectralLineSetupTableModel.SpectralLineSetupCols.VELWIDTH -> this.rendererFactory.getVupRenderer("%.1f %s", Speed.UNIT_KM_S);
                case SpectralLineSetupTableModel.SpectralLineSetupCols.VELRES -> this.rendererFactory.getVupRenderer("%.3f %s", Speed.UNIT_KM_S);
                case SpectralLineSetupTableModel.SpectralLineSetupCols.RESEL -> this.rendererFactory.getSimpleValueRenderer("%.0f");
                default -> this.rendererFactory.getDefaultRenderer();
            };
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createSingleContinuumSetupTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((SingleContinuumSetupTableModel)tableModel).getLongValues());
        for (SingleContinuumSetupTableModel.SingleContinuumSetupCols singleContinuumSetupCols : SingleContinuumSetupTableModel.SingleContinuumSetupCols.values()) {
            TableColumn tableColumn = table.getColumnModel().getColumn(singleContinuumSetupCols.ordinal());
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer = switch (singleContinuumSetupCols) {
                case SingleContinuumSetupTableModel.SingleContinuumSetupCols.CENTERFREQSKY -> this.rendererFactory.getSingleContinuumSkyFrequencyRenderer("%.6f");
                case SingleContinuumSetupTableModel.SingleContinuumSetupCols.SPWFREQSKY -> this.rendererFactory.getSimpleValueRenderer("%.6f");
                case SingleContinuumSetupTableModel.SingleContinuumSetupCols.BANDWIDTH -> this.rendererFactory.getVupRenderer("%.2f %s", Frequency.UNIT_MHZ);
                case SingleContinuumSetupTableModel.SingleContinuumSetupCols.RESOLUTION -> this.rendererFactory.getVupRenderer("%.3f %s", Frequency.UNIT_MHZ);
                case SingleContinuumSetupTableModel.SingleContinuumSetupCols.VELWIDTH -> this.rendererFactory.getVupRenderer("%.1f %s", Speed.UNIT_KM_S);
                case SingleContinuumSetupTableModel.SingleContinuumSetupCols.VELRESOLUTION -> this.rendererFactory.getVupRenderer("%.3f %s", Speed.UNIT_KM_S);
                case SingleContinuumSetupTableModel.SingleContinuumSetupCols.RMS -> this.rendererFactory.getSensitivityRenderer("###0.##", "###0.0");
                default -> this.rendererFactory.getDefaultRenderer();
            };
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createTuningsTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((SpectralTuningsTableModel)tableModel).getLongValues());
        for (SpectralTuningsTableModel.TuningCols tuningCols : SpectralTuningsTableModel.TuningCols.values()) {
            int n = tuningCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer = switch (tuningCols) {
                case SpectralTuningsTableModel.TuningCols.TUNING -> this.rendererFactory.getSimpleValueRenderer("%d");
                case SpectralTuningsTableModel.TuningCols.TARGET -> this.rendererFactory.getSimpleValueRenderer("%s");
                case SpectralTuningsTableModel.TuningCols.FREQUENCY -> this.rendererFactory.getVupRenderer("%.6f", Frequency.UNIT_GHZ);
                case SpectralTuningsTableModel.TuningCols.RMS -> this.rendererFactory.getSensitivityRenderer("###0.##", "###0.0");
                case SpectralTuningsTableModel.TuningCols.RMSRANGE -> this.rendererFactory.getSensitivityRangeRenderer();
                default -> this.rendererFactory.getDefaultRenderer();
            };
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createSpectralScanSetupTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((SpectralScanSetupTableModel)tableModel).getLongValues());
        for (SpectralScanSetupTableModel.SpectralScanSetupCols spectralScanSetupCols : SpectralScanSetupTableModel.SpectralScanSetupCols.values()) {
            int n = spectralScanSetupCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer = switch (spectralScanSetupCols) {
                case SpectralScanSetupTableModel.SpectralScanSetupCols.STARTFREQUENCY, SpectralScanSetupTableModel.SpectralScanSetupCols.ENDFREQUENCY -> this.rendererFactory.getVupRenderer("%.3f %s", Frequency.UNIT_GHZ);
                case SpectralScanSetupTableModel.SpectralScanSetupCols.RESOLUTION -> this.rendererFactory.getVupRenderer("%.3f %s", Frequency.UNIT_MHZ);
                case SpectralScanSetupTableModel.SpectralScanSetupCols.VELWIDTH -> this.rendererFactory.getVupRenderer("%.0f %s", Speed.UNIT_KM_S);
                case SpectralScanSetupTableModel.SpectralScanSetupCols.VELRESOLUTION -> this.rendererFactory.getVupRenderer("%.3f %s", Speed.UNIT_KM_S);
                case SpectralScanSetupTableModel.SpectralScanSetupCols.RESEL -> this.rendererFactory.getSimpleValueRenderer("%.1f");
                case SpectralScanSetupTableModel.SpectralScanSetupCols.RMS -> this.rendererFactory.getSensitivityRenderer("###0.##", "###0.0");
                default -> this.rendererFactory.getDefaultRenderer();
            };
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }

    public JTable createScanTuningsTable(TableModel tableModel) {
        Table table = this.makeTable(tableModel);
        ColumnResizer.initColumnSizes(table, ((SpectralScanTuningsTableModel)tableModel).getLongValues());
        for (SpectralScanTuningsTableModel.ScanTuningCols scanTuningCols : SpectralScanTuningsTableModel.ScanTuningCols.values()) {
            int n = scanTuningCols.ordinal();
            TableColumn tableColumn = table.getColumnModel().getColumn(n);
            SummaryTableCellRendererFactory.SummaryTableCellRenderer summaryTableCellRenderer = switch (scanTuningCols) {
                case SpectralScanTuningsTableModel.ScanTuningCols.SPW1, SpectralScanTuningsTableModel.ScanTuningCols.SPW2, SpectralScanTuningsTableModel.ScanTuningCols.SPW3, SpectralScanTuningsTableModel.ScanTuningCols.SPW4 -> this.rendererFactory.getVupRenderer("%.6f");
                default -> this.rendererFactory.getDefaultRenderer();
            };
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
        return table;
    }
}

