/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.summaryfeedback.TuningInfo;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Speed;
import alma.valuetypes.Time;
import alma.valuetypes.UserSensitivity;
import javax.swing.table.AbstractTableModel;

public class SingleContinuumSetupTableModel
extends AbstractTableModel {
    protected TuningInfo tuningInfo;
    private String[] longValues = new String[]{" 100.123456 ", " 100.123456 ", " 128 ", " 1875.0 MHz ", " 15.63 MHz ", " xxxxx.x km/s ", "xxx.xxx km/s", " xxxx.xx mJy, xxx.x mK "};

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.tuningInfo == null ? 0 : this.tuningInfo.getNumSpectralWindows() * this.tuningInfo.getNumTunings();
    }

    public TuningInfo getParameters() {
        return this.tuningInfo;
    }

    public void setDocument(TuningInfo tuningInfo) {
        this.tuningInfo = tuningInfo;
    }

    @Override
    public int getColumnCount() {
        return SingleContinuumSetupCols.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return SingleContinuumSetupCols.getColumnDescriptor(n).getColumnName();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.tuningInfo == null) {
            return null;
        }
        int n3 = this.tuningInfo.getNumTunings();
        if (n % n3 != 0) {
            return null;
        }
        int n4 = n / n3;
        ScienceSpectralWindow scienceSpectralWindow = this.tuningInfo.sortedWindowList.get(n4);
        if (scienceSpectralWindow == null) {
            return null;
        }
        SingleContinuumSetupCols singleContinuumSetupCols = SingleContinuumSetupCols.getColumnDescriptor(n2);
        switch (singleContinuumSetupCols) {
            case CENTERFREQSKY: {
                if (n == 0) {
                    return this.tuningInfo.ssp.getSingleContinuumFrequency();
                }
                return null;
            }
            case SPWFREQSKY: {
                return scienceSpectralWindow.getCenterFrequency().getContentInGHz();
            }
            case VELWIDTH: {
                return Speed.getSpeedResolution(scienceSpectralWindow.getEffectiveBandwidth(), scienceSpectralWindow.getCenterFrequencySky());
            }
            case VELRESOLUTION: {
                return Speed.getSpeedResolution((Frequency)((Object)scienceSpectralWindow.getSpectralResolutionSmoothed()), scienceSpectralWindow.getCenterFrequencySky());
            }
            case RMS: {
                Frequency frequency = scienceSpectralWindow.getCenterFrequency();
                ScienceGoal scienceGoal = scienceSpectralWindow.getSpectralSetupParameters().getScienceGoal();
                try {
                    TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
                    Array array = scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M;
                    Time time = scienceGoal.getSinglePointOnSourceTime(array, targetParameters);
                    int n5 = CorrPolarization.getCorrPolarization(scienceSpectralWindow.getSpectralSetupParameters().getPolarisation()).getObsCount();
                    Sensitivity sensitivity = scienceGoal.getSinglePointOnSourceSensitivity(array, time, targetParameters, frequency, (Frequency)scienceSpectralWindow.getEffectiveBandwidth().multiply(n5));
                    UserSensitivity userSensitivity = UserSensitivity.createUserSensitivity(sensitivity.getContent(), sensitivity.getUnit());
                    userSensitivity.setObservingFrequency(frequency);
                    userSensitivity.setBeamsize((Angle)((Object)scienceGoal.getPerformanceParameters().getDesiredAngularResolution()));
                    return userSensitivity;
                }
                catch (SourceNeverVisibleException | InvalidFrequencyException | InvalidObsProgramParametersException exception) {
                    return null;
                }
            }
            case NCHANNELS: {
                return scienceSpectralWindow.getCorrConfigMode().getEffectiveChannels();
            }
            case BANDWIDTH: {
                return scienceSpectralWindow.getCorrConfigMode().getEffectiveBandwidth();
            }
            case RESOLUTION: {
                return scienceSpectralWindow.getSpectralResolutionSmoothed();
            }
        }
        return null;
    }

    public String[] getLongValues() {
        return this.longValues;
    }

    public static enum SingleContinuumSetupCols {
        CENTERFREQSKY("<html>Center Freq<br>(Sky)</html>", Double.class),
        SPWFREQSKY("<html>Center Freqs.<br>SPWs</html>", Double.class),
        NCHANNELS("<html>&nbsp;Eff #Ch&nbsp;<br>&nbsp;p.p.</html>", Integer.class),
        BANDWIDTH("Bandwidth", Frequency.class),
        RESOLUTION("Resolution", Frequency.class),
        VELWIDTH("Vel. Bandwidth", Speed.class),
        VELRESOLUTION("Vel. Resolution", Speed.class),
        RMS("RMS", Sensitivity.class);

        public final String columnName;
        public final Class<?> columnClass;

        protected static int getColumnCount() {
            return SingleContinuumSetupCols.values().length;
        }

        protected static SingleContinuumSetupCols getColumnDescriptor(int n) {
            return SingleContinuumSetupCols.values()[n];
        }

        private SingleContinuumSetupCols(String string2, Class<?> clazz) {
            this.columnName = string2;
            this.columnClass = clazz;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }
    }
}

