/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.userlookup;

import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.submission.Codecs;
import alma.obsprep.services.submission.InOut;
import alma.obsprep.services.userlookup.HttpMarshaller;
import alma.obsprep.services.userlookup.JsonMarshaller;
import alma.obsprep.services.userlookup.User;
import alma.obsprep.services.userlookup.UserLookup;
import alma.obsprep.services.userlookup.UserLookupException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.httpclient.HttpException;

public class UserLookupRemote
implements UserLookup {
    private static final String WEBSERVICE_URL = "/ObsprepSubmissionService/UserLookup";
    private volatile String urlString;
    private final String userAgent = "ALMA-OT/" + InitServices.getFullAlmaVersion();

    public void setUrl(String string) {
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        String string2 = WEBSERVICE_URL;
        while (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this.urlString = string + string2;
    }

    @Override
    public List<User> matchEmail(String[] stringArray) throws UserLookupException {
        MatchStrings matchStrings = new MatchStrings("Email", stringArray);
        return this.match(matchStrings);
    }

    @Override
    public List<User> matchName(String[] stringArray) throws UserLookupException {
        MatchStrings matchStrings = new MatchStrings("Name", stringArray);
        return this.match(matchStrings);
    }

    @Override
    public List<User> matchUid(String[] stringArray) throws UserLookupException {
        MatchStrings matchStrings = new MatchStrings("Uid", stringArray);
        return this.match(matchStrings);
    }

    @Override
    public boolean isContactScientist(String string, String string2) throws UnableToDetermineRoleException {
        ContactScientistCheck contactScientistCheck = new ContactScientistCheck(string, string2);
        Boolean bl = this.checkRoleOnProject(contactScientistCheck);
        return Boolean.TRUE.equals(bl);
    }

    @Override
    public boolean isPhase2Delegee(String string, String string2) throws UnableToDetermineRoleException {
        Phase2DelegeeCheck phase2DelegeeCheck = new Phase2DelegeeCheck(string, string2);
        Boolean bl = this.checkRoleOnProject(phase2DelegeeCheck);
        return Boolean.TRUE.equals(bl);
    }

    protected List<User> match(HttpMarshaller.HttpMarshallable httpMarshallable) throws UserLookupException {
        String string = "";
        try {
            string = "send";
            Codecs.ResponseDecoder responseDecoder = this.send(httpMarshallable);
            string = "decode";
            String string2 = responseDecoder.decodeAsString();
            JsonMarshaller jsonMarshaller = new JsonMarshaller(User.class);
            List list = jsonMarshaller.fromJsonCollection(List.class, string2);
            return list;
        }
        catch (UserLookupException userLookupException) {
            throw userLookupException;
        }
        catch (Exception exception) {
            throw new UserLookupException("Failure processing match request, couldn't " + string + ": " + String.valueOf(exception), exception);
        }
    }

    protected Boolean checkRoleOnProject(HttpMarshaller.HttpMarshallable httpMarshallable) throws UnableToDetermineRoleException {
        try {
            Codecs.ResponseDecoder responseDecoder = this.send(httpMarshallable);
            String string = responseDecoder.decodeAsString();
            JsonMarshaller jsonMarshaller = new JsonMarshaller(Boolean.class);
            Boolean bl = (Boolean)jsonMarshaller.fromJSON(string);
            return bl;
        }
        catch (Exception exception) {
            throw new UnableToDetermineRoleException(exception);
        }
    }

    Codecs.ResponseDecoder send(HttpMarshaller.HttpMarshallable httpMarshallable) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, HttpException, IOException, UserLookupException {
        String string = httpMarshallable.getClass().getSimpleName();
        String string2 = "?action=" + string;
        InOut.RequestCharacteristics requestCharacteristics = new InOut.RequestCharacteristics();
        requestCharacteristics.urlString = this.urlString + string2;
        requestCharacteristics.userAgent = this.userAgent;
        HttpMarshaller httpMarshaller = new HttpMarshaller();
        Codecs.PostEncoder postEncoder = httpMarshaller.toHttp(requestCharacteristics, httpMarshallable);
        postEncoder.send_resimplified(null, null, null);
        Codecs.ResponseDecoder responseDecoder = new Codecs.ResponseDecoder(postEncoder.getResponse());
        if (!postEncoder.isOk()) {
            String string3 = responseDecoder.decodeAsHtml();
            throw new UserLookupException(postEncoder.getStatusCode() + " -- " + string3);
        }
        return responseDecoder;
    }

    public static void main(String[] stringArray) {
        try {
            UserLookupRemote userLookupRemote = new UserLookupRemote();
            userLookupRemote.setUrl("http://localhost:8080");
            String[] stringArray2 = new String[]{"joh", "ingo"};
            List<User> list = userLookupRemote.matchName(stringArray2);
            for (User user : list) {
                System.out.println(user.getUid() + ": " + user.getFullName());
            }
        }
        catch (UserLookupException userLookupException) {
            userLookupException.printStackTrace();
        }
    }

    public static class MatchStrings
    implements HttpMarshaller.HttpMarshallable {
        public static final String MATCH_EMAIL = "Email";
        public static final String MATCH_NAME = "Name";
        public static final String MATCH_UID = "Uid";
        public String searchVariant;
        public String[] searchStrings;

        public MatchStrings() {
        }

        public MatchStrings(String string, String[] stringArray) {
            this.searchVariant = string;
            this.searchStrings = stringArray;
        }
    }

    public static class ContactScientistCheck
    implements HttpMarshaller.HttpMarshallable {
        public String projectUid;
        public String userUid;

        public ContactScientistCheck() {
        }

        public ContactScientistCheck(String string, String string2) {
            this.projectUid = string;
            this.userUid = string2;
        }
    }

    public static class Phase2DelegeeCheck
    implements HttpMarshaller.HttpMarshallable {
        public String projectCode;
        public String userUid;

        public Phase2DelegeeCheck() {
        }

        public Phase2DelegeeCheck(String string, String string2) {
            this.projectCode = string;
            this.userUid = string2;
        }
    }

    public class UnableToDetermineRoleException
    extends Exception {
        public UnableToDetermineRoleException(Exception exception) {
            super(exception);
        }
    }
}

