/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnitException;
import alma.hla.runtime.obsprep.util.UnitMap;
import alma.obsprep.util.FrequencyDependentUnitMap;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserUnitValueUnitPair;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UserFrequencyUnitMap
extends FrequencyDependentUnitMap {
    private final Set<String> frequencyDependingUnits = new HashSet<String>();
    private static final double SMALL_ENOUGH_TOLERANCE_TO_HANDLE_BIG_Z = 3.335640951981521E-14;

    public UserFrequencyUnitMap(UserUnitValueUnitPair userUnitValueUnitPair) {
        super(userUnitValueUnitPair);
    }

    @Override
    protected void initializeUnitMap() {
        UnitMap unitMap = UnitMap.getFrequencyUnits();
        this.putAll((Map)unitMap);
        this.setDefaultUnit(unitMap.getDefaultUnit());
        if (this.isNonModelUnitsAccepted) {
            this.addNonModelUnits();
        }
    }

    @Override
    protected UnitMap getStaticNonModelUnitMap() {
        UnitMap unitMap = new UnitMap();
        UnitMap unitMap2 = UnitMap.getSpeedUnits();
        for (String string : UserFrequency.getKnownUserUnitList()) {
            if (!unitMap2.containsKey((Object)string)) continue;
            unitMap.put((Object)string, unitMap2.get((Object)string));
            this.frequencyDependingUnits.add(string);
        }
        return unitMap;
    }

    @Override
    protected void updateNonModelUnitsScale() throws UnitException {
        double d = this.getScale(Frequency.UNIT_GHZ);
        Speed speed = Speed.createSpeed();
        speed.setContent(1.0);
        Frequency frequency = Frequency.getFrequencyResolution(speed, this.getNonZeroObservingFrequency());
        double d2 = frequency.getContentInGHz();
        double d3 = d * d2;
        if (Math.abs(d3) < 3.335640951981521E-14) {
            Log.logger(UserFrequencyUnitMap.class).warning("Calculated scaling value for user units is too small");
            throw new UnitException("Calculated scaling value for user units is too small");
        }
        if (this.isNonModelUnitsAccepted) {
            UnitMap unitMap = this.getStaticNonModelUnitMap();
            Set set = unitMap.keySet();
            for (String string : set) {
                double d4 = d3 * unitMap.getScale(string);
                this.put(string, d4);
            }
        }
    }

    @Override
    public Set<String> getFrequencyDependingUnits() {
        return this.frequencyDependingUnits;
    }
}

