/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.task.LineInvoker;
import uk.ac.starlink.util.LoadException;

public class UsageWriter {
    private final OutputStream out_;
    private final String taskName_;
    private final Task task_;

    private UsageWriter(String taskName, OutputStream out) throws LoadException {
        this.out_ = out;
        this.taskName_ = taskName;
        this.task_ = (Task)Stilts.getTaskFactory().createObject(this.taskName_);
    }

    private void writeXml() throws IOException {
        String prefix = "   stilts <stilts-flags> " + this.taskName_;
        this.outln("<subsubsect id=\"" + this.taskName_ + "-usage\">");
        this.outln("<subhead><title>Usage</title></subhead>");
        this.outln("<p>The usage of <code>" + this.taskName_ + "</code> is");
        this.outln("<verbatim><![CDATA[");
        this.outln(LineInvoker.getPrefixedTaskUsage(this.task_, prefix).replaceFirst("\n+$", ""));
        this.outln("]]></verbatim>");
        this.outln("If you don't have the <code>stilts</code> script installed,");
        this.outln("write \"<code>java -jar stilts.jar</code>\" instead of");
        this.outln("\"<code>stilts</code>\" - see <ref id=\"invoke\"/>.");
        this.outln("The available <code>&lt;stilts-flags&gt;</code> are listed");
        this.outln("in <ref id=\"stilts-flags\"/>.");
        this.outln("</p>");
        this.outln();
        Parameter[] params = this.task_.getParameters();
        if (params.length > 0) {
            this.outln("<p>Parameter values are assigned on the command line");
            this.outln("as explained in <ref id=\"task-args\"/>.");
            this.outln("They are as follows:");
            this.outln("</p>");
            this.outln("<p>");
            this.outln("<dl>");
            Arrays.sort(params, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Parameter p1 = (Parameter)o1;
                    Parameter p2 = (Parameter)o2;
                    return ((Parameter)o1).getName().compareTo(((Parameter)o2).getName());
                }
            });
            for (int i = 0; i < params.length; ++i) {
                this.outln(UsageWriter.xmlItem(params[i]));
            }
            this.outln("</dl>");
            this.outln("</p>");
        } else {
            this.outln("<p>This task has no parameters.");
            this.outln("</p>");
        }
        this.outln("</subsubsect>");
    }

    public static String xmlItem(Parameter param) {
        String usage = (param.getName() + " = " + param.getUsage()).replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        String descrip = param.getDescription();
        if (descrip == null) {
            throw new NullPointerException("No description for parameter " + param);
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<dt><code>").append((param.getName() + " = " + param.getUsage()).replaceAll("<", "&lt;").replaceAll(">", "&gt;")).append("</code></dt>\n").append("<dd>").append(param.getDescription().toString());
        String dflt = param.getDefault();
        if (dflt != null && dflt.length() > 0) {
            sbuf.append("<p>[Default: <code>").append(dflt.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;")).append("</code>]</p>");
        }
        sbuf.append("</dd>");
        return sbuf.toString();
    }

    private void out(String text) throws IOException {
        this.out_.write(text.getBytes());
    }

    private void outln(String line) throws IOException {
        this.out(line + "\n");
    }

    private void outln() throws IOException {
        this.out("\n");
    }

    public static void main(String[] args) throws IOException, LoadException {
        if (args.length == 0) {
            String[] taskNames = Stilts.getTaskFactory().getNickNames();
            File dir = new File(".");
            for (int i = 0; i < taskNames.length; ++i) {
                String taskName = taskNames[i];
                String fname = taskName + "-summary.xml";
                File file = new File(dir, fname);
                System.out.println("Writing " + fname);
                OutputStream out = new FileOutputStream(file);
                out = new BufferedOutputStream(out);
                new UsageWriter(taskName, out).writeXml();
                out.close();
            }
        } else {
            new UsageWriter(args[0], System.out).writeXml();
        }
    }
}

