/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.cone.HealpixTiling;
import uk.ac.starlink.ttools.cone.HtmTiling;
import uk.ac.starlink.ttools.cone.SkyTiling;

public class TilingParameter
extends Parameter {
    private SkyTiling tiling_;
    private static final String HTM_PREFIX = "htm";
    private static final String HEALPIX_RING_PREFIX = "healpixring";
    private static final String HEALPIX_NEST_PREFIX = "healpixnest";

    public TilingParameter(String name) {
        super(name);
        this.setPrompt("Sky tiling scheme");
        this.setUsage("htm<level>|healpixnest<nside>|healpixring<nside>");
        this.setNullPermitted(true);
        this.setDescription(new String[]{"<p>Describes the sky tiling scheme that is in use.", "One of the following values may be used:", "<ul>", "<li><code>htm&lt;level&gt;</code>:", "Hierarchical Triangular Mesh with a level value of", "<code>level</code>.</li>", "<li><code>healpixnest&lt;nside&gt;</code>:", "HEALPix using the Nest scheme with an nside value of", "<code>nside</code>.</li>", "<li><code>healpixring&lt;nside&gt;</code>:", "HEALPix using the Ring scheme with an nside value of", "<code>nside</code>.</li>", "</ul>", "</p>"});
    }

    public void setValueFromString(Environment env, String value) throws TaskException {
        String lvalue = value.toLowerCase();
        if (lvalue.startsWith(HTM_PREFIX)) {
            int level = this.getNumberSuffix(value, HTM_PREFIX);
            this.tiling_ = new HtmTiling(level);
        } else if (lvalue.startsWith(HEALPIX_NEST_PREFIX)) {
            int nside = this.getNumberSuffix(value, HEALPIX_NEST_PREFIX);
            this.tiling_ = new HealpixTiling(nside, true);
        } else if (lvalue.startsWith(HEALPIX_RING_PREFIX)) {
            int nside = this.getNumberSuffix(value, HEALPIX_RING_PREFIX);
            this.tiling_ = new HealpixTiling(nside, false);
        } else {
            throw new ParameterValueException((Parameter)this, "Unknown tiling scheme \"" + value + "\"");
        }
        super.setValueFromString(env, value);
    }

    public SkyTiling tilingValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.tiling_;
    }

    private int getNumberSuffix(String value, String prefix) throws TaskException {
        String svalue = value.substring(prefix.length());
        try {
            return Integer.parseInt(svalue);
        }
        catch (NumberFormatException e) {
            throw new ParameterValueException((Parameter)this, "\"" + svalue + "\" " + "not numeric");
        }
    }
}

