/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.jel.DummyJELRowReader;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;

public class JELSelectorTable
extends WrapperStarTable {
    private final String expr_;
    private final StarTable baseTable_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JELSelectorTable(StarTable baseTable, String expr) throws CompilationException {
        super(baseTable);
        this.baseTable_ = baseTable;
        this.expr_ = expr;
        Library lib = JELUtils.getLibrary(new DummyJELRowReader(baseTable));
        JELUtils.checkExpressionType(lib, baseTable, expr, Boolean.TYPE);
    }

    public boolean isRandom() {
        return false;
    }

    public long getRowCount() {
        return -1L;
    }

    public RowSequence getRowSequence() throws IOException {
        CompiledExpression compEx;
        final SequentialJELRowReader jelSeq = new SequentialJELRowReader(this.baseTable_);
        try {
            compEx = JELUtils.compile(JELUtils.getLibrary(jelSeq), this.baseTable_, this.expr_, Boolean.TYPE);
        }
        catch (CompilationException e) {
            throw (IOException)new IOException("Bad expression: " + this.expr_).initCause(e);
        }
        if (!$assertionsDisabled && compEx.getType() != 0) {
            throw new AssertionError();
        }
        return new WrapperRowSequence(jelSeq){

            public boolean next() throws IOException {
                while (jelSeq.next()) {
                    if (!this.isIncluded()) continue;
                    return true;
                }
                return false;
            }

            private boolean isIncluded() throws IOException {
                Object val;
                try {
                    val = jelSeq.evaluate(compEx);
                }
                catch (Throwable e) {
                    throw (IOException)new IOException("Evaluation error").initCause(e);
                }
                Boolean bval = (Boolean)val;
                return bval != null && bval != false;
            }
        };
    }

    static {
        $assertionsDisabled = !JELSelectorTable.class.desiredAssertionStatus();
    }
}

