/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import uk.ac.starlink.table.Tables;

public abstract class QuantCalc {
    private final Class clazz_;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    protected QuantCalc(Class clazz) {
        if (!Number.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " not number");
        }
        this.clazz_ = clazz;
    }

    public abstract void acceptDatum(Object var1);

    public abstract void ready();

    public abstract Number getQuantile(double var1);

    public static QuantCalc createInstance(Class clazz, long nrow) throws IOException {
        if (clazz == Byte.class) {
            return new ByteSlotQuantCalc();
        }
        if (clazz == Short.class && (nrow < 0L || nrow > 65536L)) {
            return new ShortSlotQuantCalc();
        }
        if (clazz == Integer.class || clazz == Long.class) {
            return new CountMapQuantCalc(clazz);
        }
        if (nrow >= 0L && nrow < Integer.MAX_VALUE) {
            return new FloatArrayQuantCalc(clazz, (int)nrow);
        }
        if (nrow >= Integer.MAX_VALUE) {
            throw new IOException("Sorry, too many rows for quantile calculation (" + nrow + " > " + Integer.MAX_VALUE);
        }
        return new ObjectListQuantCalc(clazz);
    }

    static class CountMapQuantCalc
    extends QuantCalc {
        private final Class clazz_;
        private Map countMap_;
        private long count_;
        private static final Integer ONE = new Integer(1);

        public CountMapQuantCalc(Class clazz) {
            super(clazz);
            this.clazz_ = clazz;
            this.countMap_ = new HashMap();
        }

        public void acceptDatum(Object obj) {
            if (obj != null && obj.getClass() == this.clazz_ && !Tables.isBlank((Object)obj)) {
                ++this.count_;
                Integer value = (Integer)this.countMap_.get(obj);
                if (value == null) {
                    this.countMap_.put(obj, ONE);
                } else {
                    this.countMap_.put(obj, new Integer(value + 1));
                }
            }
        }

        public void ready() {
            this.countMap_ = new TreeMap(this.countMap_);
        }

        public Number getQuantile(double quant) {
            long point = Math.min((long)(quant * (double)this.count_), this.count_ - 1L);
            long nval = 0L;
            Iterator it = this.countMap_.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if ((nval += (long)((Integer)entry.getValue()).intValue()) <= point) continue;
                return (Number)entry.getKey();
            }
            return null;
        }
    }

    static class ShortSlotQuantCalc
    extends QuantCalc {
        private final int offset_ = 32768;
        private final int[] slots_ = new int[65536];
        private long count_;

        public ShortSlotQuantCalc() {
            super(class$java$lang$Short == null ? (class$java$lang$Short = QuantCalc.class$("java.lang.Short")) : class$java$lang$Short);
        }

        public void acceptDatum(Object obj) {
            if (obj instanceof Short) {
                short sval = (Short)obj;
                ++this.count_;
                int n = sval + 32768;
                this.slots_[n] = this.slots_[n] + 1;
            }
        }

        public void ready() {
        }

        public Number getQuantile(double quant) {
            long point = Math.min((long)(quant * (double)this.count_), this.count_ - 1L);
            long nval = 0L;
            for (short sval = Short.MIN_VALUE; sval < 32768; sval = (short)(sval + 1)) {
                if ((nval += (long)this.slots_[sval + 32768]) <= point) continue;
                return new Short(sval);
            }
            return null;
        }
    }

    static class ByteSlotQuantCalc
    extends QuantCalc {
        private final int offset_ = 128;
        private final int[] slots_ = new int[256];
        private long count_;

        public ByteSlotQuantCalc() {
            super(class$java$lang$Byte == null ? (class$java$lang$Byte = QuantCalc.class$("java.lang.Byte")) : class$java$lang$Byte);
        }

        public void acceptDatum(Object obj) {
            if (obj instanceof Byte) {
                byte bval = (Byte)obj;
                ++this.count_;
                int n = bval + 128;
                this.slots_[n] = this.slots_[n] + 1;
            }
        }

        public void ready() {
        }

        public Number getQuantile(double quant) {
            long point = Math.min((long)(quant * (double)this.count_), this.count_ - 1L);
            long nval = 0L;
            for (byte bval = -128; bval < 128; bval = (byte)(bval + 1)) {
                if ((nval += (long)this.slots_[bval + 128]) <= point) continue;
                return new Byte(bval);
            }
            return null;
        }
    }

    static class FloatArrayQuantCalc
    extends QuantCalc {
        final float[] array_;
        final Class clazz_;
        int irow_;

        public FloatArrayQuantCalc(Class clazz, int nrow) {
            super(clazz);
            this.clazz_ = clazz;
            this.array_ = new float[nrow];
        }

        public void acceptDatum(Object obj) {
            float fval;
            if (this.irow_ < this.array_.length && obj instanceof Number && !Float.isNaN(fval = ((Number)obj).floatValue())) {
                this.array_[this.irow_++] = fval;
            }
        }

        public void ready() {
            Arrays.sort(this.array_, 0, this.irow_);
        }

        public Number getQuantile(double quant) {
            if (this.irow_ == 0) {
                return null;
            }
            float quantile = this.array_[Math.min((int)(quant * (double)this.irow_), this.irow_ - 1)];
            if (this.clazz_ == (class$java$lang$Float == null ? (class$java$lang$Float = QuantCalc.class$("java.lang.Float")) : class$java$lang$Float) || this.clazz_ == (class$java$lang$Double == null ? (class$java$lang$Double = QuantCalc.class$("java.lang.Double")) : class$java$lang$Double)) {
                return new Float(quantile);
            }
            if (this.clazz_ == (class$java$lang$Byte == null ? (class$java$lang$Byte = QuantCalc.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return new Byte((byte)quantile);
            }
            if (this.clazz_ == (class$java$lang$Short == null ? (class$java$lang$Short = QuantCalc.class$("java.lang.Short")) : class$java$lang$Short)) {
                return new Short((short)quantile);
            }
            if (this.clazz_ == (class$java$lang$Integer == null ? (class$java$lang$Integer = QuantCalc.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return new Integer((int)quantile);
            }
            if (this.clazz_ == (class$java$lang$Long == null ? (class$java$lang$Long = QuantCalc.class$("java.lang.Long")) : class$java$lang$Long)) {
                return new Long((long)quantile);
            }
            return null;
        }
    }

    static class ObjectListQuantCalc
    extends QuantCalc {
        final Class clazz_;
        final List list_;

        public ObjectListQuantCalc(Class clazz) {
            super(clazz);
            this.clazz_ = clazz;
            this.list_ = new ArrayList();
        }

        public void acceptDatum(Object obj) {
            double dval;
            if (obj != null && obj.getClass().equals(this.clazz_) && !Double.isNaN(dval = ((Number)obj).doubleValue())) {
                this.list_.add(obj);
            }
        }

        public void ready() {
            Collections.sort(this.list_);
        }

        public Number getQuantile(double quant) {
            return this.list_.isEmpty() ? (Number)null : (Number)((Number)this.list_.get(Math.min((int)(quant * (double)this.list_.size()), this.list_.size() - 1)));
        }
    }
}

