/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.join;

import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.TaskException;

public class FindModeParameter
extends ChoiceParameter {
    public static final String BEST = "best";
    public static final String ALL = "all";

    public FindModeParameter(String name) {
        super(name, (Object[])new String[]{BEST, ALL});
        this.setDefault(BEST);
        this.setPrompt("Type of match to perform");
        this.setDescription(new String[]{"<p>Determines which matches are retained.", "If <code>best</code> is selected,", "then only the best match", "between the two tables will be retained; in this case", "the data from a row of either input table will appear in", "at most one row of the output table.", "If <code>all</code> is selected, then all pairs of rows", "from the two input tables which match the input criteria", "will be represented in the output table.", "</p>"});
    }

    public boolean bestOnlyValue(Environment env) throws TaskException {
        String mode = this.stringValue(env);
        if (BEST.equalsIgnoreCase(mode)) {
            return true;
        }
        if (ALL.equalsIgnoreCase(mode)) {
            return false;
        }
        throw new TaskException("Unknown value \"" + mode + "\" of " + this.getName() + " (shouldn't happen)");
    }
}

