/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.join;

import java.io.PrintStream;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.join.HEALPixMatchEngine;
import uk.ac.starlink.table.join.JoinType;
import uk.ac.starlink.table.join.NullProgressIndicator;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.SkyMatchEngine;
import uk.ac.starlink.table.join.TextProgressIndicator;
import uk.ac.starlink.task.DoubleParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.join.FindModeParameter;
import uk.ac.starlink.ttools.join.JoinTypeParameter;
import uk.ac.starlink.ttools.join.SkyMatch2Mapping;
import uk.ac.starlink.ttools.task.TableMapper;
import uk.ac.starlink.ttools.task.TableMapping;

public class SkyMatch2Mapper
implements TableMapper {
    private final Parameter[] raParams_ = new Parameter[2];
    private final Parameter[] decParams_ = new Parameter[2];
    private final DoubleParameter errorParam_;
    private final JoinTypeParameter joinParam_;
    private final FindModeParameter modeParam_;

    public SkyMatch2Mapper() {
        for (int i = 0; i < 2; ++i) {
            int i1 = i + 1;
            Parameter raParam = new Parameter("ra" + i1);
            Parameter decParam = new Parameter("dec" + i1);
            raParam.setUsage("<expr/degs>");
            decParam.setUsage("<expr/degs>");
            raParam.setPrompt("Expression for table " + i1 + " right ascension in degrees");
            decParam.setPrompt("Expression for table " + i1 + " declination in degrees");
            raParam.setNullPermitted(true);
            decParam.setNullPermitted(true);
            raParam.setDescription(new String[]{"<p>Value in degrees for the right ascension of positions in", "table " + i1 + " to be matched.", "This may simply be a column name, or it may be an", "algebraic expression calculated from columns as explained", "in <ref id='jel'/>.", "If left blank, an attempt is made to guess from UCDs,", "column names and unit annotations what expression to use.", "</p>"});
            decParam.setDescription(new String[]{"<p>Value in degrees for the declination of positions in", "table " + i1 + " to be matched.", "This may simply be a column name, or it may be an", "algebraic expression calculated from columns as explained", "in <ref id='jel'/>.", "If left blank, an attempt is made to guess from UCDs,", "column names and unit annotations what expression to use.", "</p>"});
            this.raParams_[i] = raParam;
            this.decParams_[i] = decParam;
        }
        this.errorParam_ = new DoubleParameter("error");
        this.errorParam_.setUsage("<value/arcsec>");
        this.errorParam_.setPrompt("Maximum separation in arcsec");
        this.errorParam_.setDescription(new String[]{"<p>The maximum separation permitted between two objects", "for them to count as a match.  Units are arc seconds.", "</p>"});
        this.joinParam_ = new JoinTypeParameter("join");
        this.modeParam_ = new FindModeParameter("find");
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.raParams_[0], this.decParams_[0], this.raParams_[1], this.decParams_[1], this.errorParam_, this.joinParam_, this.modeParam_};
    }

    public TableMapping createMapping(Environment env, int nin) throws TaskException {
        String ra1 = this.raParams_[0].stringValue(env);
        String dec1 = this.decParams_[0].stringValue(env);
        String ra2 = this.raParams_[1].stringValue(env);
        String dec2 = this.decParams_[1].stringValue(env);
        double error = this.errorParam_.doubleValue(env) * 4.84813681109536E-6;
        if (error < 0.0) {
            throw new ParameterValueException((Parameter)this.errorParam_, "Negative value illegal");
        }
        JoinType join = this.joinParam_.joinTypeValue(env);
        boolean bestOnly = this.modeParam_.bestOnlyValue(env);
        JoinFixAction fixact1 = JoinFixAction.makeRenameDuplicatesAction((String)"_1", (boolean)false, (boolean)true);
        JoinFixAction fixact2 = JoinFixAction.makeRenameDuplicatesAction((String)"_2", (boolean)false, (boolean)true);
        PrintStream err = env.getErrorStream();
        NullProgressIndicator progger = err == null ? new NullProgressIndicator() : new TextProgressIndicator(err);
        return new SkyMatch2Mapping((SkyMatchEngine)new HEALPixMatchEngine(error, false), ra1, dec1, ra2, dec2, join, bestOnly, fixact1, fixact2, (ProgressIndicator)progger);
    }
}

