/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.formats.TextTableWriter;
import uk.ac.starlink.table.jdbc.WriteMode;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.JdbcConsumer;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.ttools.task.OutputTableParameter;

public class CopyMode
implements ProcessingMode {
    private final OutputTableParameter locParam_ = new OutputTableParameter("out");
    private final Parameter formatParam_ = this.locParam_.getFormatParameter();

    public Parameter[] getAssociatedParameters() {
        return new Parameter[]{this.locParam_, this.formatParam_};
    }

    public String getDescription() {
        return DocUtils.join(new String[]{"<p>Writes a new table.", "</p>"});
    }

    public TableConsumer createConsumer(Environment env) throws TaskException {
        String loc = this.locParam_.stringValue(env);
        String fmt = this.formatParam_.stringValue(env);
        return CopyMode.createConsumer(env, loc, fmt);
    }

    public static TableConsumer createConsumer(Environment env, String loc, String fmt) throws UsageException {
        if (loc.startsWith("jdbc:")) {
            if (!CopyMode.isAuto(fmt) && !fmt.trim().equalsIgnoreCase("jdbc")) {
                throw new UsageException("jdbc: output location does not match output format " + fmt);
            }
            return new JdbcConsumer(loc, env, WriteMode.DROP_CREATE);
        }
        return new CopyConsumer(loc, fmt, LineTableEnvironment.getTableOutput(env));
    }

    private static boolean isAuto(String fmt) {
        return fmt == null || fmt.trim().length() == 0 || fmt.equals("(auto)");
    }

    private static class CopyConsumer
    implements TableConsumer {
        final String loc_;
        final StarTableOutput tout_;
        final StarTableWriter handler_;

        CopyConsumer(String loc, String fmt, StarTableOutput tout) throws UsageException {
            this.tout_ = tout;
            boolean isAuto = CopyMode.isAuto(fmt);
            if (loc == null && isAuto) {
                this.handler_ = new TextTableWriter();
            } else {
                try {
                    this.handler_ = tout.getHandler(fmt, loc);
                }
                catch (TableFormatException e) {
                    String msg = isAuto ? "Can't guess output format for " + loc : "No handler for output format " + fmt;
                    throw new UsageException(msg);
                }
            }
            this.loc_ = loc;
        }

        public void consume(StarTable table) throws IOException {
            this.handler_.writeStarTable(table, this.loc_, this.tout_);
        }
    }
}

