/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Point;
import java.awt.Shape;
import java.util.BitSet;

public abstract class PointIterator {
    private int ip_;
    private int xp_;
    private int yp_;
    public static PointIterator EMPTY = new PointIterator(){

        protected int[] nextPoint() {
            return null;
        }

        public String toString() {
            return "Empty PointIterator";
        }
    };

    protected abstract int[] nextPoint();

    public int getIndex() {
        return this.ip_;
    }

    public int getX() {
        return this.xp_;
    }

    public int getY() {
        return this.yp_;
    }

    public boolean readNextPoint() {
        int[] items = this.nextPoint();
        if (items != null) {
            this.ip_ = items[0];
            this.xp_ = items[1];
            this.yp_ = items[2];
            return true;
        }
        return false;
    }

    public BitSet getContainedPoints(Shape shape) {
        BitSet inside = new BitSet();
        while (this.readNextPoint()) {
            if (!shape.contains(this.getX(), this.getY())) continue;
            inside.set(this.getIndex());
        }
        return inside;
    }

    public BitSet getAllPoints() {
        BitSet included = new BitSet();
        while (this.readNextPoint()) {
            included.set(this.getIndex());
        }
        return included;
    }

    public int getClosestPoint(Point p, int error) {
        int ifound = -1;
        int maxr2 = error * error + 1;
        while (this.readNextPoint()) {
            int dy;
            int dx = this.getX() - p.x;
            int r2 = dx * dx + (dy = this.getY() - p.y) * dy;
            if (r2 == 0) {
                return this.ip_;
            }
            if (r2 >= maxr2) continue;
            maxr2 = r2;
            ifound = this.ip_;
        }
        return ifound;
    }
}

