/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.util.Arrays;

public abstract class Rounder {
    public static final Rounder LINEAR = new LinearRounder();
    public static final Rounder LOG = new LogRounder();
    private static final double LOG10 = Math.log(10.0);
    static /* synthetic */ Class class$uk$ac$starlink$ttools$plot$Rounder;

    public abstract double round(double var1);

    public abstract double nextUp(double var1);

    public abstract double nextDown(double var1);

    private static class LogRounder
    extends Rounder {
        private LogRounder() {
        }

        public double round(double value) {
            return this.getNearestNumber(value).getValue();
        }

        public double nextUp(double value) {
            RoundNumber num = this.getNearestNumber(value + Double.MIN_VALUE);
            while (num.getValue() <= value) {
                ++num.label_;
            }
            return num.getValue();
        }

        public double nextDown(double value) {
            RoundNumber num = this.getNearestNumber(value - Double.MIN_VALUE);
            while (num.getValue() >= value) {
                --num.label_;
            }
            return num.getValue();
        }

        private RoundNumber getNearestNumber(double value) {
            if (value <= 1.0) {
                throw new IllegalArgumentException(value + " <= 1");
            }
            if (value >= 1.75) {
                return new RoundNumber((int)Math.round(value));
            }
            RoundNumber num = new RoundNumber(2);
            while (value < num.getValue()) {
                --num.label_;
            }
            return num;
        }

        private static class RoundNumber {
            int label_;

            RoundNumber(int label) {
                this.label_ = label;
            }

            double getValue() {
                return this.label_ > 1 ? (double)this.label_ : 1.0 + Math.pow(2.0, this.label_ - 2);
            }
        }
    }

    private static class LinearRounder
    extends Rounder {
        private final double[] roundMantissas_ = new double[]{1.0, 2.0, 2.5, 5.0, 10.0};
        static final /* synthetic */ boolean $assertionsDisabled;

        private LinearRounder() {
            double[] roundMantissas = (double[])this.roundMantissas_.clone();
            Arrays.sort(roundMantissas);
            if (roundMantissas[0] != 1.0 || roundMantissas[roundMantissas.length - 1] != 10.0) {
                throw new AssertionError();
            }
        }

        public double round(double value) {
            return this.getNearestNumber(value).getValue();
        }

        public double nextUp(double value) {
            RoundNumber num = this.getNearestNumber(value * 1.01);
            double value1 = num.getValue();
            if (value1 > value) {
                return value1;
            }
            int index = Arrays.binarySearch(this.roundMantissas_, num.mantissa_);
            if (!$assertionsDisabled && this.roundMantissas_[index] != num.mantissa_) {
                throw new AssertionError();
            }
            if (++index > this.roundMantissas_.length) {
                num.multiplier_ *= 10.0;
                index = 1;
            }
            num.mantissa_ = this.roundMantissas_[index];
            return num.getValue();
        }

        public double nextDown(double value) {
            RoundNumber num = this.getNearestNumber(value * 0.99);
            double value1 = num.getValue();
            if (value1 < value) {
                return value1;
            }
            int index = Arrays.binarySearch(this.roundMantissas_, num.mantissa_);
            if (!$assertionsDisabled && this.roundMantissas_[index] != num.mantissa_) {
                throw new AssertionError();
            }
            if (--index < 0) {
                num.multiplier_ *= 0.1;
                index = this.roundMantissas_.length - 2;
            }
            num.mantissa_ = this.roundMantissas_[index];
            return num.getValue();
        }

        private RoundNumber getNearestNumber(double value) {
            if (value <= 0.0) {
                throw new IllegalArgumentException(value + " < 0 (out of range)");
            }
            double exponent = Math.floor(Math.log(value) / LOG10);
            double multiplier = Math.pow(10.0, exponent);
            double mantissa = value / multiplier;
            if (!($assertionsDisabled || mantissa >= 0.999 && mantissa <= 10.001)) {
                throw new AssertionError();
            }
            for (int i = 1; i < this.roundMantissas_.length; ++i) {
                double r0 = this.roundMantissas_[i - 1];
                double r1 = this.roundMantissas_[i];
                if (!(mantissa >= r0) || !(mantissa <= r1)) continue;
                double d0 = mantissa - r0;
                double d1 = r1 - mantissa;
                return new RoundNumber(d0 < d1 ? r0 : r1, multiplier);
            }
            if (!$assertionsDisabled) {
                throw new AssertionError(new RoundNumber(mantissa, multiplier));
            }
            return new RoundNumber(1.0, multiplier);
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$ttools$plot$Rounder == null ? (class$uk$ac$starlink$ttools$plot$Rounder = Rounder.class$("uk.ac.starlink.ttools.plot.Rounder")) : class$uk$ac$starlink$ttools$plot$Rounder).desiredAssertionStatus();
        }

        private static class RoundNumber {
            double mantissa_;
            double multiplier_;

            RoundNumber(double mantissa, double multiplier) {
                this.mantissa_ = mantissa;
                this.multiplier_ = multiplier;
            }

            double getValue() {
                return this.mantissa_ * this.multiplier_;
            }

            public String toString() {
                return this.mantissa_ + "*" + this.multiplier_;
            }
        }
    }
}

