/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import uk.ac.starlink.table.OnceRowPipe;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.UnrepeatableSequenceException;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.InputFormatParameter;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.util.DataSource;

public abstract class AbstractInputTableParameter
extends Parameter {
    private InputFormatParameter formatParam_;
    private BooleanParameter streamParam_;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractInputTableParameter(String name) {
        super(name);
        String suffix = name.startsWith("in") ? name.substring(2) : "";
        this.formatParam_ = new InputFormatParameter("ifmt" + suffix);
        this.streamParam_ = new BooleanParameter("istream" + suffix);
        this.streamParam_.setDefault(false);
        this.setDescription(new String[]{"<p>The location of the input table.", "This is usually a filename or URL, and may point to a file", "compressed in one of the supported compression formats", "(Unix compress, gzip or bzip2).", "If it is omitted, or equal to the special value \"-\",", "the input table will be read from standard input.", "In this case the input format must be given explicitly", "using the <code>" + this.formatParam_.getName() + "</code> parameter.", "</p>"});
        this.streamParam_.setDescription(new String[]{"<p>If set true, the <code>" + this.getName() + "</code> table", "will be read as a stream.", "It is necessary to give the ", "<code>" + this.formatParam_.getName() + "</code> parameter", "in this case.", "Depending on the required operations and processing mode,", "this may cause the read to fail (sometimes it is necessary", "to read the input table more than once).", "It is not normally necessary to set this flag;", "in most cases the data will be streamed automatically", "if that is the best thing to do.", "However it can sometimes result in less resource usage when", "processing large files in certain formats (such as VOTable).", "</p>"});
    }

    public InputFormatParameter getFormatParameter() {
        return this.formatParam_;
    }

    public BooleanParameter getStreamParameter() {
        return this.streamParam_;
    }

    protected StarTable makeTable(Environment env, String loc) throws TaskException {
        String fmt = this.formatParam_.stringValue(env);
        boolean stream = this.streamParam_.booleanValue(env);
        StarTableFactory tfact = LineTableEnvironment.getTableFactory(env);
        try {
            if (loc.equals("-")) {
                BufferedInputStream in = new BufferedInputStream(DataSource.getInputStream((String)loc));
                return this.getStreamedTable(tfact, in, fmt);
            }
            if (stream) {
                return this.getStreamedTable(tfact, DataSource.makeDataSource((String)loc), fmt);
            }
            return tfact.makeStarTable(loc, fmt);
        }
        catch (EOFException e) {
            throw new ExecutionException("Premature end of file", (Throwable)e);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.trim().length() == 0) {
                msg = e.toString();
            }
            throw new ExecutionException(msg, (Throwable)e);
        }
    }

    private StarTable getStreamedTable(StarTableFactory tfact, final InputStream in, String inFmt) throws IOException, TaskException {
        if (inFmt == null || inFmt.equals("(auto)")) {
            String msg = "Must specify input format for streamed table";
            throw new ParameterValueException((Parameter)this.formatParam_, msg);
        }
        final TableBuilder tbuilder = tfact.getTableBuilder(inFmt);
        if (!$assertionsDisabled && tbuilder == null) {
            throw new AssertionError();
        }
        final OnceRowPipe streamStore = new OnceRowPipe(1024);
        Thread streamer = new Thread("Table Streamer"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    tbuilder.streamStarTable(in, (TableSink)streamStore, null);
                }
                catch (IOException e) {
                    streamStore.setError(e);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        streamer.setDaemon(true);
        streamer.start();
        return streamStore.waitForStarTable();
    }

    private StarTable getStreamedTable(final StarTableFactory tfact, final DataSource datsrc, final String inFmt) throws IOException, TaskException {
        BufferedInputStream in1 = new BufferedInputStream(datsrc.getInputStream());
        StarTable t1 = this.getStreamedTable(tfact, in1, inFmt);
        return new WrapperStarTable(t1){

            public RowSequence getRowSequence() throws IOException {
                try {
                    return super.getRowSequence();
                }
                catch (UnrepeatableSequenceException e) {
                    StarTable t2;
                    BufferedInputStream in = new BufferedInputStream(datsrc.getInputStream());
                    try {
                        t2 = AbstractInputTableParameter.this.getStreamedTable(tfact, in, inFmt);
                    }
                    catch (TaskException e1) {
                        throw new AssertionError((Object)e1);
                    }
                    return t2.getRowSequence();
                }
            }
        };
    }

    static {
        $assertionsDisabled = !AbstractInputTableParameter.class.desiredAssertionStatus();
    }
}

