/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.EmptyRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.TableProducer;

public class SeqConcatStarTable
extends WrapperStarTable {
    private final ColumnInfo[] colInfos_;
    private final TableProducer[] tProds_;

    public SeqConcatStarTable(StarTable meta, TableProducer[] tProds) {
        super(meta);
        this.colInfos_ = Tables.getColumnInfos((StarTable)meta);
        this.tProds_ = tProds;
    }

    public boolean isRandom() {
        return false;
    }

    public Object getCell(long irow, int icol) {
        throw new UnsupportedOperationException();
    }

    public Object[] getRow(long irow) {
        throw new UnsupportedOperationException();
    }

    public long getRowCount() {
        return -1L;
    }

    public RowSequence getRowSequence() throws IOException {
        return new ConcatRowSequence();
    }

    private void checkCompatible(StarTable table) throws IOException {
        if (table.getRowCount() == 0L) {
            return;
        }
        int ncol0 = this.colInfos_.length;
        int ncol1 = table.getColumnCount();
        if (ncol1 != ncol0) {
            throw new IOException("Column count mismatch (" + ncol1 + " != " + ncol0 + ")");
        }
        for (int icol = 0; icol < ncol0; ++icol) {
            ColumnInfo info0 = this.colInfos_[icol];
            ColumnInfo info1 = table.getColumnInfo(icol);
            if (info0.getContentClass().isAssignableFrom(info1.getContentClass()) && info0.isArray() == info1.isArray()) continue;
            throw new IOException("Column type mismatch (" + info1 + " not compatible with " + info0);
        }
    }

    private class ConcatRowSequence
    implements RowSequence {
        private final Iterator prodIt;
        private RowSequence rseq_;

        private ConcatRowSequence() {
            this.prodIt = Arrays.asList(SeqConcatStarTable.this.tProds_).iterator();
            this.rseq_ = EmptyRowSequence.getInstance();
        }

        public boolean next() throws IOException {
            while (!this.rseq_.next()) {
                this.rseq_.close();
                if (this.prodIt.hasNext()) {
                    StarTable table;
                    TableProducer tProd = (TableProducer)this.prodIt.next();
                    try {
                        table = tProd.getTable();
                    }
                    catch (TaskException e) {
                        throw (IOException)new IOException(e.getMessage()).initCause(e);
                    }
                    SeqConcatStarTable.this.checkCompatible(table);
                    this.rseq_ = table.getRowSequence();
                    continue;
                }
                return false;
            }
            return true;
        }

        public Object getCell(int icol) throws IOException {
            return this.rseq_.getCell(icol);
        }

        public Object[] getRow() throws IOException {
            return this.rseq_.getRow();
        }

        public void close() throws IOException {
            this.rseq_.close();
        }
    }
}

