/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.CanvasLayer;
import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.FigureLayer;
import diva.canvas.GraphicsPane;
import diva.canvas.Site;
import diva.canvas.event.LayerAdapter;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.LayerListener;
import diva.canvas.interactor.BoundsManipulator;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.PathManipulator;
import diva.canvas.interactor.SelectionEvent;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.interactor.SelectionListener;
import diva.canvas.interactor.SelectionModel;
import diva.canvas.toolbox.BasicFigure;
import diva.canvas.toolbox.BasicHighlighter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import jsky.coords.CoordinateConverter;
import jsky.graphics.CanvasFigure;
import jsky.graphics.CanvasFigureEvent;
import jsky.graphics.CanvasFigureGroup;
import jsky.graphics.CanvasFigureListener;
import jsky.graphics.CanvasGraphics;
import jsky.graphics.SelectedAreaListener;
import jsky.image.graphics.ImageFigure;
import jsky.image.graphics.ImageFigureGroup;
import jsky.image.graphics.ImageLabel;
import jsky.image.graphics.ImageLayer;
import jsky.image.graphics.LabeledImageFigure;
import jsky.image.graphics.RectangleGrabHandle;
import jsky.image.graphics.RectangleManipulator;
import jsky.image.graphics.RoiEllipse;
import jsky.image.graphics.RoiFigure;
import jsky.image.graphics.RoiRectangle;
import jsky.image.graphics.RotatableCanvasFigure;
import jsky.image.graphics.SelectionDragger;
import jsky.image.gui.DivaGraphicsImageDisplay;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.image.gui.GraphicsImageDisplay;
import jsky.image.gui.ImageDisplayControl;
import jsky.image.gui.ImageDisplayControlFrame;

public class DivaImageGraphics
implements CanvasGraphics {
    private GraphicsImageDisplay _imageDisplay;
    private GraphicsPane _graphicsPane;
    private FigureLayer _figureLayer;
    private ImageLayer _imageLayer;
    private SelectionInteractor _selectionInteractor;
    private SelectionInteractor _roiSelectionInteractor;
    private SelectionInteractor _lineInteractor;
    private DragInteractor _dragInteractor;
    private SelectionInteractor _fixedSelectionInteractor;
    private SelectionListener _selectionListener;
    private SelectionDragger _selectionDragger;
    private Set<CanvasFigure> _selectedSet;

    public DivaImageGraphics(DivaGraphicsImageDisplay imageDisplay) {
        this._imageDisplay = imageDisplay;
        this._graphicsPane = (GraphicsPane)imageDisplay.getCanvasPane();
        this._graphicsPane.setAntialiasing(false);
        this._imageLayer = this._makeImageLayer();
        this._graphicsPane.setBackgroundLayer((CanvasLayer)this._imageLayer);
        this._figureLayer = this._graphicsPane.getForegroundLayer();
        this._graphicsPane.getBackgroundEventLayer().addLayerListener((LayerListener)new LayerAdapter(){

            public void mousePressed(LayerEvent e) {
                DivaImageGraphics.this.clearSelection();
            }
        });
        this._selectedSet = new HashSet<CanvasFigure>();
        this._makeSelectionListener();
        this._makeDragInteractor();
        this._makeSelectionInteractor();
        this._makeRoiSelectionInteractor();
        this._makeLineInteractor();
        this._makeFixedSelectionInteractor();
        this._makeSelectionDragger();
    }

    public GraphicsPane getGraphicsPane() {
        return this._graphicsPane;
    }

    private ImageLayer _makeImageLayer() {
        return new ImageLayer((DivaGraphicsImageDisplay)this._imageDisplay);
    }

    public ImageLayer getImageLayer() {
        return this._imageLayer;
    }

    private void _makeSelectionInteractor() {
        BoundsManipulator boundsManipulator = new BoundsManipulator();
        boundsManipulator.getHandleInteractor().addLayerListener((LayerListener)new LayerAdapter(){

            public void mouseReleased(LayerEvent e) {
                Figure fig = e.getFigureSource();
                if (fig instanceof CanvasFigure) {
                    ((CanvasFigure)fig).fireCanvasFigureEvent(2);
                }
            }
        });
        this._selectionInteractor = new SelectionInteractor();
        this._selectionInteractor.setPrototypeDecorator((FigureDecorator)boundsManipulator);
        this._selectionInteractor.getSelectionModel().addSelectionListener(this._selectionListener);
        this._selectionInteractor.addInteractor((Interactor)this._dragInteractor);
    }

    private void _makeRoiSelectionInteractor() {
        RectangleManipulator rectangleManipulator = new RectangleManipulator();
        rectangleManipulator.getHandleInteractor().addLayerListener((LayerListener)new LayerAdapter(){

            public void mouseReleased(LayerEvent e) {
                Figure fig = e.getFigureSource();
                if (fig instanceof RectangleGrabHandle) {
                    Site site = ((RectangleGrabHandle)fig).getSite();
                    CanvasFigure f = (CanvasFigure)site.getFigure();
                    if (site.getID() == 0) {
                        f.fireCanvasFigureEvent(4);
                    } else {
                        f.fireCanvasFigureEvent(2);
                    }
                }
            }
        });
        this._roiSelectionInteractor = new SelectionInteractor();
        this._roiSelectionInteractor.setPrototypeDecorator((FigureDecorator)rectangleManipulator);
        this._roiSelectionInteractor.setSelectionModel(this._selectionInteractor.getSelectionModel());
        this._roiSelectionInteractor.addInteractor((Interactor)this._dragInteractor);
    }

    private void _makeLineInteractor() {
        PathManipulator pathManipulator = new PathManipulator();
        pathManipulator.getHandleInteractor().addLayerListener((LayerListener)new LayerAdapter(){

            public void mouseReleased(LayerEvent e) {
                Figure fig = e.getFigureSource();
                if (fig instanceof CanvasFigure) {
                    ((CanvasFigure)fig).fireCanvasFigureEvent(2);
                }
            }
        });
        this._lineInteractor = new SelectionInteractor(this._selectionInteractor.getSelectionModel());
        this._lineInteractor.setPrototypeDecorator((FigureDecorator)pathManipulator);
        this._lineInteractor.getSelectionModel().addSelectionListener(this._selectionListener);
        this._lineInteractor.addInteractor((Interactor)this._dragInteractor);
    }

    private void _makeSelectionListener() {
        this._selectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                CanvasFigure f;
                Object o;
                Iterator it2;
                try {
                    it2 = e.getSelectionAdditions();
                    while (it2.hasNext()) {
                        o = it2.next();
                        if (!(o instanceof CanvasFigure)) continue;
                        f = (CanvasFigure)o;
                        DivaImageGraphics.this._selectedSet.add(f);
                        f.fireCanvasFigureEvent(0);
                    }
                }
                catch (Exception it2) {
                    // empty catch block
                }
                try {
                    it2 = e.getSelectionRemovals();
                    while (it2.hasNext()) {
                        o = it2.next();
                        if (!(o instanceof CanvasFigure)) continue;
                        f = (CanvasFigure)o;
                        DivaImageGraphics.this._selectedSet.remove(f);
                        ((CanvasFigure)o).fireCanvasFigureEvent(1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    public List<CanvasFigure> getSelectedFigures() {
        return new ArrayList<CanvasFigure>(this._selectedSet);
    }

    private void _makeDragInteractor() {
        this._dragInteractor = new DragInteractor();
        this._dragInteractor.addLayerListener((LayerListener)new LayerAdapter(){

            public void mouseReleased(LayerEvent e) {
                Figure fig = e.getFigureSource();
                if (fig instanceof CanvasFigure) {
                    ((CanvasFigure)fig).fireCanvasFigureEvent(3);
                }
            }
        });
    }

    private void _makeFixedSelectionInteractor() {
        SelectionModel model = this._selectionInteractor.getSelectionModel();
        this._fixedSelectionInteractor = new SelectionInteractor(model);
        AlphaComposite composite = AlphaComposite.getInstance(3, 0.75f);
        BasicHighlighter h = new BasicHighlighter((Paint)new Color(204, 204, 255), 1.0f, (Composite)composite);
        this._fixedSelectionInteractor.setPrototypeDecorator((FigureDecorator)h);
    }

    private void _makeSelectionDragger() {
        this._selectionDragger = new SelectionDragger(this._graphicsPane){

            @Override
            public void mouseReleased(LayerEvent e) {
                super.mouseReleased(e);
                this.setEnabled(false);
            }
        };
        this._selectionDragger.addSelectionInteractor(this._selectionInteractor);
        this._selectionDragger.addSelectionInteractor(this._lineInteractor);
        this._selectionDragger.addSelectionInteractor(this._fixedSelectionInteractor);
        this._selectionDragger.setEnabled(false);
    }

    public SelectionDragger getSelectionDragger() {
        return this._selectionDragger;
    }

    public DragInteractor getDragInteractor() {
        return this._dragInteractor;
    }

    public SelectionInteractor getSelectionInteractor() {
        return this._selectionInteractor;
    }

    public SelectionInteractor getRoiSelectionInteractor() {
        return this._roiSelectionInteractor;
    }

    public SelectionInteractor getLineInteractor() {
        return this._lineInteractor;
    }

    public SelectionInteractor getFixedSelectionInteractor() {
        return this._fixedSelectionInteractor;
    }

    public CanvasFigure makeLabeledFigure(Shape shape, Paint fill, Paint outline, float lineWidth, String label, int anchor, Paint labelColor, Font font, Interactor interactor) {
        if (label == null || label.length() == 0) {
            return new ImageFigure(shape, fill, outline, lineWidth, interactor);
        }
        return new LabeledImageFigure(new ImageFigure(shape, fill, outline, lineWidth, null), label, anchor, labelColor, font, interactor);
    }

    public CanvasFigure makeFigure(Shape shape, Paint fill, Paint outline, float lineWidth, Composite composite, Interactor interactor) {
        RotatableCanvasFigure fig = this.makeFigure(shape, fill, outline, lineWidth, interactor);
        if (composite != null && fig instanceof BasicFigure) {
            ((BasicFigure)fig).setComposite((AlphaComposite)composite);
        }
        return fig;
    }

    public RotatableCanvasFigure makeFigure(Shape shape, Paint fill, Paint outline, float lineWidth, Interactor interactor) {
        if (shape instanceof Rectangle2D.Double) {
            RotatableCanvasFigure fig = this.makeRoiRectangle((Rectangle2D.Double)shape, fill, outline, lineWidth);
            fig.setInteractor(interactor);
            return fig;
        }
        if (shape instanceof Ellipse2D.Double) {
            RotatableCanvasFigure fig = this.makeRoiEllipse((Ellipse2D.Double)shape, fill, outline, lineWidth);
            fig.setInteractor(interactor);
            return fig;
        }
        return new RoiFigure(shape, fill, outline, lineWidth, interactor);
    }

    @Override
    public CanvasFigure makeLabeledFigure(Shape shape, Paint fill, Paint outline, float lineWidth, String label, int anchor, Paint labelColor, Font font) {
        return this.makeLabeledFigure(shape, fill, outline, lineWidth, label, anchor, labelColor, font, (Interactor)this._fixedSelectionInteractor);
    }

    @Override
    public CanvasFigure makeFigure(Shape shape, Paint fill, Paint outline, float lineWidth) {
        return this.makeFigure(shape, fill, outline, lineWidth, (Interactor)this._fixedSelectionInteractor);
    }

    public CanvasFigure makeLabeledRectangle(Rectangle2D.Double rect, int coordType, Paint fill, Paint outline, float lineWidth, String label, int anchor, Paint labelColor, Font font, Interactor interactor) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double p = new Point2D.Double(rect.x, rect.y);
        coordinateConverter.convertCoords(p, coordType, 1, false);
        Point2D.Double size = new Point2D.Double(rect.width, rect.height);
        coordinateConverter.convertCoords(size, coordType, 1, true);
        Rectangle2D.Double r = new Rectangle2D.Double(p.x, p.y, size.x, size.y);
        return this.makeLabeledFigure(r, fill, outline, lineWidth, label, anchor, labelColor, font, interactor);
    }

    public CanvasFigure makeRectangle(Rectangle2D.Double rect, int coordType, Paint fill, Paint outline, float lineWidth, Interactor interactor) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double p = new Point2D.Double(rect.x, rect.y);
        coordinateConverter.convertCoords(p, coordType, 1, false);
        Point2D.Double size = new Point2D.Double(rect.width, rect.height);
        coordinateConverter.convertCoords(size, coordType, 1, true);
        Rectangle2D.Double r = new Rectangle2D.Double(p.x, p.y, size.x, size.y);
        return this.makeFigure(r, fill, outline, lineWidth, interactor);
    }

    public RotatableCanvasFigure makeRoiRectangle(Rectangle2D.Double rect, Paint fill, Paint outline, float lineWidth) {
        return this.makeRoiRectangle(rect, 1, fill, outline, lineWidth);
    }

    public RotatableCanvasFigure makeRoiRectangle(Rectangle2D.Double rect, int coordType, Paint fill, Paint outline, float lineWidth) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double p = new Point2D.Double(rect.x, rect.y);
        coordinateConverter.convertCoords(p, coordType, 1, false);
        Point2D.Double size = new Point2D.Double(rect.width, rect.height);
        coordinateConverter.convertCoords(size, coordType, 1, true);
        Rectangle2D.Double r = new Rectangle2D.Double(p.x, p.y, size.x, size.y);
        return new RoiRectangle(r, fill, outline, lineWidth, (Interactor)this._roiSelectionInteractor);
    }

    public RotatableCanvasFigure makeRoiEllipse(Ellipse2D.Double ellipse, Paint fill, Paint outline, float lineWidth) {
        return this.makeRoiEllipse(ellipse, 1, fill, outline, lineWidth);
    }

    public RotatableCanvasFigure makeRoiEllipse(Ellipse2D.Double ellipse, int coordType, Paint fill, Paint outline, float lineWidth) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double p = new Point2D.Double(ellipse.x, ellipse.y);
        coordinateConverter.convertCoords(p, coordType, 1, false);
        Point2D.Double size = new Point2D.Double(ellipse.width, ellipse.height);
        coordinateConverter.convertCoords(size, coordType, 1, true);
        Ellipse2D.Double e = new Ellipse2D.Double(p.x, p.y, size.x, size.y);
        return new RoiEllipse(e, fill, outline, lineWidth, (Interactor)this._roiSelectionInteractor);
    }

    public CanvasFigure makeLabeledEllipse(Ellipse2D.Double ellipse, int coordType, Paint fill, Paint outline, float lineWidth, String label, int anchor, Paint labelColor, Font font, Interactor interactor) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double p = new Point2D.Double(ellipse.x, ellipse.y);
        coordinateConverter.convertCoords(p, coordType, 1, false);
        Point2D.Double size = new Point2D.Double(ellipse.width, ellipse.height);
        coordinateConverter.convertCoords(size, coordType, 1, true);
        Ellipse2D.Double r = new Ellipse2D.Double(p.x, p.y, size.x, size.y);
        return this.makeLabeledFigure(r, fill, outline, lineWidth, label, anchor, labelColor, font, interactor);
    }

    public RotatableCanvasFigure makeEllipse(Ellipse2D.Double ellipse, int coordType, Paint fill, Paint outline, float lineWidth, Interactor interactor) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double p = new Point2D.Double(ellipse.x, ellipse.y);
        coordinateConverter.convertCoords(p, coordType, 1, false);
        Point2D.Double size = new Point2D.Double(ellipse.width, ellipse.height);
        coordinateConverter.convertCoords(size, coordType, 1, true);
        Ellipse2D.Double r = new Ellipse2D.Double(p.x, p.y, size.x, size.y);
        return this.makeFigure(r, fill, outline, lineWidth, interactor);
    }

    public CanvasFigure makeLabel(Point2D.Double pos, int coordType, String text, Paint color, Font font, Interactor interactor) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double p = new Point2D.Double(pos.x, pos.y);
        coordinateConverter.convertCoords(p, coordType, 1, false);
        return new ImageLabel(text, p, color, font, interactor);
    }

    @Override
    public CanvasFigure makeLabel(Point2D.Double pos, String text, Paint color, Font font) {
        return this.makeLabel(pos, 1, text, color, font, null);
    }

    public CanvasFigureGroup makeFigureGroup(Interactor interactor) {
        return new ImageFigureGroup(interactor);
    }

    @Override
    public CanvasFigureGroup makeFigureGroup() {
        return new ImageFigureGroup((Interactor)this._fixedSelectionInteractor);
    }

    @Override
    public void add(CanvasFigure fig) {
        this._figureLayer.add((Figure)fig);
    }

    @Override
    public void remove(CanvasFigure fig) {
        SelectionModel model;
        Interactor interactor = fig.getInteractor();
        if (interactor instanceof SelectionInteractor && (model = ((SelectionInteractor)interactor).getSelectionModel()).containsSelection((Object)fig)) {
            model.removeSelection((Object)fig);
        }
        this._figureLayer.remove((Figure)fig);
    }

    @Override
    public void select(CanvasFigure fig) {
        Interactor i = fig.getInteractor();
        if (i instanceof SelectionInteractor) {
            ((SelectionInteractor)i).getSelectionModel().addSelection((Object)fig);
        }
    }

    @Override
    public void deselect(CanvasFigure fig) {
        Interactor i = fig.getInteractor();
        if (i instanceof SelectionInteractor) {
            ((SelectionInteractor)i).getSelectionModel().removeSelection((Object)fig);
        }
    }

    public void clearSelection() {
        this._selectionInteractor.getSelectionModel().clearSelection();
        this._roiSelectionInteractor.getSelectionModel().clearSelection();
    }

    @Override
    public void scheduleRemoval(CanvasFigure fig) {
        SwingUtilities.invokeLater(new FigureRemover(fig));
    }

    @Override
    public int getFigureCount() {
        return this._figureLayer.getFigureCount();
    }

    @Override
    public void transform(AffineTransform trans) {
        this._selectionInteractor.getSelectionModel().clearSelection();
        Iterator it = this._figureLayer.figures();
        while (it.hasNext()) {
            Figure fig = (Figure)it.next();
            fig.transform(trans);
        }
    }

    @Override
    public void setInteractionMode(CanvasFigure fig, int mode) {
        SelectionInteractor interactor = null;
        if ((mode & 0xE) != 0) {
            mode |= 1;
        }
        if (mode == 1) {
            interactor = this._fixedSelectionInteractor;
        } else if (mode == 3) {
            interactor = this._dragInteractor;
        } else if (mode == 7) {
            interactor = this._selectionInteractor;
        }
        fig.setInteractor((Interactor)interactor);
    }

    @Override
    public void selectArea(final SelectedAreaListener l) {
        SelectionDragger sd = new SelectionDragger(this._graphicsPane){

            @Override
            public void mouseReleased(LayerEvent e) {
                super.mouseReleased(e);
                this.setEnabled(false);
                Rectangle2D r = this.getSelectedArea();
                if (r != null) {
                    l.setSelectedArea(r);
                }
            }
        };
        sd.setEnabled(true);
    }

    @Override
    public void repaint() {
        this._figureLayer.repaint();
    }

    public void repaint(Rectangle2D region) {
        this._figureLayer.repaint(region);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageDisplayControlFrame frame = new ImageDisplayControlFrame(null);
                frame.setVisible(true);
                ImageDisplayControl control = frame.getImageDisplayControl();
                DivaMainImageDisplay imageDisplay = control.getImageDisplay();
                DivaImageGraphics g = (DivaImageGraphics)imageDisplay.getCanvasGraphics();
                SelectionInteractor si = g.getSelectionInteractor();
                SelectionInteractor rsi = g.getRoiSelectionInteractor();
                SelectionInteractor fsi = g.getFixedSelectionInteractor();
                DragInteractor di = g.getDragInteractor();
                Font font = new Font("Dialog", 0, 12);
                Rectangle2D.Double r1 = new Rectangle2D.Double(30.0, 30.0, 30.0, 40.0);
                CanvasFigure fig = g.makeLabeledRectangle(r1, 3, null, Color.blue, 2.0f, "Test1", 0, Color.blue, font, (Interactor)si);
                fig.transform(AffineTransform.getRotateInstance(Math.toRadians(30.0), 25.0, 25.0));
                g.add(fig);
                Rectangle2D.Double r2 = new Rectangle2D.Double(70.0, 70.0, 50.0, 50.0);
                g.add(g.makeLabeledRectangle(r2, 3, null, Color.white, 2.0f, "Test2", 0, Color.blue, font, (Interactor)fsi));
                Ellipse2D.Double e1 = new Ellipse2D.Double(150.0, 150.0, 50.0, 50.0);
                RotatableCanvasFigure imageFig = g.makeEllipse(e1, 3, Color.red, Color.white, 2.0f, (Interactor)rsi);
                imageFig.setResizable(false);
                g.add(imageFig);
                Rectangle2D.Double r4 = new Rectangle2D.Double(120.0, 180.0, 20.0, 60.0);
                g.add(g.makeRectangle(r4, 3, Color.green, Color.yellow, 2.0f, (Interactor)si));
                Ellipse2D.Double e3 = new Ellipse2D.Double(20.0, 220.0, 50.0, 20.0);
                g.add(g.makeEllipse(e3, 3, null, Color.white, 2.0f, (Interactor)si));
                Ellipse2D.Double e4 = new Ellipse2D.Double(55.0, 200.0, 10.0, 40.0);
                g.add(g.makeEllipse(e4, 3, Color.white, Color.yellow, 2.0f, (Interactor)di));
                Point2D.Double pos = new Point2D.Double(10.0, 150.0);
                g.add(g.makeLabel(pos, "Test Label", Color.yellow, font));
                CanvasFigureListener listener = new CanvasFigureListener(){

                    @Override
                    public void figureSelected(CanvasFigureEvent e) {
                        System.out.println("Figure selected");
                    }

                    @Override
                    public void figureDeselected(CanvasFigureEvent e) {
                        System.out.println("Figure deselected");
                    }

                    @Override
                    public void figureResized(CanvasFigureEvent e) {
                        System.out.println("Figure resized: " + e.getFigure().getShape());
                    }

                    @Override
                    public void figureMoved(CanvasFigureEvent e) {
                        System.out.println("Figure moved: " + e.getFigure().getShape());
                    }

                    @Override
                    public void figureRotated(CanvasFigureEvent e) {
                        RotatableCanvasFigure rfig = (RotatableCanvasFigure)e.getFigure();
                        System.out.println("Figure rotated: " + Math.toDegrees(rfig.getGeometry().getRotateAngle()) + " deg");
                    }
                };
                Rectangle2D.Double r3 = new Rectangle2D.Double(150.0, 100.0, 60.0, 40.0);
                CanvasFigure f1 = g.makeRectangle(r3, 3, null, Color.yellow, 2.0f, null);
                Ellipse2D.Double e5 = new Ellipse2D.Double(150.0, 100.0, 60.0, 40.0);
                RotatableCanvasFigure f2 = g.makeEllipse(e5, 3, null, Color.yellow, 2.0f, null);
                pos = new Point2D.Double(r3.x + 10.0, r3.y + 25.0);
                CanvasFigure f3 = g.makeLabel(pos, 3, "Group", Color.yellow, new JLabel().getFont(), null);
                CanvasFigureGroup group = g.makeFigureGroup((Interactor)rsi);
                group.transform(AffineTransform.getRotateInstance(Math.toRadians(-25.0), 25.0, 25.0));
                group.add(f1);
                group.add(f2);
                group.add(f3);
                g.add(group);
                group.addCanvasFigureListener(listener);
                Rectangle2D.Double r5 = new Rectangle2D.Double(250.0, 180.0, 40.0, 60.0);
                RotatableCanvasFigure rfig = g.makeRoiRectangle(r5, 3, Color.green, Color.yellow, 2.0f);
                g.add(rfig);
                rfig.addCanvasFigureListener(listener);
                Ellipse2D.Double e6 = new Ellipse2D.Double(250.0, 260.0, 40.0, 60.0);
                rfig = g.makeRoiEllipse(e6, 3, Color.green, Color.yellow, 2.0f);
                g.add(rfig);
                rfig.addCanvasFigureListener(listener);
                g.selectArea(new SelectedAreaListener(){

                    @Override
                    public void setSelectedArea(Rectangle2D r) {
                        System.out.println("Selected area: " + r);
                    }
                });
            }
        });
    }

    private class FigureRemover
    implements Runnable {
        CanvasFigure fig;

        public FigureRemover(CanvasFigure fig) {
            this.fig = fig;
        }

        @Override
        public void run() {
            DivaImageGraphics.this.remove(this.fig);
        }
    }
}

