<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:txfms="file:///home/ab/AlmaDev/XsltChain/ConvertZip"
                xmlns:alma="http://www.roe.ac.uk/ukatc/projects/alma/ConvertZip"
                xmlns:op="Alma/ObsPrep/ObsProject"
                xmlns:prp="Alma/ObsPrep/ObsProposal"
                xmlns:id="Alma/ObsPrep/SchedBlock"
                xmlns:vt="Alma/ValueTypes">
                
<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

<!-- Import the "identity" stylesheet. This will ensure everything is copied to the output,  if 
     not directly addressed below. Still having problems with import. To be investigated.
     So for the moment still have this template in place explicitly. AB 20070720. 
<xsl:import href="alma:basic-copy.xslt"/> 
-->                

<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<!-- This forms the basis of the project document transform, ensuring that the information is copied.
     All other templates will override this to do something else -->

<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>


<!-- For ObsProject modify the entity and copy everything else -->

<xsl:template match="op:ObsProject">
<ObsProject xmlns="Alma/ObsPrep/ObsProject">
  <xsl:attribute name="schemaVersion">8</xsl:attribute>
  <xsl:attribute name="revision"><xsl:value-of select="@revision"/></xsl:attribute>
  <xsl:attribute name="xsi:type">ObsProject</xsl:attribute>
<!--  add the boolean manual mode - need to check if one exists first, if it does then leave it -->
  <xsl:choose>
  <xsl:when test="./op:manualMode"></xsl:when>
  <xsl:otherwise>
  <manualMode>false</manualMode>
  </xsl:otherwise>
  </xsl:choose>  
  <xsl:apply-templates select="node()"/>
 
  <xsl:comment>Converted to V8 by ObsProject7-8.xslt</xsl:comment>
  
</ObsProject>
</xsl:template>

  <!-- Ensure dopplercalctype is set in velocities, assume optical -->
  <xsl:template match="op:sourceVelocity">
    <sourceVelocity>
      <xsl:attribute name="dopplerCalcType">OPTICAL</xsl:attribute>
      <xsl:attribute name="referenceSystem"><xsl:value-of select="@referenceSystem"/></xsl:attribute>
      <xsl:apply-templates/>
    </sourceVelocity>
  </xsl:template>
  
<xsl:template match="op:ObsProjectEntity">
<ObsProjectEntity>
<xsl:attribute name="entityId"><xsl:value-of select="@entityId"/></xsl:attribute>
<xsl:attribute name="entityIdEncrypted"><xsl:value-of select="@entityIdEncrypted"/></xsl:attribute>
<xsl:attribute name="entityTypeName"><xsl:value-of select="@entityTypeName"/></xsl:attribute>
<xsl:attribute name="schemaVersion">8</xsl:attribute>
</ObsProjectEntity>
</xsl:template>
  
  
  <!-- Correct the ObsProposalRef -->
  <xsl:template match="op:ObsProposalRef">
    <ObsProposalRef>
      <xsl:choose>
        <xsl:when test="entity-id">
          <xsl:attribute name="entityId"><xsl:value-of select="entity-id"/></xsl:attribute>
        </xsl:when>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="entity-type-name">
          <xsl:attribute name="entityTypeName"><xsl:value-of select="entity-type-name"/></xsl:attribute>
        </xsl:when>
      </xsl:choose>
      <xsl:attribute name="documentVersion">1</xsl:attribute>
      <!-- Just in case this Ref was correctly formed to start with -->
      <xsl:apply-templates select="./@entityId"></xsl:apply-templates>
      <xsl:apply-templates select="./@entityTypeName"></xsl:apply-templates>
    </ObsProposalRef>
  </xsl:template>
  
  <!-- Correct the SchedBlockRef -->
  <xsl:template match="op:SchedBlockRef">
    <SchedBlockRef>
      <xsl:choose>
        <xsl:when test="entity-id">
          <xsl:attribute name="entityId"><xsl:value-of select="entity-id"/></xsl:attribute>
        </xsl:when>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="entity-type-name">
          <xsl:attribute name="entityTypeName"><xsl:value-of select="entity-type-name"/></xsl:attribute>
        </xsl:when>
      </xsl:choose>
      <xsl:attribute name="documentVersion">1</xsl:attribute>
      <!-- Just in case this Ref was correctly formed to start with -->
      <xsl:apply-templates select="./@entityId"></xsl:apply-templates>
      <xsl:apply-templates select="./@entityTypeName"></xsl:apply-templates>
    </SchedBlockRef>
  </xsl:template>
  
  <!-- Correct the ObsProjectRef -->
  <xsl:template match="op:ObsProjectRef">
    <ObsProjectRef>
      <xsl:choose>
        <xsl:when test="entity-id">
          <xsl:attribute name="entityId"><xsl:value-of select="entity-id"/></xsl:attribute>
        </xsl:when>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="entity-type-name">
          <xsl:attribute name="entityTypeName"><xsl:value-of select="entity-type-name"/></xsl:attribute>
        </xsl:when>
      </xsl:choose>
      <xsl:attribute name="documentVersion">1</xsl:attribute>
      <!-- Just in case this Ref was correctly formed to start with -->
      <xsl:apply-templates select="./@entityId"></xsl:apply-templates>
      <xsl:apply-templates select="./@entityTypeName"></xsl:apply-templates>
    </ObsProjectRef>
  </xsl:template>
  
  <!--  Change format of entitypartids -->
  <xsl:template match="@partId">
    <xsl:attribute name="partId">X<xsl:value-of select="translate(.,'/ ','--')"/>
    </xsl:attribute>
  </xsl:template>
  <xsl:template match="@entityPartId">
    <xsl:attribute name="entityPartId">X<xsl:value-of select="translate(.,'/ ','--')"/>
    </xsl:attribute>
  </xsl:template>

</xsl:stylesheet>
