/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.OutputStream;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.formats.TextTableWriter;

public class AsciiTableWriter
extends TextTableWriter {
    public AsciiTableWriter() {
        this.setWriteParameters(false);
    }

    protected String formatValue(Object val, ValueInfo vinfo, int width) {
        if (Tables.isBlank(val)) {
            return "\"\"";
        }
        String fval = vinfo.formatValue(val, width);
        if (val instanceof Number) {
            try {
                Object nval0 = vinfo.unformatString(fval);
                Number nval = (Number)val;
                int ival = nval.intValue();
                if (!(ival != (int)nval.doubleValue() || nval0 instanceof Number && ival == ((Number)nval0).intValue())) {
                    fval = val.toString();
                }
            }
            catch (RuntimeException e) {
                fval = val.toString();
            }
            int nchar = fval.length();
            StringBuffer buf = new StringBuffer(nchar);
            boolean changed = false;
            block9: for (int i = 0; i < nchar; ++i) {
                char c = fval.charAt(i);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case ' ': {
                        changed = true;
                        continue block9;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
            return changed ? buf.toString() : fval;
        }
        int nchar = fval.length();
        StringBuffer buf = new StringBuffer(nchar + 2);
        buf.append('\"');
        boolean quote = false;
        block10: for (int i = 0; i < nchar; ++i) {
            char c = fval.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    quote = true;
                    buf.append(' ');
                    continue block10;
                }
                case '\"': 
                case '#': 
                case '\'': 
                case '\\': {
                    quote = true;
                    buf.append('\\');
                    buf.append(c);
                    continue block10;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (quote) {
            buf.append('\"');
            return buf.toString();
        }
        return fval;
    }

    public String getFormatName() {
        return "ascii";
    }

    public int getMaxWidth() {
        return 158;
    }

    protected void printSeparator(OutputStream strm, int[] colwidths) {
    }

    protected void printLine(OutputStream strm, int[] colwidths, String[] data) throws IOException {
        strm.write(32);
        this.printItems(strm, colwidths, data);
    }

    private void printItems(OutputStream strm, int[] colwidths, String[] data) throws IOException {
        for (int i = 0; i < colwidths.length; ++i) {
            strm.write(32);
            String datum = data[i];
            if (datum == null || datum.length() == 0) {
                datum = "\"\"";
            }
            strm.write(AsciiTableWriter.getBytes(datum));
            int padding = colwidths[i] - datum.length();
            if (padding <= 0) continue;
            for (int j = 0; j < padding; ++j) {
                strm.write(32);
            }
        }
        strm.write(10);
    }

    protected void printColumnHeads(OutputStream strm, int[] colwidths, ColumnInfo[] cinfos) throws IOException {
        int ncol = cinfos.length;
        String[] heads = new String[ncol];
        for (int i = 0; i < ncol; ++i) {
            byte[] nameBuf = AsciiTableWriter.getBytes(cinfos[i].getName());
            for (int j = 0; j < nameBuf.length; ++j) {
                switch ((char)nameBuf[j]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '\'': {
                        nameBuf[j] = 95;
                    }
                }
            }
            heads[i] = new String(nameBuf);
        }
        strm.write(35);
        this.printItems(strm, colwidths, heads);
    }

    protected void printParam(OutputStream strm, String name, String value) throws IOException {
        strm.write(35);
        strm.write(32);
        strm.write(AsciiTableWriter.getBytes(name));
        strm.write(58);
        strm.write(32);
        byte[] valbuf = AsciiTableWriter.getBytes(value);
        for (int i = 0; i < valbuf.length; ++i) {
            switch (valbuf[i]) {
                case 10: 
                case 13: {
                    valbuf[i] = 32;
                }
            }
        }
        strm.write(valbuf);
        strm.write(10);
    }
}

