/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import uk.ac.starlink.connect.FilestoreChooser;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.gui.BasicTableConsumer;
import uk.ac.starlink.table.gui.FilestoreTableLoadDialog;
import uk.ac.starlink.table.gui.LoadWorker;
import uk.ac.starlink.table.gui.TableConsumer;
import uk.ac.starlink.table.gui.TableLoadDialog;
import uk.ac.starlink.table.gui.TableSaveChooser;
import uk.ac.starlink.table.jdbc.SwingAuthenticator;
import uk.ac.starlink.util.Loader;

public class TableLoadChooser
extends JPanel {
    private final JTextField locField_;
    private final Action locAction_;
    private final TableLoadDialog[] dialogs_;
    private final String[] extraDialogNames_;
    private TableLoadDialog[] knownDialogs_;
    private final Component[] activeComponents_;
    private StarTableFactory tableFactory_;
    private JComboBox formatSelector_;
    private TransferHandler transferHandler_;
    private Icon queryIcon_;
    private TableConsumer tableConsumer_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table");
    public static String[] STANDARD_DIALOG_CLASSES = new String[]{FilestoreTableLoadDialog.class.getName()};
    public static final String LOAD_DIALOGS_PROPERTY = "startable.load.dialogs";
    static /* synthetic */ Class class$uk$ac$starlink$table$gui$TableLoadChooser;

    public TableLoadChooser() {
        this(new StarTableFactory());
        SwingAuthenticator auth = new SwingAuthenticator();
        auth.setParentComponent(this);
        this.tableFactory_.getJDBCHandler().setAuthenticator(auth);
    }

    public TableLoadChooser(StarTableFactory factory) {
        this(new StarTableFactory(), TableLoadChooser.makeDefaultLoadDialogs(), new String[0]);
    }

    public TableLoadChooser(StarTableFactory factory, TableLoadDialog[] dialogs, String[] extraDialogNames) {
        this.dialogs_ = dialogs;
        this.extraDialogNames_ = extraDialogNames;
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Box actionBox = Box.createVerticalBox();
        actionBox.setBorder(emptyBorder);
        this.setLayout(new BorderLayout());
        this.add((Component)actionBox, "Center");
        ArrayList<JComponent> activeList = new ArrayList<JComponent>();
        Box formatBox = Box.createHorizontalBox();
        formatBox.add(new JLabel("Format: "));
        formatBox.add(Box.createHorizontalStrut(5));
        this.formatSelector_ = new JComboBox(){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        formatBox.add(this.formatSelector_);
        activeList.add(this.formatSelector_);
        formatBox.setAlignmentX(0.0f);
        actionBox.add(formatBox);
        this.setStarTableFactory(factory);
        this.locAction_ = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent evt) {
                TableLoadChooser.this.submitLocation(TableLoadChooser.this.locField_.getText());
            }
        };
        Box locBox = Box.createHorizontalBox();
        this.locField_ = new JTextField(25);
        this.locField_.addActionListener(this.locAction_);
        locBox.add(new JLabel("Location: "));
        locBox.add(Box.createHorizontalStrut(5));
        locBox.add(this.locField_);
        activeList.add(this.locField_);
        Dimension locSize = locBox.getPreferredSize();
        locSize.width = 1024;
        locBox.setMaximumSize(locSize);
        locBox.setAlignmentX(0.0f);
        locBox.add(Box.createHorizontalStrut(5));
        locBox.add(new JButton(this.locAction_));
        actionBox.add(Box.createVerticalStrut(5));
        actionBox.add(locBox);
        ArrayList<JButton> buttList = new ArrayList<JButton>();
        for (int i = 0; i < this.dialogs_.length; ++i) {
            if (!this.dialogs_[i].isAvailable()) continue;
            JButton butt = new JButton(this.makeAction(this.dialogs_[i]));
            activeList.add(butt);
            buttList.add(butt);
        }
        JButton[] buttons = buttList.toArray(new JButton[0]);
        int nopt = buttons.length;
        int buttw = 0;
        for (int i = 0; i < nopt; ++i) {
            buttw = Math.max(buttw, buttons[i].getPreferredSize().width);
        }
        Box dialogBox = Box.createVerticalBox();
        for (int i = 0; i < nopt; ++i) {
            Dimension max = buttons[i].getMaximumSize();
            max.width = buttw;
            buttons[i].setMaximumSize(max);
            if (i > 0) {
                dialogBox.add(Box.createVerticalStrut(5));
            }
            dialogBox.add(buttons[i]);
        }
        JPanel dialogLine = new JPanel(new FlowLayout(2, 0, 0));
        dialogLine.add(dialogBox);
        dialogLine.setAlignmentX(0.0f);
        actionBox.add(Box.createVerticalStrut(10));
        actionBox.add(dialogLine);
        this.transferHandler_ = new LoadTransferHandler();
        this.setTransferHandler(this.transferHandler_);
        this.activeComponents_ = activeList.toArray(new Component[0]);
    }

    public StarTable showTableDialog(Component parent) {
        final JProgressBar progBar = new JProgressBar();
        final JDialog dialog = this.createDialog(parent, progBar);
        final StarTable[] result = new StarTable[1];
        final BasicTableConsumer tc = new BasicTableConsumer(dialog){
            static final /* synthetic */ boolean $assertionsDisabled;

            protected void setLoading(boolean isLoading) {
                super.setLoading(isLoading);
                TableLoadChooser.this.setEnabled(!isLoading);
                progBar.setIndeterminate(isLoading);
            }

            protected void tableLoaded(StarTable table) {
                if (!$assertionsDisabled && table == null) {
                    throw new AssertionError();
                }
                result[0] = table;
                dialog.dispose();
            }

            static {
                $assertionsDisabled = !(class$uk$ac$starlink$table$gui$TableLoadChooser == null ? (class$uk$ac$starlink$table$gui$TableLoadChooser = TableLoadChooser.class$("uk.ac.starlink.table.gui.TableLoadChooser")) : class$uk$ac$starlink$table$gui$TableLoadChooser).desiredAssertionStatus();
            }
        };
        this.setTableConsumer(tc);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                tc.cancel();
            }
        });
        this.setEnabled(true);
        dialog.show();
        return result[0];
    }

    public StarTable getTable(Component parent) {
        return this.showTableDialog(parent);
    }

    public void setTableConsumer(TableConsumer eater) {
        this.tableConsumer_ = eater;
    }

    public TableConsumer getTableConsumer() {
        return this.tableConsumer_;
    }

    public StarTableFactory getStarTableFactory() {
        return this.tableFactory_;
    }

    public void setStarTableFactory(StarTableFactory factory) {
        this.tableFactory_ = factory;
        this.formatSelector_.setModel(TableLoadChooser.makeFormatBoxModel(factory));
    }

    FilestoreChooser getFilestoreChooser() {
        for (int i = 0; i < this.dialogs_.length; ++i) {
            if (!(this.dialogs_[i] instanceof FilestoreTableLoadDialog)) continue;
            return ((FilestoreTableLoadDialog)this.dialogs_[i]).getChooser();
        }
        return null;
    }

    public void configureFromSaver(TableSaveChooser saver) {
        FilestoreChooser loadChooser = this.getFilestoreChooser();
        FilestoreChooser saveChooser = saver.getFilestoreChooser();
        if (loadChooser != null && saveChooser != null) {
            loadChooser.setModel(saveChooser.getModel());
        }
    }

    public String getFormatName() {
        return (String)this.formatSelector_.getSelectedItem();
    }

    public TableLoadDialog[] getKnownDialogs() {
        if (this.knownDialogs_ == null) {
            int i;
            HashSet<String> classes = new HashSet<String>();
            ArrayList<TableLoadDialog> tldList = new ArrayList<TableLoadDialog>();
            for (i = 0; i < this.dialogs_.length; ++i) {
                TableLoadDialog tld = this.dialogs_[i];
                classes.add(tld.getClass().getName());
                tldList.add(tld);
            }
            for (i = 0; i < this.extraDialogNames_.length; ++i) {
                String cname = this.extraDialogNames_[i];
                if (classes.contains(cname)) continue;
                classes.add(cname);
                try {
                    this.getClass();
                    TableLoadDialog tld = (TableLoadDialog)Class.forName(cname).newInstance();
                    tldList.add(tld);
                    continue;
                }
                catch (Throwable th) {
                    logger_.info("Error instantiating load dialogue " + cname + ": " + th);
                }
            }
            this.knownDialogs_ = tldList.toArray(new TableLoadDialog[0]);
        }
        return this.knownDialogs_;
    }

    public JMenu makeKnownDialogsMenu(String menuName) {
        final JMenu menu = new JMenu(menuName == null ? "DataSources" : menuName);
        menu.addMenuListener(new MenuListener(){
            boolean done;

            public void menuSelected(MenuEvent evt) {
                if (!this.done) {
                    this.done = true;
                    TableLoadDialog[] tlds = TableLoadChooser.this.getKnownDialogs();
                    for (int i = 0; i < tlds.length; ++i) {
                        menu.add(TableLoadChooser.this.makeAction(tlds[i]));
                    }
                }
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuCanceled(MenuEvent evt) {
            }
        });
        return menu;
    }

    public void setEnabled(boolean isEnabled) {
        if (isEnabled != this.isEnabled()) {
            for (int i = 0; i < this.activeComponents_.length; ++i) {
                this.activeComponents_[i].setEnabled(isEnabled);
            }
            this.locAction_.setEnabled(isEnabled);
        }
        super.setEnabled(isEnabled);
    }

    public JDialog createDialog(Component parent, JProgressBar progBar) {
        Frame frame = null;
        if (parent != null) {
            frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        }
        final JDialog dialog = new JDialog(frame, "Load Table", true);
        dialog.setDefaultCloseOperation(2);
        JPanel pane = new JPanel(new BorderLayout());
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)pane, "Center");
        dialog.getContentPane().add((Component)progBar, "South");
        pane.setLayout(new BorderLayout());
        pane.add((Component)this, "Center");
        Box iconBox = Box.createVerticalBox();
        iconBox.add(Box.createVerticalGlue());
        iconBox.add(new JLabel(this.getQueryIcon()));
        iconBox.add(Box.createVerticalGlue());
        iconBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)iconBox, "West");
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent evt) {
                dialog.dispose();
            }
        };
        Box cancelBox = Box.createHorizontalBox();
        cancelBox.add(Box.createHorizontalGlue());
        cancelBox.add(new JButton(cancelAction));
        cancelBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)cancelBox, "South");
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    public Action makeAction(final TableLoadDialog tld) {
        AbstractAction act = new AbstractAction(tld.getName()){

            public void actionPerformed(ActionEvent evt) {
                boolean status = tld.showLoadDialog(TableLoadChooser.this, TableLoadChooser.this.tableFactory_, TableLoadChooser.this.formatSelector_.getModel(), TableLoadChooser.this.getTableConsumer());
            }
        };
        act.putValue("ShortDescription", tld.getDescription());
        act.setEnabled(tld.isAvailable());
        return act;
    }

    public TransferHandler getTableImportTransferHandler() {
        return this.transferHandler_;
    }

    public void submitLocation(final String location) {
        final StarTableFactory factory = this.tableFactory_;
        final String format = this.getFormatName();
        new LoadWorker(this.getTableConsumer(), location){

            public StarTable attemptLoad() throws IOException {
                return factory.makeStarTable(location, format);
            }
        }.invoke();
    }

    public Action getSubmitAction() {
        return this.locAction_;
    }

    public static TableLoadDialog[] makeDefaultLoadDialogs() {
        return Loader.getClassInstances((String[])STANDARD_DIALOG_CLASSES, (String)LOAD_DIALOGS_PROPERTY, (Class)TableLoadDialog.class).toArray(new TableLoadDialog[0]);
    }

    public static ComboBoxModel makeFormatBoxModel(StarTableFactory factory) {
        DefaultComboBoxModel<String> fmodel = new DefaultComboBoxModel<String>();
        fmodel.addElement("(auto)");
        Iterator it = factory.getKnownBuilders().iterator();
        while (it.hasNext()) {
            TableBuilder handler = (TableBuilder)it.next();
            fmodel.addElement(handler.getFormatName());
        }
        return fmodel;
    }

    private Icon getQueryIcon() {
        if (this.queryIcon_ == null) {
            this.queryIcon_ = UIManager.getIcon("OptionPane.questionIcon");
        }
        return this.queryIcon_;
    }

    private class LoadTransferHandler
    extends TransferHandler {
        private LoadTransferHandler() {
        }

        public boolean canImport(JComponent comp, DataFlavor[] flavors) {
            return TableLoadChooser.this.tableFactory_.canImport(flavors);
        }

        public boolean importData(JComponent comp, Transferable trans) {
            StarTableFactory factory = TableLoadChooser.this.tableFactory_;
            TableConsumer eater = TableLoadChooser.this.getTableConsumer();
            eater.loadStarted("Dropped Table");
            try {
                eater.loadSucceeded(factory.makeStarTable(trans));
                return true;
            }
            catch (Throwable th) {
                eater.loadFailed(th);
                return false;
            }
        }

        public int getSourceActions(JComponent comp) {
            return 0;
        }
    }
}

