/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.jdbc.SqlReserved;
import uk.ac.starlink.table.jdbc.WriteMode;
import uk.ac.starlink.util.Loader;

public class JDBCFormatter {
    private final Connection conn_;
    private final String quote_;
    private final int maxColLeng_;
    private final int maxTableLeng_;
    private final StarTable table_;
    private final SqlColumn[] sqlCols_;
    private final int[] sqlTypes_;
    private final Map typeNameMap_;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCFormatter(Connection conn, StarTable table) throws SQLException, IOException {
        this.conn_ = conn;
        this.table_ = table;
        this.typeNameMap_ = JDBCFormatter.makeTypesMap(this.conn_);
        DatabaseMetaData meta = this.conn_.getMetaData();
        this.quote_ = meta.getIdentifierQuoteString();
        this.maxColLeng_ = meta.getMaxColumnNameLength();
        this.maxTableLeng_ = meta.getMaxTableNameLength();
        int ncol = this.table_.getColumnCount();
        boolean[] charType = new boolean[ncol];
        this.sqlTypes_ = new int[ncol];
        int[] charSizes = new int[ncol];
        boolean[] needSizes = new boolean[ncol];
        boolean needSomeSizes = false;
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo colInfo = this.table_.getColumnInfo(icol);
            this.sqlTypes_[icol] = this.getSqlType(colInfo.getContentClass());
            if (this.sqlTypes_[icol] != 12) continue;
            int leng = colInfo.getElementSize();
            if (leng > 0) {
                charSizes[icol] = leng;
                continue;
            }
            needSizes[icol] = true;
            needSomeSizes = true;
        }
        if (needSomeSizes) {
            RowSequence rseq = this.table_.getRowSequence();
            try {
                while (rseq.next()) {
                    for (int icol = 0; icol < ncol; ++icol) {
                        Object val;
                        if (!needSizes[icol] || (val = rseq.getCell(icol)) == null) continue;
                        charSizes[icol] = Math.max(charSizes[icol], val.toString().length());
                    }
                }
            }
            finally {
                rseq.close();
            }
        }
        this.sqlCols_ = new SqlColumn[ncol];
        HashSet<String> cnames = new HashSet<String>();
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo col = this.table_.getColumnInfo(icol);
            String colName = this.fixName(col.getName(), this.maxColLeng_);
            while (cnames.contains(colName)) {
                colName = colName + "_" + (icol + 1);
            }
            cnames.add(colName);
            int sqlType = this.sqlTypes_[icol];
            String tSpec = this.typeName(sqlType);
            if (tSpec == null) {
                logger.warning("Can't write column " + colName + " type " + col.getClass());
                continue;
            }
            if (sqlType == 12) {
                tSpec = tSpec + "(" + charSizes[icol] + ")";
            }
            this.sqlCols_[icol] = new SqlColumn(sqlType, colName, tSpec);
        }
    }

    public String getCreateStatement(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ").append(this.quote_).append(this.fixName(tableName, this.maxTableLeng_)).append(this.quote_).append(" (");
        int ncol = this.sqlCols_.length;
        boolean first = true;
        for (int icol = 0; icol < ncol; ++icol) {
            SqlColumn sqlCol = this.sqlCols_[icol];
            if (sqlCol == null) continue;
            if (!first) {
                sql.append(',');
            }
            first = false;
            sql.append(' ').append(this.quote_).append(sqlCol.getColumnName()).append(this.quote_).append(' ').append(sqlCol.getTypeSpec());
        }
        sql.append(')');
        return sql.toString();
    }

    public String getInsertStatement(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(this.quote_).append(this.fixName(tableName, this.maxTableLeng_)).append(this.quote_).append(" VALUES(");
        boolean first = true;
        int ncol = this.sqlCols_.length;
        for (int icol = 0; icol < ncol; ++icol) {
            if (this.sqlCols_[icol] == null) continue;
            if (!first) {
                sql.append(',');
            }
            first = false;
            sql.append(' ').append('?');
        }
        sql.append(" )");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJDBCTable(String tableName, WriteMode mode) throws IOException, SQLException {
        Statement stmt = this.conn_.createStatement();
        if (mode.getAttemptDrop()) {
            try {
                String cmd = "DROP TABLE " + this.quote_ + this.fixName(tableName, this.maxTableLeng_) + this.quote_;
                logger.info(cmd);
                stmt.executeUpdate(cmd);
                logger.warning("Dropped existing table " + tableName + " to write new one");
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (mode.getCreate()) {
            String create = this.getCreateStatement(tableName);
            logger.info(create);
            stmt.executeUpdate(create);
        }
        String insert = this.getInsertStatement(tableName);
        logger.info(insert);
        PreparedStatement pstmt = this.conn_.prepareStatement(insert);
        int ncol = this.sqlCols_.length;
        RowSequence rseq = this.table_.getRowSequence();
        try {
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                int pix = 0;
                for (int icol = 0; icol < ncol; ++icol) {
                    if (this.sqlCols_[icol] == null) continue;
                    ++pix;
                    Object val = row[icol];
                    if (Tables.isBlank(val)) {
                        pstmt.setNull(pix, this.sqlTypes_[icol]);
                        continue;
                    }
                    pstmt.setObject(pix, row[icol]);
                }
                pstmt.executeUpdate();
            }
        }
        finally {
            rseq.close();
        }
    }

    public SqlColumn getColumn(int icol) {
        return this.sqlCols_[icol];
    }

    public int getSqlType(Class clazz) {
        if (clazz.equals(Byte.class)) {
            return -6;
        }
        if (clazz.equals(Short.class)) {
            return 5;
        }
        if (clazz.equals(Integer.class)) {
            return 4;
        }
        if (clazz.equals(Long.class)) {
            return -5;
        }
        if (clazz.equals(Float.class)) {
            return 6;
        }
        if (clazz.equals(Double.class)) {
            return 8;
        }
        if (clazz.equals(Boolean.class)) {
            return -7;
        }
        if (clazz.equals(Character.class)) {
            return 1;
        }
        if (clazz.equals(String.class)) {
            return 12;
        }
        return 2004;
    }

    public String typeName(int sqlType) throws SQLException {
        Integer key = new Integer(sqlType);
        return this.typeNameMap_.containsKey(key) ? (String)this.typeNameMap_.get(key) : null;
    }

    private static Map makeTypesMap(Connection conn) throws SQLException {
        HashMap<Integer, String> types = new HashMap<Integer, String>();
        ResultSet typeInfos = conn.getMetaData().getTypeInfo();
        while (typeInfos.next()) {
            String name = typeInfos.getString("TYPE_NAME");
            short id = typeInfos.getShort("DATA_TYPE");
            Integer key = new Integer(id);
            if (types.containsKey(key)) continue;
            types.put(key, name);
        }
        typeInfos.close();
        if (!types.containsKey(new Integer(0))) {
            types.put(new Integer(0), "NULL");
        }
        types.put(new Integer(12), "VARCHAR");
        JDBCFormatter.setTypeFallback(types, 6, 7);
        JDBCFormatter.setTypeFallback(types, 7, 6);
        JDBCFormatter.setTypeFallback(types, 6, 8);
        JDBCFormatter.setTypeFallback(types, 8, 6);
        JDBCFormatter.setTypeFallback(types, 5, 4);
        JDBCFormatter.setTypeFallback(types, -6, 5);
        JDBCFormatter.setTypeFallback(types, -5, 4);
        return types;
    }

    private static void setTypeFallback(Map types, int req, int fallback) {
        Integer reqKey = new Integer(req);
        Integer fallbackKey = new Integer(fallback);
        if (!types.containsKey(reqKey) && types.containsKey(fallbackKey)) {
            types.put(reqKey, types.get(fallbackKey));
        }
    }

    private String fixName(String name, int maxLeng) {
        name = name.replaceAll("\\W+", "_");
        if (maxLeng > 0 && name.length() >= maxLeng) {
            name = name.substring(0, this.maxColLeng_ - 4);
        }
        if (SqlReserved.isReserved(name)) {
            logger.info("Renaming column " + name + " to " + name + "_ (SQL reserved word)");
            name = name + "_";
            if (!$assertionsDisabled && SqlReserved.isReserved(name)) {
                throw new AssertionError();
            }
        }
        return name;
    }

    public static void main(String[] args) throws IOException, SQLException {
        String usage = "\nUsage: JDBCFormatter intable jdbcURL tableName\n";
        if (args.length != 3) {
            System.err.println(usage);
            System.exit(1);
        }
        Loader.loadProperties();
        String inTable = args[0];
        String jdbcUrl = args[1];
        String tableName = args[2];
        StarTable intab = new StarTableFactory(false).makeStarTable(inTable);
        try {
            Connection conn = DriverManager.getConnection(jdbcUrl);
            new JDBCFormatter(conn, intab).createJDBCTable(tableName, WriteMode.CREATE);
        }
        catch (SQLException e) {
            if (e.getNextException() != null) {
                System.err.println("SQL exception chain: ");
                for (SQLException nextEx = e; nextEx != null; nextEx = nextEx.getNextException()) {
                    System.err.println("   " + e);
                }
            }
            throw e;
        }
    }

    static {
        $assertionsDisabled = !JDBCFormatter.class.desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.table.jdbc");
    }

    public static class SqlColumn {
        private final int sqlType_;
        private final String colName_;
        private final String typeSpec_;

        SqlColumn(int sqlType, String colName, String typeSpec) {
            this.sqlType_ = sqlType;
            this.colName_ = colName;
            this.typeSpec_ = typeSpec;
        }

        public int getSqlType() {
            return this.sqlType_;
        }

        public String getColumnName() {
            return this.colName_;
        }

        public String getTypeSpec() {
            return this.typeSpec_;
        }
    }
}

