/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.util.CgiQuery;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.VOStarTable;
import uk.ac.starlink.votable.VOTableBuilder;

public class ConeSearch {
    private final String serviceUrl_;
    private String label_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public ConeSearch(String serviceUrl) {
        new CgiQuery(serviceUrl);
        this.label_ = this.serviceUrl_ = serviceUrl;
    }

    public ConeSearch(RegResource resource, RegCapabilityInterface capability) {
        this(capability.getAccessUrl());
        String label;
        if (!"ivo://ivoa.net/std/ConeSearch".equals(capability.getStandardId())) {
            logger_.warning(capability.getAccessUrl() + " doesn't look like a cone search");
        }
        if ((label = null) == null) {
            label = resource.getShortName();
        }
        if (label == null) {
            label = resource.getTitle();
        }
        if (label == null) {
            label = resource.getIdentifier();
        }
        this.label_ = label;
    }

    public void performSearch(double ra, double dec, double sr, int verb, TableSink sink) throws IOException {
        URL qurl = this.getSearchURL(ra, dec, sr, verb);
        logger_.info("Submitting query: " + qurl);
        new VOTableBuilder().streamStarTable(qurl.openStream(), sink, null);
    }

    public StarTable performSearch(double ra, double dec, double sr, int verb, StarTableFactory tfact) throws IOException {
        VOElement topEl;
        URL qurl = this.getSearchURL(ra, dec, sr, verb);
        logger_.info("Submitting query: " + qurl);
        StoragePolicy storage = tfact.getStoragePolicy();
        try {
            topEl = new VOElementFactory(storage).makeVOElement(qurl.openStream(), qurl.toString());
        }
        catch (SAXException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        NodeList tableEls = topEl.getElementsByTagName("TABLE");
        for (int i = 0; i < tableEls.getLength(); ++i) {
            Element tableEl = (Element)tableEls.item(i);
            if (!(tableEl instanceof TableElement)) continue;
            VOStarTable st = new VOStarTable((TableElement)tableEl);
            st.setURL(qurl);
            return st;
        }
        ConeSearch.throwErrorElement((Element)topEl);
        throw new IOException("No TABLE or error param in returned stream");
    }

    private static void throwErrorElement(Element el) throws IOException {
        String tagName = el.getTagName();
        if (tagName.indexOf(58) >= 0) {
            tagName = tagName.substring(tagName.indexOf(58) + 1);
        }
        if ((el.getTagName().equalsIgnoreCase("INFO") || el.getTagName().equalsIgnoreCase("PARAM")) && el.hasAttribute("name") && el.getAttribute("name").equalsIgnoreCase("ERROR")) {
            throw new IOException(el.getAttribute("value"));
        }
        for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            ConeSearch.throwErrorElement((Element)node);
        }
    }

    public URL getSearchURL(double ra, double dec, double sr, int verb) {
        CgiQuery query = new CgiQuery(this.serviceUrl_).addArgument("RA", ra).addArgument("DEC", dec).addArgument("SR", sr);
        if (verb > 0 && verb < 3) {
            query.addArgument("VERB", (long)verb);
        }
        return query.toURL();
    }

    public static DescribedValue[] getMetadata(RegResource resource, RegCapabilityInterface cap) {
        if (!"ivo://ivoa.net/std/ConeSearch".equals(cap.getStandardId())) {
            logger_.warning(cap.getAccessUrl() + " doesn't look like a cone search");
        }
        ArrayList metadata = new ArrayList();
        ConeSearch.addMetadatum(metadata, resource.getShortName(), "Service short name", "Short name for cone search service");
        ConeSearch.addMetadatum(metadata, resource.getTitle(), "Service title", "Cone search service title");
        ConeSearch.addMetadatum(metadata, resource.getIdentifier(), "Identifier", "Unique resource registry identifier");
        ConeSearch.addMetadatum(metadata, resource.getPublisher(), "Service publisher", "Publisher for cone search service");
        ConeSearch.addMetadatum(metadata, resource.getReferenceUrl(), "Service reference URL", "Descriptive URL for search resource");
        ConeSearch.addMetadatum(metadata, resource.getContact(), "Contact person", "Individual to contact about this service");
        return metadata.toArray(new DescribedValue[0]);
    }

    private static void addMetadatum(List metadata, String value, String name, String description) {
        if (value != null && value.trim().length() > 0) {
            DefaultValueInfo info = new DefaultValueInfo(name, String.class, description);
            metadata.add(new DescribedValue((ValueInfo)info, (Object)value));
        }
    }

    public String toString() {
        return this.label_;
    }
}

