/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.starlink.table.gui.BasicTableLoadDialog;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.RegistryPanel;
import uk.ac.starlink.vo.RegistryQueryFactory;

public abstract class RegistryServiceTableLoadDialog
extends BasicTableLoadDialog {
    private final JComponent controlBox_;
    private final RegistryPanel regPanel_;
    private final String name_;
    private final RegistryQueryFactory queryFactory_;
    private boolean setup_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public RegistryServiceTableLoadDialog(String name, String description, RegistryQueryFactory queryFactory, boolean showCapabilities) {
        super(name, description);
        this.name_ = name;
        this.queryFactory_ = queryFactory;
        final Action okAction = this.getOkAction();
        okAction.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.regPanel_ = new RegistryPanel(queryFactory, showCapabilities){

            public RegCapabilityInterface[] getCapabilities(RegResource res) {
                return RegistryServiceTableLoadDialog.this.getCapabilities(res);
            }
        };
        this.regPanel_.getResourceSelectionModel().setSelectionMode(0);
        this.regPanel_.getResourceSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                okAction.setEnabled(RegistryServiceTableLoadDialog.this.regPanel_.getSelectedResources().length == 1);
            }
        });
        this.add(this.regPanel_, "Center");
        this.controlBox_ = Box.createVerticalBox();
        this.add(this.controlBox_, "South");
        Border lineBorder = BorderFactory.createLineBorder(Color.BLACK);
        Border gapBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border etchedBorder = BorderFactory.createEtchedBorder();
        this.regPanel_.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(lineBorder, gapBorder), "Available " + name + " Services"));
        this.controlBox_.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(lineBorder, gapBorder), name + " Parameters"));
        this.setBorder(gapBorder);
        Dimension prefSize = new Dimension(600, 400);
        if (showCapabilities) {
            prefSize.height += 70;
        }
        if (queryFactory.getComponent() != null) {
            prefSize.height += 100;
        }
        this.setPreferredSize(prefSize);
    }

    public boolean isAvailable() {
        return true;
    }

    protected JComponent getControlBox() {
        return this.controlBox_;
    }

    protected RegistryPanel getRegistryPanel() {
        return this.regPanel_;
    }

    public RegCapabilityInterface[] getCapabilities(RegResource resource) {
        return resource.getCapabilities();
    }

    protected JDialog createDialog(Component parent) {
        JDialog dia;
        if (!this.setup_) {
            this.setup_ = true;
            if (this.queryFactory_.getComponent() == null) {
                String msg = "Searching registry for " + this.name_ + " services";
                this.regPanel_.performAutoQuery(msg);
            }
        }
        if ((dia = super.createDialog(parent)).getJMenuBar() == null) {
            dia.setJMenuBar(new JMenuBar());
        }
        JMenu metaMenu = this.regPanel_.makeColumnVisibilityMenu("Columns");
        metaMenu.setMnemonic(67);
        dia.getJMenuBar().add(metaMenu);
        return dia;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.regPanel_.setEnabled(enabled);
    }
}

