/*
 * Decompiled with CFR 0.152.
 */
package alma.ssr.observingmodes;

import alma.ssr.observingmodes.Calibrations;
import alma.ssr.observingmodes.Groups;
import alma.ssr.observingmodes.ObservingScript;
import alma.ssr.observingmodes.Property;
import alma.ssr.observingmodes.types.ModeTypeEnum;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class ObservingMode
implements Serializable {
    private String name;
    private ModeTypeEnum type;
    private String documentation;
    private boolean standardMode = true;
    private boolean _hasstandardMode;
    private boolean runQuickLook = true;
    private boolean _hasrunQuickLook;
    private Calibrations calibrations;
    private Groups groups;
    private List<Property> propertyList = new ArrayList<Property>();
    private ObservingScript observingScript;

    public void addProperty(Property property) throws IndexOutOfBoundsException {
        this.propertyList.add(property);
    }

    public void addProperty(int n, Property property) throws IndexOutOfBoundsException {
        this.propertyList.add(n, property);
    }

    public void deleteRunQuickLook() {
        this._hasrunQuickLook = false;
    }

    public void deleteStandardMode() {
        this._hasstandardMode = false;
    }

    public Enumeration<? extends Property> enumerateProperty() {
        return Collections.enumeration(this.propertyList);
    }

    public Calibrations getCalibrations() {
        return this.calibrations;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public Groups getGroups() {
        return this.groups;
    }

    public String getName() {
        return this.name;
    }

    public ObservingScript getObservingScript() {
        return this.observingScript;
    }

    public Property getProperty(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.propertyList.size()) {
            throw new IndexOutOfBoundsException("getProperty: Index value '" + n + "' not in range [0.." + (this.propertyList.size() - 1) + "]");
        }
        return this.propertyList.get(n);
    }

    public Property[] getProperty() {
        Property[] propertyArray = new Property[]{};
        return this.propertyList.toArray(propertyArray);
    }

    public int getPropertyCount() {
        return this.propertyList.size();
    }

    public boolean getRunQuickLook() {
        return this.runQuickLook;
    }

    public boolean getStandardMode() {
        return this.standardMode;
    }

    public ModeTypeEnum getType() {
        return this.type;
    }

    public boolean hasRunQuickLook() {
        return this._hasrunQuickLook;
    }

    public boolean hasStandardMode() {
        return this._hasstandardMode;
    }

    public boolean isRunQuickLook() {
        return this.runQuickLook;
    }

    public boolean isStandardMode() {
        return this.standardMode;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException validationException) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Property> iterateProperty() {
        return this.propertyList.iterator();
    }

    public void marshal(Writer writer) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)writer);
    }

    public void marshal(ContentHandler contentHandler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)contentHandler);
    }

    public void removeAllProperty() {
        this.propertyList.clear();
    }

    public boolean removeProperty(Property property) {
        boolean bl = this.propertyList.remove(property);
        return bl;
    }

    public Property removePropertyAt(int n) {
        Property property = this.propertyList.remove(n);
        return property;
    }

    public void setCalibrations(Calibrations calibrations) {
        this.calibrations = calibrations;
    }

    public void setDocumentation(String string) {
        this.documentation = string;
    }

    public void setGroups(Groups groups) {
        this.groups = groups;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setObservingScript(ObservingScript observingScript) {
        this.observingScript = observingScript;
    }

    public void setProperty(int n, Property property) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.propertyList.size()) {
            throw new IndexOutOfBoundsException("setProperty: Index value '" + n + "' not in range [0.." + (this.propertyList.size() - 1) + "]");
        }
        this.propertyList.set(n, property);
    }

    public void setProperty(Property[] propertyArray) {
        this.propertyList.clear();
        for (int i = 0; i < propertyArray.length; ++i) {
            this.propertyList.add(propertyArray[i]);
        }
    }

    public void setRunQuickLook(boolean bl) {
        this.runQuickLook = bl;
        this._hasrunQuickLook = true;
    }

    public void setStandardMode(boolean bl) {
        this.standardMode = bl;
        this._hasstandardMode = true;
    }

    public void setType(ModeTypeEnum modeTypeEnum) {
        this.type = modeTypeEnum;
    }

    public static ObservingMode unmarshalObservingMode(Reader reader) throws MarshalException, ValidationException {
        return (ObservingMode)Unmarshaller.unmarshal(ObservingMode.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

