/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.arch.io;

import ca.nrc.cadc.arch.io.NoisyStream;
import ca.nrc.cadc.arch.io.NoisyStreamListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class NoisyBufferedInputStream
extends BufferedInputStream
implements NoisyStream {
    private int blocks = 0;
    private int bytes = 0;
    private int reportSize = 4096;
    private ArrayList listeners = new ArrayList();

    public NoisyBufferedInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public NoisyBufferedInputStream(InputStream inputStream, int n) {
        super(inputStream, n);
    }

    public int getNumBytes() {
        return this.reportSize * this.blocks + this.bytes;
    }

    public void setReportSize(int n) {
        this.bytes = this.getNumBytes();
        this.blocks = 0;
        this.reportSize = n;
        this.doit();
    }

    public void addListener(NoisyStreamListener noisyStreamListener) {
        this.listeners.add(noisyStreamListener);
        noisyStreamListener.update(this);
    }

    public void removeListener(NoisyStreamListener noisyStreamListener) {
        ((AbstractCollection)this.listeners).remove(noisyStreamListener);
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    protected void notifyListeners() {
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            NoisyStreamListener noisyStreamListener = (NoisyStreamListener)iterator.next();
            noisyStreamListener.update(this);
        }
    }

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.bytes;
            this.doit();
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.bytes += n3;
            this.doit();
        }
        return n3;
    }

    public void close() throws IOException {
        this.notifyListeners();
        super.close();
    }

    public void reset() throws IOException {
        if (this.markpos >= 0 && this.pos > this.markpos) {
            int n = this.pos - this.markpos;
            this.bytes = this.getNumBytes() - n;
            this.blocks = 0;
            this.doit();
        }
        super.reset();
    }

    private void doit() {
        boolean bl = false;
        while (this.bytes >= this.reportSize) {
            int n = this.bytes / this.reportSize;
            this.blocks += n;
            this.bytes -= n * this.reportSize;
            bl = true;
        }
        if (bl) {
            this.notifyListeners();
        }
    }
}

