/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.Site;
import diva.canvas.connector.AbstractConnector;
import diva.canvas.connector.BasicManhattanRouter;
import diva.canvas.connector.ManhattanRouter;
import diva.util.java2d.Polyline2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class ManhattanConnector
extends AbstractConnector {
    private double _bendRadius = 50.0;
    private Point2D _labelLocation;
    private ManhattanRouter _router;

    public ManhattanConnector(Site tail, Site head) {
        this(tail, head, new BasicManhattanRouter());
    }

    public ManhattanConnector(Site tail, Site head, ManhattanRouter router) {
        super(tail, head);
        this.setRouter(router);
    }

    public ManhattanRouter getRouter() {
        return this._router;
    }

    public double getBendRadius() {
        return this._bendRadius;
    }

    public void repositionLabel() {
        if (this._labelLocation == null) {
            this.route();
            return;
        }
        if (this.getLabelFigure() != null) {
            this.getLabelFigure().translateTo(this._labelLocation);
            this.getLabelFigure().autoAnchor(this.getShape());
        }
    }

    public void route() {
        this.repaint();
        Polyline2D poly = (Polyline2D)this._router.route(this);
        int count = poly.getVertexCount();
        this._labelLocation = count > 1 ? new Point2D.Double((poly.getX(count / 2) + poly.getX(count / 2 - 1)) / 2.0, (poly.getY(count / 2) + poly.getY(count / 2 - 1)) / 2.0) : new Point2D.Double(poly.getX(0), poly.getY(0));
        if (this._bendRadius == 0.0) {
            this.setShape(poly);
        } else {
            GeneralPath path = new GeneralPath();
            path.moveTo((float)poly.getX(0), (float)poly.getY(0));
            double prevX = poly.getX(0);
            double prevY = poly.getY(0);
            for (int i = 2; i < poly.getVertexCount(); ++i) {
                double x0 = prevX;
                double y0 = prevY;
                double x1 = poly.getX(i - 1);
                double y1 = poly.getY(i - 1);
                double x2 = poly.getX(i);
                double y2 = poly.getY(i);
                x2 = (x1 + x2) / 2.0;
                y2 = (y1 + y2) / 2.0;
                double d0 = Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
                double d1 = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                double r = Math.min(this._bendRadius, d0);
                r = Math.min(r, d1);
                if (d0 == 0.0 || d1 == 0.0) {
                    path.lineTo((float)x1, (float)y1);
                    continue;
                }
                double intX0 = x1 + r / d0 * (x0 - x1);
                double intY0 = y1 + r / d0 * (y0 - y1);
                double intX1 = x1 + r / d1 * (x2 - x1);
                double intY1 = y1 + r / d1 * (y2 - y1);
                path.lineTo((float)intX0, (float)intY0);
                path.curveTo((float)x1, (float)y1, (float)x1, (float)y1, (float)intX1, (float)intY1);
                prevX = x2;
                prevY = y2;
            }
            path.lineTo((float)poly.getX(poly.getVertexCount() - 1), (float)poly.getY(poly.getVertexCount() - 1));
            this.setShape(path);
        }
        this.repositionLabel();
        this.repaint();
    }

    public void setBendRadius(double r) {
        if (r < 0.0) {
            throw new IllegalArgumentException("Illegal radius: " + r);
        }
        this._bendRadius = r;
    }

    public void setRouter(ManhattanRouter router) {
        this._router = router;
        this.setShape(this._router.route(this));
    }

    public void translate(double x, double y) {
        this.repaint();
        Polyline2D line = (Polyline2D)this.getShape();
        line.translate(x, y);
        this.repaint();
    }
}

