/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.canvas.AbstractFigure;
import diva.canvas.Figure;
import diva.canvas.connector.BoundsSite;
import diva.canvas.connector.Terminal;
import diva.canvas.toolbox.LabelFigure;
import diva.util.java2d.PaintedObject;
import diva.util.java2d.ShapeUtilities;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class IconFigure
extends AbstractFigure {
    private Composite _composite;
    private Figure _background;
    private AffineTransform _transform = new AffineTransform();
    private PaintedObject _graphic;
    private ArrayList _terminals = new ArrayList();
    private ArrayList _sites = new ArrayList();
    private LabelFigure _label;

    public IconFigure(Figure f) {
        this._background = f;
        this._background.setParent(this);
    }

    public IconFigure(Figure f, PaintedObject g) {
        this._background = f;
        this._background.setParent(this);
        this._graphic = g;
    }

    public IconFigure(Figure f, String label) {
        this._background = f;
        this._background.setParent(this);
        this.setLabel(label);
    }

    public IconFigure(Figure f, PaintedObject g, String label) {
        this._background = f;
        this._background.setParent(this);
        this._graphic = g;
        this.setLabel(label);
    }

    public void addTerminal(Terminal t, int side, double offset) {
        BoundsSite site = new BoundsSite(this, this._sites.size(), side, offset);
        t.setAttachSite(site);
        this._sites.add(site);
        this._terminals.add(t);
        this.repaint();
    }

    public Figure getBackground() {
        return this._background;
    }

    public Rectangle2D getBounds() {
        Rectangle2D bounds = (Rectangle2D)this._background.getBounds().clone();
        bounds = ShapeUtilities.transformBounds(bounds, this._transform);
        Iterator i = this._terminals.iterator();
        while (i.hasNext()) {
            Rectangle2D.union(bounds, ((Figure)i.next()).getBounds(), bounds);
        }
        return bounds;
    }

    public PaintedObject getGraphic() {
        return this._graphic;
    }

    public Composite getComposite() {
        return this._composite;
    }

    public Shape getShape() {
        Shape s = ShapeUtilities.cloneShape(this._background.getShape());
        return ShapeUtilities.transformModify(s, this._transform);
    }

    public Terminal getTerminal(int index) {
        return (Terminal)this._terminals.get(index);
    }

    public boolean intersects(Rectangle2D r) {
        boolean result = this.getShape().intersects(r);
        Iterator i = this._terminals.iterator();
        while (!result && i.hasNext()) {
            result = result || ((Figure)i.next()).intersects(r);
        }
        return result;
    }

    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        if (this._composite != null) {
            g.setComposite(this._composite);
        }
        Iterator i = this._terminals.iterator();
        while (i.hasNext()) {
            ((Figure)i.next()).paint(g);
        }
        AffineTransform savedTransform = g.getTransform();
        g.transform(this._transform);
        this._background.paint(g);
        if (this._graphic != null) {
            this._graphic.paint(g);
        }
        g.setTransform(savedTransform);
    }

    public void setComposite(Composite c) {
        this._composite = c;
        this.repaint();
    }

    public void setLabel(String s) {
        if (this._label == null) {
            this._label = new LabelFigure(s);
        }
        this.repaint();
    }

    public Iterator terminals() {
        return this._terminals.iterator();
    }

    public void transform(AffineTransform at) {
        this.repaint();
        this._transform.preConcatenate(at);
        Iterator i = this._terminals.iterator();
        while (i.hasNext()) {
            ((Terminal)i.next()).relocate();
        }
        this.repaint();
    }

    public void translate(double x, double y) {
        this.repaint();
        this._transform.translate(x / this._transform.getScaleX(), y / this._transform.getScaleY());
        Iterator i = this._terminals.iterator();
        while (i.hasNext()) {
            ((Terminal)i.next()).translate(x, y);
        }
        this.repaint();
    }
}

