/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.canvas.AbstractFigure;
import diva.canvas.CanvasUtilities;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.net.URL;

public class ImageFigure
extends AbstractFigure
implements ImageObserver {
    private boolean _centered = false;
    private int _height = 0;
    private Image _image;
    private int _width = 0;
    private AffineTransform _xf = new AffineTransform();

    public ImageFigure() {
        this(null);
    }

    public ImageFigure(Image i) {
        this.setImage(i);
    }

    public Image getImage() {
        return this._image;
    }

    public Point2D getOrigin() {
        if (this._centered) {
            return super.getOrigin();
        }
        Point2D.Double point = new Point2D.Double(0.0, 0.0);
        this._xf.transform(point, point);
        return point;
    }

    public Shape getShape() {
        if (this._image != null) {
            int w = this._image.getWidth(this);
            int h = this._image.getHeight(this);
            if (w < 0 || h < 0) {
                w = this._width;
                h = this._height;
            }
            Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, w, h);
            return this._xf.createTransformedShape(r);
        }
        return new Rectangle2D.Double();
    }

    public boolean imageUpdate(Image image, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0xC0) != 0) {
            URL url = this.getClass().getResource("/diva/canvas/toolbox/errorImage.gif");
            Toolkit tk = Toolkit.getDefaultToolkit();
            this._image = tk.getImage(url);
            return true;
        }
        if ((infoflags & 3) != 0) {
            this._height = height;
            this._width = width;
            this._image.getWidth(this);
            this._image.getHeight(this);
            return true;
        }
        if ((infoflags & 0xC) != 0) {
            this._image.getWidth(this);
            this._image.getHeight(this);
            return true;
        }
        if ((infoflags & 0x20) != 0) {
            this.repaint();
            return false;
        }
        this._image.getWidth(this);
        this._image.getHeight(this);
        return true;
    }

    public boolean isCentered() {
        return this._centered;
    }

    public void paint(Graphics2D g) {
        if (this._image != null) {
            g.drawImage(this._image, this._xf, this);
        }
    }

    public void setCentered(boolean centered) {
        this.repaint();
        Point2D point = this.getOrigin();
        this._centered = centered;
        CanvasUtilities.translateTo(this, point.getX(), point.getY());
    }

    public void setImage(Image i) {
        this.repaint();
        this._image = i;
        this.repaint();
    }

    public void transform(AffineTransform t) {
        this.repaint();
        this._xf.preConcatenate(t);
        this.repaint();
    }
}

