/*
 * Decompiled with CFR 0.152.
 */
package diva.graph;

import diva.graph.GraphException;
import diva.graph.GraphModel;
import diva.graph.MutableGraphModel;
import diva.util.Filter;
import diva.util.FilteredIterator;
import diva.util.ProxyIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class GraphUtilities {
    private GraphUtilities() {
    }

    public static final boolean checkConsistency(Object composite, GraphModel model) {
        Iterator i = model.nodes(composite);
        while (i.hasNext()) {
            Object edge;
            Object node = i.next();
            Iterator j = model.outEdges(node);
            while (j.hasNext()) {
                edge = j.next();
                if (edge != null && model.getHead(edge) != null) continue;
                return false;
            }
            j = model.inEdges(node);
            while (j.hasNext()) {
                edge = j.next();
                if (edge != null && model.getTail(edge) != null) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean checkContainment(Object composite, GraphModel model) {
        if (!GraphUtilities.checkConsistency(composite, model)) {
            return false;
        }
        Iterator i = model.nodes(composite);
        while (i.hasNext()) {
            Object edge;
            Object node = i.next();
            if (model.getParent(node) != composite) {
                return false;
            }
            Iterator j = model.outEdges(node);
            while (j.hasNext()) {
                edge = j.next();
                Object head = model.getHead(edge);
                if (model.getParent(head) == composite) continue;
                return false;
            }
            j = model.inEdges(node);
            while (j.hasNext()) {
                edge = j.next();
                Object tail = model.getTail(edge);
                if (model.getParent(tail) == composite) continue;
                return false;
            }
        }
        return true;
    }

    public static final Set edgeSet(Object composite, GraphModel model) {
        if (model.isComposite(composite)) {
            Set nodeSet = GraphUtilities.nodeSet(composite, model);
            HashSet set = new HashSet();
            for (Object node : nodeSet) {
                Iterator i = model.outEdges(node);
                while (i.hasNext()) {
                    set.add(i.next());
                }
                i = model.inEdges(node);
                while (i.hasNext()) {
                    set.add(i.next());
                }
            }
            return set;
        }
        return new HashSet();
    }

    public static boolean isContainedNode(Object node, Object composite, GraphModel model) {
        if (model.isNode(node)) {
            boolean isOK = false;
            Object parent = model.getParent(node);
            while (!isOK && parent != null) {
                if (parent == composite) {
                    isOK = true;
                    continue;
                }
                if (model.isNode(node)) {
                    parent = model.getParent(parent);
                    continue;
                }
                parent = null;
            }
            return isOK;
        }
        return false;
    }

    public static boolean isPartiallyContainedEdge(Object edge, Object composite, GraphModel model) {
        if (model.isEdge(edge)) {
            Object head = model.getHead(edge);
            Object tail = model.getTail(edge);
            boolean headIsOK = GraphUtilities.isContainedNode(head, composite, model);
            boolean tailIsOK = GraphUtilities.isContainedNode(tail, composite, model);
            return headIsOK || tailIsOK;
        }
        return false;
    }

    public static boolean isTotallyContainedEdge(Object edge, Object composite, GraphModel model) {
        if (model.isEdge(edge)) {
            Object head = model.getHead(edge);
            Object tail = model.getTail(edge);
            if (head == null || tail == null) {
                return false;
            }
            boolean headIsOK = GraphUtilities.isContainedNode(head, composite, model);
            boolean tailIsOK = GraphUtilities.isContainedNode(tail, composite, model);
            return headIsOK && tailIsOK;
        }
        return false;
    }

    public static final Iterator inNodes(Object node, GraphModel model) {
        final GraphModel m = model;
        return new ProxyIterator(model.inEdges(node)){

            public Object next() {
                Object edge = super.next();
                return m.getTail(edge);
            }
        };
    }

    public static final Set nodeSet(Object composite, GraphModel model) {
        if (model.isComposite(composite)) {
            HashSet set = new HashSet();
            Iterator i = model.nodes(composite);
            while (i.hasNext()) {
                Object node = i.next();
                set.add(node);
                if (!model.isComposite(node)) continue;
                set.addAll(GraphUtilities.nodeSet(node, model));
            }
            return set;
        }
        return new HashSet();
    }

    public static final Iterator outNodes(Object node, GraphModel model) {
        final GraphModel m = model;
        return new ProxyIterator(model.outEdges(node)){

            public Object next() {
                Object edge = super.next();
                return m.getHead(edge);
            }
        };
    }

    public static final void purgeNode(Object eventSource, Object node, MutableGraphModel model) throws GraphException {
        Iterator i = model.outEdges(node);
        while (i.hasNext()) {
            model.disconnectEdge(eventSource, i.next());
        }
        i = model.inEdges(node);
        while (i.hasNext()) {
            model.disconnectEdge(eventSource, i.next());
        }
        model.removeNode(eventSource, node);
    }

    public static final Iterator partiallyContainedEdges(Object composite, GraphModel model) {
        return new FilteredIterator(GraphUtilities.edgeSet(model.getRoot(), model).iterator(), new PartiallyContainedEdgeFilter(model, composite));
    }

    public static final Iterator totallyContainedEdges(Object composite, GraphModel model) {
        return new FilteredIterator(GraphUtilities.edgeSet(model.getRoot(), model).iterator(), new TotallyContainedEdgeFilter(model, composite));
    }

    public static final Iterator localEdges(Object composite, GraphModel model) {
        return GraphUtilities.totallyContainedEdges(composite, model);
    }

    private static final class TotallyContainedEdgeFilter
    implements Filter {
        private GraphModel _model;
        private Object _composite;

        public TotallyContainedEdgeFilter(GraphModel model, Object composite) {
            this._model = model;
            this._composite = composite;
        }

        public boolean accept(Object o) {
            return GraphUtilities.isTotallyContainedEdge(o, this._composite, this._model);
        }
    }

    private static final class PartiallyContainedEdgeFilter
    implements Filter {
        private GraphModel _model;
        private Object _composite;

        public PartiallyContainedEdgeFilter(GraphModel model, Object composite) {
            this._model = model;
            this._composite = composite;
        }

        public boolean accept(Object o) {
            return GraphUtilities.isPartiallyContainedEdge(o, this._composite, this._model);
        }
    }
}

