/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.basic;

import diva.canvas.event.LayerEvent;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.AbstractInteractor;
import diva.canvas.interactor.SelectionDragger;
import diva.graph.BasicEdgeController;
import diva.graph.BasicNodeController;
import diva.graph.EdgeCreator;
import diva.graph.GraphPane;
import diva.graph.NodeInteractor;
import diva.graph.SimpleGraphController;
import diva.graph.basic.BasicEdgeRenderer;
import diva.graph.basic.BasicGraphModel;
import diva.graph.basic.BasicNodeRenderer;
import diva.graph.modular.Node;

public class BasicGraphController
extends SimpleGraphController {
    private int _globalCount = 0;
    private SelectionDragger _selectionDragger;
    private NodeCreator _nodeCreator;
    private EdgeCreator _edgeCreator;
    private MouseFilter _controlFilter = new MouseFilter(16, 2);

    public BasicGraphController() {
        BasicNodeController nc = new BasicNodeController(this);
        nc.setNodeRenderer(new BasicNodeRenderer(this));
        this.setNodeController(nc);
        BasicEdgeController ec = new BasicEdgeController(this);
        ec.setEdgeRenderer(new BasicEdgeRenderer());
        this.setEdgeController(ec);
    }

    protected void initializeInteraction() {
        GraphPane pane = this.getGraphPane();
        this._selectionDragger = new SelectionDragger(pane);
        this._selectionDragger.addSelectionModel(this.getSelectionModel());
        this._nodeCreator = new NodeCreator();
        this._nodeCreator.setMouseFilter(this._controlFilter);
        pane.getBackgroundEventLayer().addInteractor(this._nodeCreator);
        this._edgeCreator = new EdgeCreator(this){

            public Object createEdge() {
                Integer semanticObject = BasicGraphController.this._globalCount++;
                BasicGraphModel bgm = (BasicGraphModel)BasicGraphController.this.getGraphModel();
                return bgm.createEdge(semanticObject);
            }
        };
        this._edgeCreator.setMouseFilter(this._controlFilter);
        ((NodeInteractor)this.getNodeController().getNodeInteractor()).addInteractor(this._edgeCreator);
    }

    protected class NodeCreator
    extends AbstractInteractor {
        protected NodeCreator() {
        }

        public void mousePressed(LayerEvent e) {
            Integer semanticObject = BasicGraphController.this._globalCount++;
            BasicGraphModel bgm = (BasicGraphModel)BasicGraphController.this.getGraphModel();
            Node node = bgm.createNode(semanticObject);
            BasicGraphController.this.addNode(node, e.getLayerX(), e.getLayerY());
        }
    }
}

