/*
 * Decompiled with CFR 0.152.
 */
package diva.gui;

import diva.gui.MultipageModel;
import diva.gui.Page;
import diva.util.ModelWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public class MultipageWriter {
    private ModelWriter _modelWriter;

    public MultipageWriter(ModelWriter pageWriter) {
        this._modelWriter = pageWriter;
    }

    public void write(MultipageModel multipage, Writer out) throws IOException {
        this.writeHeader(out);
        out.write("<multipage title=\"");
        out.write(multipage.getTitle());
        out.write("\">\n");
        int ct = 0;
        Iterator iter = multipage.pages();
        while (iter.hasNext()) {
            Page s = (Page)iter.next();
            Object model = s.getModel();
            String label = s.getTitle();
            out.write("<page");
            if (label != null) {
                out.write(" title=\"");
                out.write(label);
                out.write("\"");
            }
            out.write(" num=\"");
            out.write(String.valueOf(ct));
            out.write("\">\n");
            out.write("<![CDATA[\n");
            this._modelWriter.writeModel(model, out);
            out.write("]]>");
            out.write("</page>\n");
            ++ct;
        }
        out.write("</multipage>\n");
    }

    private void writeHeader(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" standalone=\"no\"?>\n");
        writer.write("<!DOCTYPE multipage PUBLIC \"-//UC Berkeley//DTD multipage 1//EN\"\n\t\"http://www.gigascale.org/diva/dtd/multipage.dtd\">\n\n");
    }
}

