/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.algorithms;

import alma.acs.util.IsoDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DataBinner {
    public <T extends Comparable<T>> List<BinnedTimeValues<T>> binTimedData(List<TimeValue<T>> data, int binningIntervalMillis) {
        if (binningIntervalMillis <= 1 || binningIntervalMillis % 1000 != 0 && 1000 % (binningIntervalMillis % 1000) != 0) {
            throw new IllegalArgumentException("Bad binningIntervalMillis=" + binningIntervalMillis);
        }
        ArrayList<BinnedTimeValues<T>> ret = new ArrayList<BinnedTimeValues<T>>();
        if (data != null && data.size() > 0) {
            long t0;
            long tBinFloor = t0 = DataBinner.floor(data.get((int)0).timeMillis, binningIntervalMillis);
            long tCurrent = t0;
            ArrayList<TimeValue<Object>> currentBinData = new ArrayList();
            Iterator<TimeValue<T>> dataIter = data.iterator();
            while (dataIter.hasNext()) {
                BinnedTimeValues binnedTimeValue;
                TimeValue<T> timeValue = dataIter.next();
                if (timeValue.timeMillis < tCurrent) {
                    throw new IllegalArgumentException("Expecting time-ordered list! Error at time " + IsoDateFormat.formatDate(new Date(timeValue.timeMillis)));
                }
                tCurrent = timeValue.timeMillis;
                while (tCurrent >= tBinFloor + (long)binningIntervalMillis) {
                    binnedTimeValue = new BinnedTimeValues(tBinFloor + (long)(binningIntervalMillis / 2), currentBinData);
                    ret.add(binnedTimeValue);
                    currentBinData = new ArrayList();
                    tBinFloor += (long)binningIntervalMillis;
                }
                currentBinData.add(timeValue);
                if (dataIter.hasNext() || currentBinData.isEmpty()) continue;
                binnedTimeValue = new BinnedTimeValues(tBinFloor + (long)(binningIntervalMillis / 2), currentBinData);
                ret.add(binnedTimeValue);
            }
        }
        return ret;
    }

    public static long floor(long value, long multipleOf) {
        return value / multipleOf * multipleOf;
    }

    public static class TimeValue<T extends Comparable<T>>
    implements Comparable<TimeValue<T>> {
        public final long timeMillis;
        public final T value;

        public TimeValue(long timestamp, T value) {
            this.timeMillis = timestamp;
            this.value = value;
        }

        public String toString() {
            return IsoDateFormat.formatDate(new Date(this.timeMillis)) + " " + this.value;
        }

        @Override
        public int compareTo(TimeValue<T> other) {
            if (this.timeMillis < other.timeMillis) {
                return -1;
            }
            if (this.timeMillis > other.timeMillis) {
                return 1;
            }
            return this.value.compareTo(other.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TimeValue)) {
                return false;
            }
            TimeValue other = (TimeValue)obj;
            return new EqualsBuilder().append(this.timeMillis, other.timeMillis).append(this.value, other.value).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.timeMillis).append(this.value).toHashCode();
        }
    }

    public static class BinnedTimeValues<T extends Comparable<T>> {
        public final long timeMillis;
        public final List<TimeValue<T>> binnedData;

        BinnedTimeValues(long timeMillis, List<TimeValue<T>> binnedData) {
            this.timeMillis = timeMillis;
            this.binnedData = binnedData;
        }
    }
}

