/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.monitoring;

import alma.acs.monitoring.DynamicInterceptor;
import alma.acs.util.StopWatch;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleCallInterceptor {
    public static <T> T createSimpleInterceptor(Class<T> corbaInterface, T delegate, Logger logger) {
        SimpleInterceptionHandlerFactory interceptionHandlerFactory = new SimpleInterceptionHandlerFactory(logger);
        return DynamicInterceptor.createDynamicInterceptor(corbaInterface, delegate, logger, null, interceptionHandlerFactory);
    }

    private static class SimpleInterceptionHandlerFactory
    implements DynamicInterceptor.InterceptionHandlerFactory {
        private final Logger logger;

        SimpleInterceptionHandlerFactory(Logger logger) {
            this.logger = logger;
        }

        @Override
        public DynamicInterceptor.InterceptionHandler createInterceptionHandler() {
            return new SimpleInterceptionHandler(this.logger);
        }
    }

    private static class SimpleInterceptionHandler
    implements DynamicInterceptor.InterceptionHandler {
        private final Logger logger;
        private final Level logLevel = Level.FINER;
        private StopWatch methodInvWatch;
        private boolean isLoggable = false;
        private Method method;

        SimpleInterceptionHandler(Logger logger) {
            this.logger = logger;
        }

        @Override
        public boolean callReceived(Method method, Object[] args) {
            this.method = method;
            this.isLoggable = this.logger.isLoggable(this.logLevel);
            if (this.isLoggable) {
                this.methodInvWatch = new StopWatch(this.logger);
                this.logger.log(this.logLevel, "intercepted a call to '" + method.getName() + "'.");
            }
            return true;
        }

        @Override
        public Object callFinished(Object retVal, Object[] args, Throwable realThr) throws Throwable {
            if (this.isLoggable) {
                String msg = "returning from " + this.method.getName() + " after " + this.methodInvWatch.getLapTimeMillis() + " ms. ";
                if (realThr != null) {
                    msg = msg + realThr.getClass().getSimpleName() + " was thrown.";
                }
                this.logger.log(this.logLevel, msg);
            }
            if (realThr != null) {
                throw realThr;
            }
            return retVal;
        }
    }
}

