/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.shutdown;

import java.util.logging.Logger;

public abstract class ShutdownHookBase
extends Thread {
    protected volatile boolean m_regularShutdownExpected = false;
    protected final Logger logger;
    protected final String processName;

    public ShutdownHookBase(Logger logger, String processName) {
        super(processName + "ShutdownHook");
        this.processName = processName;
        this.logger = logger;
    }

    @Override
    public void run() {
        try {
            if (this.m_regularShutdownExpected) {
                this.regularTermination();
            } else {
                this.interruptDetected();
            }
        }
        catch (Throwable thr) {
            System.err.println("failure in ShutdownHook#run: ");
            thr.printStackTrace();
        }
    }

    protected void regularTermination() {
        this.logger.info("about to exit the JVM of " + this.processName);
    }

    protected abstract void interruptDetected();

    public void setRegularShutdownExpected() {
        this.m_regularShutdownExpected = true;
    }
}

