/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;

public class BooleanParameter
extends Parameter {
    private boolean booleanVal_;

    public BooleanParameter(String name) {
        super(name);
        this.setUsage("true|false");
    }

    public boolean booleanValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.booleanVal_;
    }

    public void setDefault(boolean dflt) {
        this.setDefault(dflt ? "true" : "false");
    }

    public void setValueFromString(Environment env, String stringval) throws TaskException {
        if ("TRUE".equalsIgnoreCase(stringval) || "YES".equalsIgnoreCase(stringval)) {
            this.booleanVal_ = true;
        } else if ("FALSE".equalsIgnoreCase(stringval) || "NO".equalsIgnoreCase(stringval)) {
            this.booleanVal_ = false;
        } else {
            throw new ParameterValueException((Parameter)this, stringval + " is not true/false/yes/no");
        }
        super.setValueFromString(env, stringval);
    }
}

