/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.nc.testsupport;

import alma.ACSErrTypeCommon.wrappers.AcsJIllegalStateEventEx;
import alma.ACSErrTypeCommon.wrappers.AcsJStateMachineActionEx;
import alma.acs.container.ContainerServicesBase;
import alma.acs.exceptions.AcsJException;
import alma.acs.nc.AcsEventSubscriberImplBase;
import alma.acs.nc.testsupport.InMemoryNcFake;
import alma.acsErrTypeLifeCycle.wrappers.AcsJEventSubscriptionEx;
import alma.acsnc.EventDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.scxml.ErrorReporter;
import org.apache.commons.scxml.EventDispatcher;
import org.apache.commons.scxml.SCInstance;
import org.apache.commons.scxml.TriggerEvent;

class InMemorySubscriber<T>
extends AcsEventSubscriberImplBase<T> {
    private final InMemoryNcFake nc;
    private final List<CachedEvent> suspendBuffer;

    InMemorySubscriber(InMemoryNcFake nc, ContainerServicesBase services, String clientName, Class<T> eventType) throws AcsJException {
        super(services, clientName, eventType);
        this.nc = nc;
        this.suspendBuffer = new ArrayList<CachedEvent>();
        this.stateMachineSignalDispatcher.setUpEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushData(Object eventData, EventDescription eventDesc) throws AcsJIllegalStateEventEx {
        if (this.isDisconnected()) {
            AcsJIllegalStateEventEx ex = new AcsJIllegalStateEventEx("Subscriber '" + this.clientName + "' is disconnected.");
            ex.setState("disconnected");
            throw ex;
        }
        if (eventData == null) {
            this.logger.warning("Received 'null' event.");
        } else if (this.isSuspended()) {
            List<CachedEvent> list = this.suspendBuffer;
            synchronized (list) {
                this.suspendBuffer.add(new CachedEvent(eventData, eventDesc));
            }
        } else if (this.hasGenericReceiver() || this.receivers.containsKey(eventData.getClass())) {
            this.processEventAsync(eventData, eventDesc);
        }
    }

    String getClientName() {
        return this.clientName;
    }

    @Override
    protected void createEnvironmentAction(EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Collection<TriggerEvent> derivedEvents) throws AcsJStateMachineActionEx {
        super.createEnvironmentAction(evtDispatcher, errRep, scInstance, derivedEvents);
    }

    @Override
    protected void destroyEnvironmentAction(EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Collection<TriggerEvent> derivedEvents) throws AcsJStateMachineActionEx {
        super.destroyEnvironmentAction(evtDispatcher, errRep, scInstance, derivedEvents);
    }

    @Override
    protected void createConnectionAction(EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Collection<TriggerEvent> derivedEvents) throws AcsJStateMachineActionEx {
        super.createConnectionAction(evtDispatcher, errRep, scInstance, derivedEvents);
    }

    @Override
    protected void destroyConnectionAction(EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Collection<TriggerEvent> derivedEvents) throws AcsJStateMachineActionEx {
        this.nc.disconnectSubscriber(this);
        super.destroyConnectionAction(evtDispatcher, errRep, scInstance, derivedEvents);
    }

    @Override
    protected void suspendAction(EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Collection<TriggerEvent> derivedEvents) throws AcsJStateMachineActionEx {
        super.suspendAction(evtDispatcher, errRep, scInstance, derivedEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void resumeAction(EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Collection<TriggerEvent> derivedEvents) throws AcsJStateMachineActionEx {
        super.resumeAction(evtDispatcher, errRep, scInstance, derivedEvents);
        final ArrayList<CachedEvent> oldBuffer = new ArrayList<CachedEvent>(this.suspendBuffer.size());
        List<CachedEvent> list = this.suspendBuffer;
        synchronized (list) {
            oldBuffer.addAll(this.suspendBuffer);
            this.suspendBuffer.clear();
        }
        Runnable processor = new Runnable(){

            @Override
            public void run() {
                try {
                    for (CachedEvent cachedEvent : oldBuffer) {
                        InMemorySubscriber.this.pushData(cachedEvent.eventData, cachedEvent.eventDesc);
                    }
                }
                catch (AcsJIllegalStateEventEx ex) {
                    InMemorySubscriber.this.logger.log(Level.WARNING, "Failed to deliver buffered events (suspended time) because subscriber is now disconnected.", ex);
                }
            }
        };
        this.services.getThreadFactory().newThread(processor).start();
    }

    @Override
    protected boolean isTraceEventsEnabled() {
        return false;
    }

    @Override
    protected double getMaxProcessTimeSeconds(String eventName) {
        return 2.0;
    }

    @Override
    protected void logEventReceiveHandlerException(String eventName, String receiverClassName, Throwable thr) {
        this.logger.log(Level.WARNING, "The registered event handler of type '" + receiverClassName + "' illegally threw an exception for event '" + eventName + "'.", thr);
    }

    @Override
    protected void logEventProcessingTimeExceeded(String eventName, long logOcurrencesNumber) {
        this.logger.warning("Took too long to process event '" + eventName + "' (logOcurrencesNumber=" + logOcurrencesNumber + ").");
    }

    @Override
    protected void logEventProcessingTooSlowForEventRate(long numEventsDiscarded, String eventName) {
        this.logger.warning("More events came in from the NC than the receiver processed. eventName=" + eventName + "; numEventsDiscarded=" + numEventsDiscarded + ".");
    }

    @Override
    protected void logNoEventReceiver(String eventName) {
        this.logger.warning("logNoEventReceiver: clientName=" + this.clientName + ", eventName=" + eventName);
    }

    @Override
    protected void logQueueShutdownError(int timeoutMillis, int remainingEvents) {
    }

    @Override
    protected void notifyFirstSubscription(Class<?> structClass) {
    }

    @Override
    protected void notifySubscriptionRemoved(Class<?> structClass) throws AcsJEventSubscriptionEx {
    }

    @Override
    protected void notifyNoSubscription() {
    }

    private static class CachedEvent {
        Object eventData;
        EventDescription eventDesc;

        CachedEvent(Object eventData, EventDescription eventDesc) {
            this.eventData = eventData;
            this.eventDesc = eventDesc;
        }
    }
}

