/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.ukatc.xsltchain;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import uk.ac.roe.ukatc.xsltchain.ApplicationOptionsException;

public class ApplicationOptions {
    private Vector<String> short_opts = new Vector();
    private Vector<String> long_opts = new Vector();
    private Vector<Boolean> opt_arg = new Vector();
    public Map<String, String> options = new HashMap<String, String>();
    public Map<String, String> descriptions;
    public Vector<String> arguments = new Vector();
    private int tok_sep;
    private String last_tok;

    ApplicationOptions() {
        this.descriptions = new HashMap<String, String>();
    }

    void AddOption(String short_opt, String long_opt, boolean takes_an_arg) {
        this.short_opts.add(short_opt);
        this.long_opts.add(long_opt);
        this.opt_arg.add(takes_an_arg);
    }

    void AddOption(String short_opt, String long_opt, boolean takes_an_arg, String desc) {
        this.short_opts.add(short_opt);
        this.long_opts.add(long_opt);
        this.opt_arg.add(takes_an_arg);
        this.descriptions.put(long_opt, desc);
    }

    boolean VerifyOpt(String opt) {
        if (this.hasOpt(opt)) {
            return true;
        }
        if (this.descriptions.containsKey(opt)) {
            System.out.println("Error: " + opt + " (" + this.descriptions.get(opt) + ") not set.");
        } else {
            System.out.println("Error: " + opt + " not set.");
        }
        return false;
    }

    int FindShortArg(String arg) {
        String s;
        if (arg.length() > 2) {
            this.tok_sep = 1;
            s = arg.substring(1, 2);
        } else {
            this.tok_sep = 0;
            s = arg.substring(1);
        }
        int i = this.short_opts.indexOf(s);
        if (i != -1) {
            this.last_tok = this.long_opts.elementAt(i);
        }
        return i;
    }

    int FindLongArg(String arg) {
        String s;
        int length = arg.indexOf(61);
        if (-1 != length) {
            this.tok_sep = length;
            s = arg.substring(2, length);
        } else {
            this.tok_sep = 0;
            s = arg.substring(2);
        }
        int i = this.long_opts.indexOf(s);
        if (-1 != i) {
            this.last_tok = s;
        }
        return i;
    }

    int ParseArgs(String[] args) {
        int i = 0;
        int count = 0;
        while (i < args.length) {
            String val;
            int idx;
            if (args[i].startsWith("--")) {
                idx = this.FindLongArg(args[i]);
                if (idx == -1) {
                    throw new ApplicationOptionsException("Unknown option :" + args[i]);
                }
                if (this.opt_arg.get(idx).booleanValue()) {
                    if (this.tok_sep > 0) {
                        val = args[i].substring(this.tok_sep + 1);
                        this.options.put(this.last_tok, val);
                    } else {
                        if (args[++i].startsWith("-")) {
                            throw new ApplicationOptionsException("Option " + this.last_tok + "requires a value");
                        }
                        this.options.put(this.last_tok, args[i]);
                    }
                } else {
                    this.options.put(this.last_tok, null);
                }
            } else if (args[i].startsWith("-")) {
                idx = this.FindShortArg(args[i]);
                if (idx == -1) {
                    throw new ApplicationOptionsException("Unknown option :" + args[i]);
                }
                if (this.opt_arg.get(idx).booleanValue()) {
                    if (this.tok_sep > 0) {
                        val = args[i].substring(this.tok_sep + 1);
                        this.options.put(this.last_tok, val);
                    } else {
                        if (args[++i].startsWith("-")) {
                            throw new ApplicationOptionsException("Option " + this.last_tok + "requires a value");
                        }
                        this.options.put(this.last_tok, args[i]);
                    }
                } else {
                    this.options.put(this.last_tok, null);
                }
            } else {
                this.arguments.add(args[i]);
            }
            ++i;
        }
        return count;
    }

    boolean hasOpt(String key) {
        return this.options.containsKey(key);
    }

    String getOpt(String key) {
        return this.options.get(key);
    }
}

