/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

import alma.sourcecat.dao.CatalogueDao;
import alma.sourcecat.model.Catalogue;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;

public class CatalogueDaoImpl
implements CatalogueDao {
    private static final Log LOG = LogFactory.getLog(CatalogueDaoImpl.class);
    public static final String LIST_SQL = "SELECT catalogue_id, catalogue_name FROM catalogues ORDER BY catalogue_name";
    public static final String INSERT_SQL = "INSERT INTO catalogues     (catalogue_id, catalogue_name) VALUES (?, ?)";
    public static final String DELETE_SQL = "DELETE FROM catalogues WHERE catalogue_id = ?";
    private JdbcTemplate jdbcTmpl;
    private Map<Integer, String> catalogueNames;

    @Override
    public Integer addCatalogue(String name) {
        String newCatalogueIdSql = "SELECT catalogue_id_seq.nextval FROM dual";
        int catalogueId = (Integer)this.jdbcTmpl.queryForObject("SELECT catalogue_id_seq.nextval FROM dual", Integer.class);
        int res = 0;
        try {
            res = this.jdbcTmpl.update(INSERT_SQL, new Object[]{catalogueId, name});
        }
        catch (DataAccessException e) {
            LOG.error((Object)e, (Throwable)e);
            res = 0;
        }
        return res == 1 ? catalogueId : 0;
    }

    @Override
    public Boolean removeCatalogue(Integer catalogueId) {
        boolean success = false;
        if (catalogueId != null) {
            try {
                success = this.jdbcTmpl.update(DELETE_SQL, new Object[]{catalogueId}) == 1;
            }
            catch (DataAccessException e) {
                LOG.error((Object)e, (Throwable)e);
                success = false;
            }
        }
        return success;
    }

    @Override
    public List<Catalogue> listCatalogues() {
        return this.jdbcTmpl.query(LIST_SQL, (RowMapper)new RowMapper<Catalogue>(){

            public Catalogue mapRow(ResultSet result, int rowNum) throws SQLException {
                return new Catalogue(result.getInt("catalogue_id"), result.getString("catalogue_name"));
            }
        });
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTmpl = new JdbcTemplate(dataSource);
    }

    @Override
    public Map<Integer, String> getCatalogues() {
        if (this.catalogueNames == null) {
            this.catalogueNames = new HashMap<Integer, String>();
            this.jdbcTmpl.query(LIST_SQL, new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    CatalogueDaoImpl.this.catalogueNames.put(rs.getInt("catalogue_id"), rs.getString("catalogue_name"));
                }
            });
        }
        return this.catalogueNames;
    }
}

