/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

import alma.sourcecat.dao.HealthCheckDao;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class HealthCheckDaoImpl
implements HealthCheckDao {
    private static final Log LOG = LogFactory.getLog(HealthCheckDaoImpl.class);
    private JdbcTemplate jdbcTmpl;
    private static final String VALIDATION_QUERY = "select 1 from dual";

    public void setDataSource(DataSource dataSource) {
        this.jdbcTmpl = new JdbcTemplate(dataSource);
    }

    @Override
    public boolean databaseIsAvailable() {
        try {
            int result = (Integer)this.jdbcTmpl.queryForObject(VALIDATION_QUERY, new Object[0], Integer.class);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("select 1 from dual returns " + Integer.toString(result)));
            }
            return true;
        }
        catch (DataAccessException e) {
            LOG.fatal((Object)("DataAccessException: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }
}

