/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

import alma.sourcecat.dao.RangeDao;
import alma.sourcecat.model.Range;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public final class RangeDaoImpl
implements RangeDao {
    private static final Log LOG = LogFactory.getLog(RangeDaoImpl.class);
    private JdbcTemplate jdbcTmpl;
    private static final String LIST_SQL = "SELECT     range_id, range_name, frequency_min, frequency_max FROM ranges ORDER BY COALESCE(frequency_min, 0)";
    private static final String NEW_SQL = "SELECT range_id_seq.nextval FROM dual";
    private static final String INSERT_SQL = "INSERT INTO ranges     (range_id, range_name, frequency_min, frequency_max) VALUES (?, ?, ?, ?)";
    private static final String DELETE_SQL = "DELETE FROM ranges WHERE range_id = ?";

    @Override
    public Integer addRange(String name, Double fMin, Double fMax) {
        int rangeId = (Integer)this.jdbcTmpl.queryForObject(NEW_SQL, Integer.class);
        int res = 0;
        try {
            res = this.jdbcTmpl.update(INSERT_SQL, new Object[]{rangeId, name, fMin, fMax});
        }
        catch (DataAccessException e) {
            LOG.error((Object)e, (Throwable)e);
            res = 0;
        }
        return res == 1 ? rangeId : 0;
    }

    @Override
    public Boolean removeRange(Integer rangeId) {
        boolean success = false;
        if (rangeId != null) {
            try {
                success = this.jdbcTmpl.update(DELETE_SQL, new Object[]{rangeId}) == 1;
            }
            catch (DataAccessException e) {
                LOG.error((Object)e, (Throwable)e);
                success = false;
            }
        }
        return success;
    }

    @Override
    public List<Range> listRanges() {
        return this.jdbcTmpl.query(LIST_SQL, (RowMapper)new RowMapper<Range>(){

            public Range mapRow(ResultSet result, int rowNum) throws SQLException {
                return new Range(result.getInt("range_id"), result.getString("range_name"), result.getDouble("frequency_min"), result.getDouble("frequency_max"));
            }
        });
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTmpl = new JdbcTemplate(dataSource);
    }
}

