/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

import alma.sourcecat.dao.CatalogueDao;
import alma.sourcecat.dao.CatalogueStatDao;
import alma.sourcecat.dao.MeasurementDao;
import alma.sourcecat.dao.RangeDao;
import alma.sourcecat.dao.SearchParameters;
import alma.sourcecat.dao.SourceCatDao;
import alma.sourcecat.dao.SourceDao;
import alma.sourcecat.dao.SourceNameDao;
import alma.sourcecat.dao.SourceRowMapper;
import alma.sourcecat.dao.TypeDao;
import alma.sourcecat.dao.XmlRpcNullConverter;
import alma.sourcecat.dao.annotation.ReadOnly;
import alma.sourcecat.dao.annotation.Rpc;
import alma.sourcecat.model.Catalogue;
import alma.sourcecat.model.CatalogueStat;
import alma.sourcecat.model.Measurement;
import alma.sourcecat.model.Range;
import alma.sourcecat.model.Source;
import alma.sourcecat.model.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class SourceCatDaoImpl
implements SourceCatDao {
    private static final Log LOG = LogFactory.getLog(SourceCatDaoImpl.class);
    private JdbcTemplate jdbcTmpl;
    private MeasurementDao measurementDao;
    private CatalogueDao catalogueDao;
    private CatalogueStatDao catalogueStatDao;
    private RangeDao rangeDao;
    private SourceDao sourceDao;
    private TypeDao typeDao;
    private SourceNameDao sourceNameDao;
    private static final String[] sortFields = new String[]{"source_id", "ra", "dec", "frequency", "flux", "flux_uncertainty", "date_observed"};

    @Override
    public List<Measurement> searchMeasurements(SearchParameters queryArguments) {
        return this.measurementDao.searchMeasurements(queryArguments);
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTmpl = new JdbcTemplate(dataSource);
    }

    @Rpc
    public String ping() {
        LOG.info((Object)"Ping was called.");
        return "pong";
    }

    @Override
    @Rpc
    public Source getSource(Integer sourceId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("-> getSource(" + sourceId + ")"));
        }
        Source source = this.getSourcePlus(sourceId, true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- getSource");
        }
        return source;
    }

    @Override
    @Rpc
    public Source getSourcePlus(Integer sourceId, boolean onlyValid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("-> getSourcePlus(" + sourceId + ", " + (onlyValid ? "onlyValid" : "all") + ")"));
        }
        Source source = this.getSourceAllOptions(sourceId, onlyValid, true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- getSourcePlus");
        }
        return source;
    }

    @Override
    public String[] listSearchSortFields() {
        return sortFields;
    }

    @Override
    @Rpc
    public Source getSourceAllOptions(Integer sourceId, boolean onlyValid, boolean convertNulls) {
        String sql = "SELECT source_id, sn.id name_id, sn.name, type_id, type_name,    ra_deg, ra_deg_uncertainty, dec_deg, dec_deg_uncertainty,    sources.update_user, sources.update_date, sources.update_comment,    measurement_id, catalogue_id, ra, ra_uncertainty, dec,    dec_uncertainty, frequency, flux, flux_uncertainty,    degree, degree_uncertainty, angle, angle_uncertainty,    uvmin, uvmax, origin, date_observed, valid FROM sources  LEFT JOIN sourcename sn USING (source_id)  LEFT JOIN source_type USING (source_id)  LEFT JOIN types USING (type_id)  LEFT JOIN measurements USING (source_id) WHERE source_id = :source_id" + (onlyValid ? " and ((valid = 1) or (valid is null))" : "") + " ORDER BY measurement_id";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("-> getSourceAllOptions(" + sourceId + ", " + (onlyValid ? "onlyValid" : "all") + ", " + (convertNulls ? "convertNulls" : "dontConvertNulls") + ")"));
        }
        Source source = new Source(0);
        this.jdbcTmpl.query(sql, (RowMapper)new SourceRowMapper(source), new Object[]{sourceId});
        if (convertNulls) {
            XmlRpcNullConverter.encodeMeasurements(source.getMeasurements());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- getSourceAllOptions");
        }
        return source;
    }

    @Override
    @Deprecated
    public Boolean setMeasurementState(Integer measurementId, Boolean newValid, Boolean oldValid) {
        return this.setMeasurementState(measurementId, newValid);
    }

    @Override
    @Rpc
    public Boolean updateMeasurement(Integer measurementId, Double ra, Double raUncertainty, Double dec, Double decUncertainty, Double frequency, Double flux, Double fluxUncertainty, Double degree, Double degreeUncertainty, Double angle, Double angleUncertainty, Double uvMin, Double uvMax, Double fluxratio, Date dateObserved, String origin, Integer catalogueId) {
        return this.updateMeasurement(measurementId, ra, raUncertainty, dec, decUncertainty, frequency, flux, fluxUncertainty, degree, degreeUncertainty, angle, angleUncertainty, uvMin, uvMax, fluxratio, dateObserved, origin, catalogueId, "xmlRpc", "");
    }

    @Override
    public Boolean updateMeasurement(Integer measurementId, Double ra, Double raUncertainty, Double dec, Double decUncertainty, Double frequency, Double flux, Double fluxUncertainty, Double degree, Double degreeUncertainty, Double angle, Double angleUncertainty, Double uvMin, Double uvMax, Double fluxratio, Date dateObserved, String origin, Integer catalogueId, String updateUser, String updateComment) {
        raUncertainty = XmlRpcNullConverter.decode(raUncertainty);
        decUncertainty = XmlRpcNullConverter.decode(decUncertainty);
        fluxUncertainty = XmlRpcNullConverter.decode(fluxUncertainty);
        degree = XmlRpcNullConverter.decode(degree);
        angle = XmlRpcNullConverter.decode(angle);
        angleUncertainty = XmlRpcNullConverter.decode(angleUncertainty);
        uvMin = XmlRpcNullConverter.decode(uvMin);
        uvMax = XmlRpcNullConverter.decode(uvMax);
        origin = XmlRpcNullConverter.decode(origin);
        String sql = "UPDATE measurements SET     ra = ?,     ra_uncertainty = ?,     dec = ?,     dec_uncertainty = ?,     frequency = ?,     flux = ?,     flux_uncertainty = ?,     degree = ?,     degree_uncertainty = ?,    angle = ?,     angle_uncertainty = ?,     uvmin = ?, uvmax = ?,     date_observed = ?,     origin = ?,     catalogue_id = ?,     update_date = sysdate,    update_user = ?,    update_comment = ?WHERE measurement_id = ?";
        return this.jdbcTmpl.update("UPDATE measurements SET     ra = ?,     ra_uncertainty = ?,     dec = ?,     dec_uncertainty = ?,     frequency = ?,     flux = ?,     flux_uncertainty = ?,     degree = ?,     degree_uncertainty = ?,    angle = ?,     angle_uncertainty = ?,     uvmin = ?, uvmax = ?,     date_observed = ?,     origin = ?,     catalogue_id = ?,     update_date = sysdate,    update_user = ?,    update_comment = ?WHERE measurement_id = ?", new Object[]{ra, raUncertainty, dec, decUncertainty, frequency, flux, fluxUncertainty, degree, degreeUncertainty, angle, angleUncertainty, uvMin, uvMax, dateObserved, origin, catalogueId, updateUser, updateComment, measurementId}) == 1;
    }

    @Override
    @ReadOnly
    @Rpc
    public List<Catalogue> listCatalogues() {
        return this.catalogueDao.listCatalogues();
    }

    @Override
    @Rpc
    public Integer addCatalogue(String name) {
        return this.catalogueDao.addCatalogue(name);
    }

    @Override
    @Rpc
    public Boolean removeCatalogue(Integer catalogueId) {
        return this.catalogueDao.removeCatalogue(catalogueId);
    }

    @Override
    @ReadOnly
    @Rpc
    public List<CatalogueStat> cataloguesStat() {
        return this.catalogueStatDao.cataloguesStat();
    }

    @Override
    @ReadOnly
    @Rpc
    public List<Range> listRanges() {
        return XmlRpcNullConverter.encodeRanges(this.rangeDao.listRanges());
    }

    @Override
    @Rpc
    public Integer addRange(String name, Double fMin, Double fMax) {
        return this.rangeDao.addRange(name, fMin, fMax);
    }

    @Override
    @Rpc
    public Boolean removeRange(Integer rangeId) {
        return this.rangeDao.removeRange(rangeId);
    }

    @Override
    @Rpc
    public Boolean removeSourceType(Integer sourceId, Integer typeId) {
        return this.sourceDao.removeSourceType(sourceId, typeId);
    }

    @Override
    @Rpc
    public Integer addSource() {
        return this.sourceDao.addSource();
    }

    @Override
    @ReadOnly
    @Rpc
    public List<Type> listTypes() {
        return this.typeDao.listTypes();
    }

    @Override
    @Rpc
    public Boolean addSourceType(Integer sourceId, Integer typeId) {
        return this.typeDao.addSourceType(sourceId, typeId);
    }

    @Override
    @Rpc
    public Integer addType(String name) {
        return this.typeDao.addType(name);
    }

    @Override
    @Rpc
    public Boolean removeType(Integer typeId) {
        return this.typeDao.removeType(typeId);
    }

    @Override
    @Rpc
    public Integer addSourceName(Integer sourceId, String newName) {
        return this.sourceNameDao.addSourceName(sourceId, newName);
    }

    @Override
    @Rpc
    public Boolean removeSourceName(Integer sourceId, Integer nameId) {
        return this.sourceNameDao.removeSourceName(sourceId, nameId);
    }

    @Override
    @Rpc
    public Boolean setMeasurementState(Integer measurementId, Boolean valid) {
        return this.measurementDao.setMeasurementState(measurementId, valid);
    }

    @Override
    @Rpc
    public Integer addMeasurement(Integer sourceId, Double ra, Double raUncertainty, Double dec, Double decUncertainty, Double frequency, Double flux, Double fluxUncertainty, Double degree, Double degreeUncertainty, Double angle, Double angleUncertainty, Double fluxratio, Double uvMin, Double uvMax, Date dateObserved, String origin, Integer catalogueId) {
        return this.measurementDao.addMeasurement(sourceId, ra, raUncertainty, dec, decUncertainty, frequency, flux, fluxUncertainty, degree, degreeUncertainty, angle, angleUncertainty, uvMin, uvMax, dateObserved, origin, catalogueId);
    }

    @Override
    @ReadOnly
    @Rpc
    public List<Measurement> searchMeasurements(Integer limit, Object[] catalogues, Object[] types, String name, Double ra, Double dec, Double radius, Object[] ranges, Double fLower, Double fUpper, Double fluxMin, Double fluxMax, Double degreeMin, Double degreeMax, Double angleMin, Double angleMax, String sortBy, boolean asc, boolean searchOnDate, Integer dateCriteria, String date) {
        return this.measurementDao.searchMeasurements(limit, catalogues, types, name, ra, dec, radius, ranges, fLower, fUpper, fluxMin, fluxMax, degreeMin, degreeMax, angleMin, angleMax, sortBy, asc, searchOnDate, dateCriteria, date);
    }

    @Override
    @ReadOnly
    @Rpc
    public List<Measurement> searchMeasurementsPlus(Integer limit, Object[] catalogues, Object[] types, String name, Double ra, Double dec, Double radius, Object[] ranges, Double fLower, Double fUpper, Double fluxMin, Double fluxMax, Double degreeMin, Double degreeMax, Double angleMin, Double angleMax, String sortBy, boolean asc, boolean searchOnDate, Integer dateCriteria, String date, boolean onlyValid) {
        return this.measurementDao.searchMeasurementsPlus(limit, catalogues, types, name, ra, dec, radius, ranges, fLower, fUpper, fluxMin, fluxMax, degreeMin, degreeMax, angleMin, angleMax, sortBy, asc, searchOnDate, dateCriteria, date, onlyValid);
    }

    @Override
    public List<Measurement> searchMeasurements913(Integer limit, Object[] catalogues, Object[] types, String name, Double ra, Double dec, Double radius, Object[] ranges, Double fLower, Double fUpper, Double fluxMin, Double fluxMax, Double degreeMin, Double degreeMax, Double angleMin, Double angleMax, String sortBy, boolean asc, boolean searchOnDate, Integer dateCriteria, String date, boolean onlyValid, Double uvMin, Double uvMax) {
        return this.measurementDao.searchMeasurements913(limit, catalogues, types, name, ra, dec, radius, ranges, fLower, fUpper, fluxMin, fluxMax, degreeMin, degreeMax, angleMin, angleMax, sortBy, asc, searchOnDate, dateCriteria, date, onlyValid, uvMin, uvMax);
    }

    @Override
    public List<Measurement> searchMeasurements103(Integer sourceBandResultsLimit, Integer limit, Object[] catalogues, Object[] types, String name, Double ra, Double dec, Double radius, Object[] ranges, Double fLower, Double fUpper, Double fluxMin, Double fluxMax, Double degreeMin, Double degreeMax, Double angleMin, Double angleMax, String sortBy, boolean asc, boolean searchOnDate, Integer dateCriteria, String date, boolean onlyValid, Double uvMin, Double uvMax) {
        return this.measurementDao.searchMeasurements103(sourceBandResultsLimit, limit, catalogues, types, name, ra, dec, radius, ranges, fLower, fUpper, fluxMin, fluxMax, degreeMin, degreeMax, angleMin, angleMax, sortBy, asc, searchOnDate, dateCriteria, date, onlyValid, uvMin, uvMax);
    }

    public void setMeasurementDao(MeasurementDao measurementDao) {
        this.measurementDao = measurementDao;
    }

    public void setRangeDao(RangeDao rangeDao) {
        this.rangeDao = rangeDao;
    }

    public void setSourceDao(SourceDao sourceDao) {
        this.sourceDao = sourceDao;
    }

    public void setTypeDao(TypeDao typeDao) {
        this.typeDao = typeDao;
    }

    public void setSourceNameDao(SourceNameDao sourceNameDao) {
        this.sourceNameDao = sourceNameDao;
    }

    public void setCatalogueDao(CatalogueDao catalogueDao) {
        this.catalogueDao = catalogueDao;
    }

    public void setCatalogueStatDao(CatalogueStatDao catalogueStatDao) {
        this.catalogueStatDao = catalogueStatDao;
    }

    @Override
    public void refreshSourceNamesCache() {
        this.sourceNameDao.refreshCachedSourceNames();
    }

    @Override
    public Boolean updateSource(Integer sourceId, Double raDeg, Double raDegUncertainty, Double decDeg, Double decDegUncertainty, String updateUser, String updateComment) {
        if (updateUser == null) {
            throw new RuntimeException("updateUser may not be null");
        }
        Source source = this.getSource(sourceId);
        if (source == null) {
            throw new RuntimeException("Source not found with sourceId: " + sourceId);
        }
        if (raDeg != null) {
            source.setRaDeg(raDeg);
        }
        if (raDegUncertainty != null) {
            source.setRaDegUncertainty(raDegUncertainty);
        }
        if (decDeg != null) {
            source.setDecDeg(decDeg);
        }
        if (decDegUncertainty != null) {
            source.setDecDegUncertainty(decDegUncertainty);
        }
        source.setUpdateUser(updateUser);
        source.setUpdateComment(updateComment);
        source.setUpdateDate(new Date());
        String updateSql = "UPDATE sources SET     ra_deg = ?,     ra_deg_uncertainty = ?,     dec_deg = ?,     dec_deg_uncertainty = ?,     update_user = ?,     update_date = ?,     update_comment = ? WHERE source_id = ?";
        return this.jdbcTmpl.update("UPDATE sources SET     ra_deg = ?,     ra_deg_uncertainty = ?,     dec_deg = ?,     dec_deg_uncertainty = ?,     update_user = ?,     update_date = ?,     update_comment = ? WHERE source_id = ?", new Object[]{source.getRaDeg(), source.getRaDegUncertainty(), source.getDecDeg(), source.getDecDegUncertainty(), source.getUpdateUser(), source.getUpdateDate(), source.getUpdateComment(), source.getId()}) == 1;
    }

    @Override
    public Measurement getMeasurement(Integer measurementId) {
        return this.measurementDao.getMeasurement(measurementId);
    }

    static class FrequencyParameters {
        List<String> bandNames = new ArrayList<String>();
        Double lowerLimit = null;
        Double upperLimit = null;

        FrequencyParameters() {
        }
    }
}

