/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.io.InputStream;
import java.io.Reader;
import jsky.science.AbstractWavelength1D;
import jsky.science.Flux;
import jsky.science.Quantity;
import jsky.science.UnitsNotSupportedException;
import jsky.science.Wavelength;
import jsky.science.Wavelength1DModel;
import jsky.science.WavelengthArrayParseException;
import jsky.science.WavelengthArrayParserAsciiPairs;
import jsky.science.WavelengthArrayParserFitsHst;

public class Wavelength1DArray
extends AbstractWavelength1D {
    private double[] fWavelengths;
    private double[] fData;
    private int fNumPoints;
    private static String fWavelengthUnits;
    private static final String STR_WAVELENGTHDOT = "Wavelength1DArray.";
    public static final String DATA_PROPERTY = "Data";
    private static final long serialVersionUID = 1L;
    private static double[] NaN;
    private static int NaNSize;

    public Wavelength1DArray() {
        this(null, new Wavelength(100.0, Wavelength.NANOMETER), new Wavelength(1100.0, Wavelength.NANOMETER), 100);
    }

    public Wavelength1DArray(int inVal) {
        this(null, new Wavelength(100.0, Wavelength.NANOMETER), new Wavelength(1100.0, Wavelength.NANOMETER), inVal);
    }

    public Wavelength1DArray(String inName) {
        this(inName, new Wavelength(100.0, Wavelength.NANOMETER), new Wavelength(1100.0, Wavelength.NANOMETER), 100);
    }

    public Wavelength1DArray(Wavelength inMin, Wavelength inMax, int inPts) {
        this(null, inMin, inMax, inPts);
    }

    public Wavelength1DArray(Wavelength1DModel baseModel) {
        super(baseModel.getName());
        fWavelengthUnits = Quantity.getDefaultUnits(Wavelength.class);
        double[] baseData = baseModel.toArrayData(null, null, 0);
        double[] baseWave = baseModel.toArrayWavelengths(null, null, 0);
        this.fNumPoints = baseWave.length;
        this.fData = new double[this.fNumPoints];
        System.arraycopy(baseData, 0, this.fData, 0, this.fNumPoints);
        this.fWavelengths = new double[this.fNumPoints];
        System.arraycopy(baseWave, 0, this.fWavelengths, 0, this.fNumPoints);
    }

    public Wavelength1DArray(String inProp, Wavelength inMin, Wavelength inMax, int inPts) {
        this(inProp, inMin == null ? Double.NaN : inMin.getValue(), inMax == null ? Double.NaN : inMax.getValue(), inPts);
    }

    protected Wavelength1DArray(String inProp, double wLo, double wHi, int inPts) {
        super(inProp);
        fWavelengthUnits = Quantity.getDefaultUnits(Wavelength.class);
        this.fNumPoints = Math.max(1, inPts);
        this.fWavelengths = new double[this.fNumPoints];
        if (!Double.isNaN(wLo) && !Double.isNaN(wHi)) {
            this.fWavelengths[0] = wLo;
            if (this.fNumPoints > 1) {
                this.fWavelengths[this.fNumPoints - 1] = wHi;
                double increment = (wHi - wLo) / (double)(this.fNumPoints - 1);
                for (int i = 1; i < this.fNumPoints - 1; ++i) {
                    this.fWavelengths[i] = this.fWavelengths[i - 1] + increment;
                }
            }
        }
        this.fData = new double[this.fNumPoints];
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Wavelength1DArray that = (Wavelength1DArray)obj;
        if (this.fNumPoints != that.fNumPoints) {
            return false;
        }
        if (this.fData == null && that.fData == null && this.fWavelengths == null && that.fWavelengths == null) {
            return true;
        }
        if (this.fWavelengths == null && that.fWavelengths != null) {
            return false;
        }
        if (this.fWavelengths != null && that.fWavelengths == null) {
            return false;
        }
        if (this.fData == null && that.fData != null) {
            return false;
        }
        if (this.fData != null && that.fData == null) {
            return false;
        }
        for (int i = 0; i < this.fNumPoints; ++i) {
            if (this.fWavelengths[i] != that.fWavelengths[i]) {
                return false;
            }
            if (this.fData[i] == that.fData[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setPending(boolean b) {
        super.setPending(b);
    }

    public void setWavelengthAtIndex(int index, Wavelength inWL) {
        this.setWavelengthAtIndex(index, inWL.getValue());
    }

    public void setWavelengthAtIndex(int index, double inWL) {
        this.fWavelengths[index] = inWL;
        this.firePropertyChange(DATA_PROPERTY, null, null);
    }

    @Override
    public double getArea(Wavelength minWl, Wavelength maxWl, boolean interpolate) {
        return this.calculateArea(this.fWavelengths, this.fData, minWl, maxWl, interpolate);
    }

    public double[] toArrayWavelengths() {
        return this.fWavelengths;
    }

    @Override
    public double[] toArrayWavelengths(Wavelength minW, Wavelength maxW, int nPts, String units) {
        return this.toArrayWavelengths(minW == null ? Double.NaN : minW.getValue(units), maxW == null ? Double.NaN : maxW.getValue(units), nPts);
    }

    protected double[] toArrayWavelengths(double minwl, double maxwl, int nPts) {
        double[] ret;
        int iRight;
        if (minwl == this.fWavelengths[0] && maxwl == this.fWavelengths[this.fNumPoints - 1] && nPts == this.fNumPoints) {
            return this.fWavelengths;
        }
        int iLeft = Double.isNaN(minwl) ? 0 : this.getIndexOf(minwl);
        int n = iRight = Double.isNaN(maxwl) ? this.fNumPoints - 1 : this.getIndexOf(maxwl);
        if (!(nPts != iRight - iLeft + 1 && nPts != 0 || iRight < 0 || iLeft < 0 || this.fWavelengths[iRight] != maxwl && !Double.isNaN(maxwl) || this.fWavelengths[iLeft] != minwl && !Double.isNaN(minwl))) {
            nPts = iRight - iLeft + 1;
            ret = new double[nPts];
            System.arraycopy(this.fWavelengths, iLeft, ret, 0, nPts);
        } else {
            if (nPts == 0) {
                nPts = this.fNumPoints;
            }
            ret = new double[nPts];
            double delta = (maxwl - minwl) / (double)(nPts - 1);
            double wl = minwl;
            for (int i = 0; i < nPts; ++i) {
                ret[i] = minwl;
                minwl += delta;
            }
        }
        return ret;
    }

    @Override
    public double[] toArrayData(double[] wllist) {
        double[] ret = new double[wllist.length];
        for (int i = 0; i < wllist.length; ++i) {
            ret[i] = this.getValue(wllist[i]);
        }
        return ret;
    }

    public double[] toArrayData() {
        return this.fData;
    }

    @Override
    public double[] toArrayData(Wavelength minW, Wavelength maxW, int nPts) {
        return this.toArrayData(minW == null ? Double.NaN : minW.getValue(), maxW == null ? Double.NaN : maxW.getValue(), nPts);
    }

    protected double[] toArrayData(double minwl, double maxwl, int nPts) {
        if (minwl == this.fWavelengths[0] && maxwl == this.fWavelengths[this.fNumPoints - 1] && nPts == this.fNumPoints) {
            return this.fData;
        }
        return this.toArrayData(this.toArrayWavelengths(minwl, maxwl, nPts));
    }

    public void replaceDataSet(Wavelength1DArray newData) {
        double[] oldData = this.fData;
        if (newData != null) {
            this.fNumPoints = newData.getNumPoints();
            this.fWavelengths = newData.fWavelengths;
            this.fData = newData.fData;
        } else {
            this.fNumPoints = 0;
            this.fWavelengths = null;
            this.fData = null;
        }
        this.setException(null);
        this.firePropertyChange(DATA_PROPERTY, oldData, this.fData);
    }

    public Wavelength getWavelengthAtIndex(int index) {
        return this.fWavelengths == null || index >= this.fNumPoints || index < 0 ? null : new Wavelength(this.fWavelengths[index], fWavelengthUnits);
    }

    public double getWavelengthAtIndexAsDouble(int index) {
        return this.fWavelengths == null || index >= this.fNumPoints || index < 0 ? Double.NaN : this.fWavelengths[index];
    }

    public String getWavelengthUnits() {
        return fWavelengthUnits;
    }

    public int getIndexOf(double targetWL) {
        return this.getIndexOf(targetWL, this.fWavelengths);
    }

    public int getIndexOf(Wavelength targetWL) {
        return this.getIndexOf(targetWL, this.fWavelengths);
    }

    @Override
    public void setValue(Wavelength wavelength, double value) {
        int index = this.getIndexOf(wavelength, this.fWavelengths, true);
        if (index < 0) {
            this.insert(this.getIndexOf(wavelength, this.fWavelengths, false), wavelength, value);
        } else {
            this.setValueAtIndex(index, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(int index, Wavelength wl, double value) {
        double[] newData = new double[this.fData.length + 1];
        double[] newWave = new double[this.fWavelengths.length + 1];
        Wavelength1DArray wavelength1DArray = this;
        synchronized (wavelength1DArray) {
            System.arraycopy(this.fData, 0, newData, 0, index);
            System.arraycopy(this.fData, index, newData, index + 1, this.fData.length - index);
            System.arraycopy(this.fWavelengths, 0, newWave, 0, index);
            System.arraycopy(this.fWavelengths, index, newWave, index + 1, this.fData.length - index);
            this.fData = newData;
            this.fWavelengths = newWave;
            this.fNumPoints = this.fData.length;
            this.fData[index] = value;
            this.fWavelengths[index] = wl.getValue();
        }
        this.firePropertyChange(DATA_PROPERTY, null, null);
    }

    public void setValueAtIndex(int index, double inVal) {
        this.fData[index] = inVal;
        this.firePropertyChange(DATA_PROPERTY, null, null);
    }

    public double getValueAtIndex(int index) {
        return this.fData == null || index >= this.fNumPoints || index < 0 ? 0.0 : this.fData[index];
    }

    @Override
    public Object clone() {
        Wavelength1DArray newDS = (Wavelength1DArray)super.clone();
        if (newDS.fWavelengths != null) {
            newDS.fWavelengths = new double[this.fNumPoints];
            System.arraycopy(this.fWavelengths, 0, newDS.fWavelengths, 0, this.fNumPoints);
        }
        if (newDS.fData != null) {
            newDS.fData = new double[this.fNumPoints];
            System.arraycopy(this.fData, 0, newDS.fData, 0, this.fNumPoints);
        }
        return newDS;
    }

    @Override
    public double getValue(Wavelength inWl) {
        if (inWl == null) {
            return Double.NaN;
        }
        return this.getValue(inWl.getValue(fWavelengthUnits));
    }

    protected double getValue(double targetWl) {
        if (this.fWavelengths.length == 0 || Double.isNaN(targetWl)) {
            return Double.NaN;
        }
        if (targetWl < this.fWavelengths[0] || this.fWavelengths[this.fWavelengths.length - 1] < targetWl) {
            return 0.0;
        }
        int leftI = 0;
        int rightI = this.fWavelengths.length - 1;
        double leftWl = this.fWavelengths[leftI];
        double rightWl = this.fWavelengths[rightI];
        while (rightI - leftI >= 1) {
            if (targetWl == leftWl) {
                return this.fData[leftI];
            }
            if (targetWl == rightWl) {
                return this.fData[rightI];
            }
            if (rightI - leftI == 1) {
                return this.fData[leftI] + (this.fData[rightI] - this.fData[leftI]) * (targetWl - leftWl) / (rightWl - leftWl);
            }
            int midI = leftI + (rightI - leftI) / 2;
            double midWl = this.fWavelengths[midI];
            if (targetWl >= midWl) {
                leftI = midI;
                leftWl = midWl;
                continue;
            }
            rightI = midI;
            rightWl = midWl;
        }
        return this.fData[leftI];
    }

    public void setAllNaN(boolean dataOnly) {
        int i;
        if (NaN == null) {
            NaN = new double[NaNSize];
            for (i = 0; i < NaNSize; ++i) {
                Wavelength1DArray.NaN[i] = Double.NaN;
            }
        }
        for (i = 0; i < this.fNumPoints; i += NaNSize) {
            int nCopy = Math.min(NaNSize, this.fNumPoints - i);
            if (!dataOnly && this.fWavelengths != null) {
                System.arraycopy(NaN, 0, this.fWavelengths, i, nCopy);
            }
            if (this.fData == null) continue;
            System.arraycopy(NaN, 0, this.fData, i, nCopy);
        }
        this.firePropertyChange(DATA_PROPERTY, null, null);
    }

    public void setAllNaN() {
        this.setAllNaN(false);
    }

    public void add(Wavelength1DModel that) {
        double[] thatData = that.toArrayData(this.fWavelengths);
        for (int i = 0; i < this.fNumPoints; ++i) {
            this.setValueAtIndex(i, this.fData[i] + thatData[i]);
        }
    }

    public void mergeData(Wavelength1DModel inDS) {
        double[] datasetList = inDS.toArrayWavelengths(null, null, 0);
        double[] datasetValue = inDS.toArrayData(null, null, 0);
        int datasetPoints = inDS.getNumPoints();
        for (int i = 0; i < datasetPoints; ++i) {
            double wavelength = datasetList[i];
            double dataValue = datasetValue[i];
            if (this.fNumPoints == 1) {
                this.fData[0] = this.fData[0] + dataValue;
                continue;
            }
            if (this.fNumPoints <= 1) continue;
            int location = 0;
            boolean done = false;
            for (int index = 0; !done && index < this.fNumPoints; ++index) {
                if (index == 0) {
                    if (!(wavelength >= 0.0) || !(wavelength < this.fWavelengths[index + 1])) continue;
                    location = index;
                    done = true;
                    continue;
                }
                if (index == this.fNumPoints - 1) {
                    if (!(wavelength >= this.fWavelengths[index])) continue;
                    location = index;
                    done = true;
                    continue;
                }
                if (!(wavelength >= this.fWavelengths[index]) || !(wavelength < this.fWavelengths[index + 1])) continue;
                location = index;
                done = true;
            }
            this.fData[location] = this.fData[location] + dataValue;
        }
    }

    public void combineData(Wavelength1DModel baseDs, int nPts) {
        double[] baseWl = baseDs.toArrayWavelengths(null, null, 0);
        double[] baseData = baseDs.toArrayData(null, null, 0);
        int basePts = baseWl.length;
        if (nPts <= 1) {
            this.fData = new double[basePts];
            this.fWavelengths = new double[basePts];
            this.setNumPoints(baseWl.length, 0, false);
            System.arraycopy(baseData, 0, this.fData, 0, basePts);
            System.arraycopy(baseWl, 0, this.fWavelengths, 0, basePts);
        } else {
            int newP = basePts / nPts;
            this.fWavelengths = new double[newP];
            this.fData = new double[newP];
            Object tmpWl = null;
            for (int base = 0; base < newP; ++base) {
                this.fWavelengths[base] = baseWl[base * nPts];
                double newData = 0.0;
                for (int n = 0; n < nPts; ++n) {
                    if (base * nPts + n >= basePts) continue;
                    newData += baseData[base * nPts + n];
                }
                this.fData[base] = newData;
            }
            this.fNumPoints = newP;
        }
    }

    public void alignData(Wavelength1DModel baseDs) {
        double[] baseWL = baseDs.toArrayWavelengths(null, null, 0);
        int nPoints = baseWL.length;
        double[] tmp = new double[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            tmp[i] = this.getValue(new Wavelength(baseWL[i]));
        }
        this.fData = tmp;
        this.fWavelengths = baseWL;
        this.fNumPoints = nPoints;
    }

    public void trim() {
        int firstNonZero;
        int lastNonZero = this.fNumPoints - 1;
        if (this.fData[firstNonZero] == 0.0) {
            for (firstNonZero = 0; firstNonZero < this.fNumPoints && this.fData[firstNonZero] == 0.0; ++firstNonZero) {
            }
            --firstNonZero;
        }
        if (this.fData[lastNonZero] == 0.0) {
            while (lastNonZero > 0 && this.fData[lastNonZero] == 0.0) {
                --lastNonZero;
            }
            ++lastNonZero;
        }
        if (firstNonZero == 0 && lastNonZero == this.fNumPoints) {
            return;
        }
        int start = lastNonZero - firstNonZero + 1;
        if (start < 0) {
            if (this.fNumPoints >= 2) {
                this.fWavelengths[1] = this.fWavelengths[this.fNumPoints - 1];
                this.setNumPoints(2, 0, true);
            }
        } else {
            this.setNumPoints(start, firstNonZero, true);
        }
    }

    private void setNumPoints(int newP, int start, boolean preserve) {
        if (newP != this.fNumPoints) {
            int oldP = this.fNumPoints;
            double[] oldW = this.fWavelengths;
            double[] oldD = this.fData;
            this.fNumPoints = newP;
            this.fWavelengths = new double[newP];
            this.fData = new double[newP];
            if (preserve) {
                int copyP = Math.min(oldP - start, newP);
                System.arraycopy(oldW, start, this.fWavelengths, 0, copyP);
                System.arraycopy(oldD, start, this.fData, 0, copyP);
            }
        }
    }

    public void setNumPoints(int newP) {
        int oldP = this.fNumPoints;
        this.setNumPoints(newP, 0, true);
        this.firePropertyChange("NumPoints", new Integer(oldP), new Integer(newP));
    }

    @Override
    public int getNumPoints() {
        return this.fNumPoints;
    }

    public void multiply(double m) {
        int i = 0;
        while (i < this.fNumPoints) {
            int n = i++;
            this.fData[n] = this.fData[n] * m;
        }
    }

    public void parse(InputStream istr) throws WavelengthArrayParseException {
        this.parse(istr, null);
    }

    public void parse(Reader rdr) throws WavelengthArrayParseException {
        this.parseAscii(rdr, null);
    }

    public void parse(InputStream istr, String wlUnits) throws WavelengthArrayParseException {
        this.parseFits(istr, "WAVELENGTH", wlUnits, "FLUX", Flux.FLAM);
    }

    public void parseFits(InputStream istr, String wlColName, String wlUnits, String dataColName, String dataUnits) throws WavelengthArrayParseException {
        try {
            new WavelengthArrayParserFitsHst(this, istr, new String[]{"WAVELENGTH", "FLUX", wlUnits, Flux.FLAM}).parse();
        }
        catch (WavelengthArrayParseException wape) {
            throw wape;
        }
        catch (Exception fe) {
            new WavelengthArrayParserAsciiPairs(this, istr, new String[]{wlUnits, Flux.FLAM}).parse();
        }
    }

    public void parseAscii(Reader rdr, String wlUnits) throws WavelengthArrayParseException {
        new WavelengthArrayParserAsciiPairs(this, rdr, new String[]{wlUnits, Flux.FLAM}).parse();
    }

    @Override
    public void setFluxUnits(String units) throws UnitsNotSupportedException {
        if (this.fFluxUnits != null && this.fFluxUnits.equals(units)) {
            return;
        }
        if (this.fFluxUnits != null && units != null) {
            Wavelength1DArray array = Flux.convertWavelength1DModel(this, this.fFluxUnits, units);
            this.replaceDataSet(array);
        }
        this.fFluxUnits = units;
    }

    static {
        NaN = null;
        NaNSize = 1000;
    }
}

