/*
 * Decompiled with CFR 0.152.
 */
package jsky.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TreeMap;
import javax.print.attribute.Attribute;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.coords.TargetDesc;
import jsky.plot.ElevationPlotModel;
import jsky.plot.ElevationPlotUtil;
import jsky.util.I18N;
import jsky.util.PrintableWithDialog;
import jsky.util.SaveableWithDialog;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.PrintUtil;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class ElevationPanel
extends JPanel
implements PrintableWithDialog,
SaveableWithDialog {
    private static final I18N _I18N = I18N.getInstance(ElevationPanel.class);
    private JFreeChart _chart;
    private ChartPanel _chartPanel;
    private NumberAxis _valueAxis2;
    private static final float DARKNESS_ALPHA = 0.1f;
    private static final Composite DARKNESS_COMPOSITE = AlphaComposite.getInstance(3, 0.1f);
    private static final float TWILIGHT_ALPHA = 0.05f;
    private static final Composite TWILIGHT_COMPOSITE = AlphaComposite.getInstance(3, 0.05f);
    private static final Stroke DARKNESS_STROKE = new BasicStroke(0.0f);
    private static final Stroke DASHED_LINE_STROKE = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{4.0f, 4.0f}, 0.0f);
    private static final Paint[] _COLORS = ChartColor.createDefaultPaintArray();
    private ElevationPlotModel _model;
    private boolean _showTrajectoryLabels = true;
    private boolean _showLegend = true;
    private LegendItemCollection _legendItems;
    private Paint[] _itemColors;
    private boolean _paPlotVisible = true;
    private boolean _altitudePlotVisible = true;
    private String _yAxisLabel = _I18N.getString("AltitudeInDeg");
    public static final String Y2_AXIS_AIRMASS = _I18N.getString("Airmass");
    public static final String Y2_AXIS_PA = _I18N.getString("ParallacticAngle");
    public static final String[] Y2_AXIS_OPTIONS = new String[]{Y2_AXIS_AIRMASS, Y2_AXIS_PA};
    private String _y2AxisLabel = Y2_AXIS_AIRMASS;
    private static NumberFormat _yAxisNumberFormat = new DecimalFormat(){

        @Override
        public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
            if (number > 90.0) {
                return result;
            }
            return super.format(number, result, fieldPosition);
        }
    };
    private static NumberFormat _y2AxisAirmassNumberFormat = new DecimalFormat(){

        @Override
        public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
            if (number > 90.0 || number < 5.0) {
                return result;
            }
            double d = ElevationPlotUtil.getAirmass(number);
            return super.format(d, result, fieldPosition);
        }
    };
    private static NumberFormat _y2AxisPaNumberFormat = new DecimalFormat();
    private StandardXYItemRenderer _elevationItemRenderer = new StandardXYItemRenderer(2){

        public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset dataset, PlotRenderingInfo info) {
            XYItemRendererState result = super.initialise(g2, dataArea, plot, dataset, info);
            if (ElevationPanel.this._altitudePlotVisible && ElevationPanel.this._showTrajectoryLabels) {
                g2.setFont(LegendTitle.DEFAULT_ITEM_FONT);
                g2.setColor(Color.black);
                TimeSeriesCollection tsc = (TimeSeriesCollection)dataset;
                int count = tsc.getSeriesCount();
                for (int i = 0; i < count; ++i) {
                    TimeSeries timeSeries = tsc.getSeries(i);
                    String label = (String)((Object)timeSeries.getKey());
                    double xDataValue = ElevationPanel.this._model.getMaxElevationTime(i);
                    double yDataValue = ElevationPanel.this._model.getMaxElevation(i);
                    double x = plot.getDomainAxis().valueToJava2D(xDataValue, dataArea, RectangleEdge.BOTTOM);
                    double y = plot.getRangeAxis().valueToJava2D(yDataValue, dataArea, RectangleEdge.LEFT);
                    g2.rotate(-1.5707963267948966, x += 3.0, y -= 3.0);
                    g2.drawString(label, (int)x, (int)y);
                    g2.rotate(1.5707963267948966, x, y);
                }
            }
            return result;
        }

        public void drawDomainMarker(Graphics2D g2, XYPlot plot, ValueAxis domainAxis, Marker marker, Rectangle2D dataArea) {
            IntervalMarker m = (IntervalMarker)marker;
            double x1 = domainAxis.valueToJava2D(m.getStartValue(), dataArea, RectangleEdge.BOTTOM);
            double x2 = domainAxis.valueToJava2D(m.getEndValue(), dataArea, RectangleEdge.BOTTOM);
            Rectangle2D.Double rect = new Rectangle2D.Double(x1, dataArea.getMinY(), x2 - x1, dataArea.getHeight());
            g2.setPaint(m.getOutlinePaint());
            double alpha = m.getAlpha();
            if (alpha == (double)0.05f) {
                g2.setComposite(TWILIGHT_COMPOSITE);
            } else if (alpha == (double)0.1f) {
                g2.setComposite(DARKNESS_COMPOSITE);
            }
            g2.fill(rect);
            g2.setPaintMode();
        }

        public Paint getSeriesPaint(int series) {
            if (ElevationPanel.this._itemColors != null && ElevationPanel.this._itemColors.length > series) {
                return ElevationPanel.this._itemColors[series];
            }
            return super.getSeriesPaint(series);
        }

        public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
            if (ElevationPanel.this._altitudePlotVisible) {
                super.drawItem(g2, state, dataArea, info, plot, domainAxis, rangeAxis, dataset, series, item, crosshairState, pass);
            }
        }
    };
    private StandardXYItemRenderer _paItemRenderer = new StandardXYItemRenderer(2){

        public Paint getSeriesPaint(int series) {
            if (ElevationPanel.this._itemColors != null && ElevationPanel.this._itemColors.length > series) {
                return ElevationPanel.this._itemColors[series];
            }
            return super.getSeriesPaint(series);
        }

        public Stroke getSeriesStroke(int series) {
            return DASHED_LINE_STROKE;
        }
    };
    private StandardXYItemRenderer _hiddenItemRenderer = new StandardXYItemRenderer(2){

        public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        }
    };

    public ElevationPanel() {
        this.setLayout(new BorderLayout());
    }

    public void setModel(ElevationPlotModel model) {
        this._model = model;
        this._update();
        this._model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ElevationPanel.this._update();
            }
        });
    }

    public ElevationPlotModel getModel() {
        return this._model;
    }

    private void _updateYAxisSize() {
        if (this._chart != null) {
            XYPlot xyPlot = this._chart.getXYPlot();
            ValueAxis yAxis = xyPlot.getRangeAxis();
            ValueAxis yAxis2 = xyPlot.getRangeAxis(1);
            if (this._showTrajectoryLabels) {
                yAxis.setRange(0.0, 114.0);
                if (this._y2AxisLabel.equals(Y2_AXIS_AIRMASS)) {
                    yAxis2.setRange(0.0, 114.0);
                } else {
                    yAxis2.setRange(-180.0, 180.0);
                }
            } else {
                yAxis.setRange(0.0, 90.0);
                if (this._y2AxisLabel.equals(Y2_AXIS_AIRMASS)) {
                    yAxis2.setRange(0.0, 90.0);
                } else {
                    yAxis2.setRange(-180.0, 180.0);
                }
            }
        }
    }

    public void setShowTrajectoryLabels(boolean b) {
        this._showTrajectoryLabels = b;
        this._updateYAxisSize();
    }

    public void setPaPlotVisible(boolean visible) {
        this._paPlotVisible = visible;
        this._update();
    }

    public void setAltitudePlotVisible(boolean visible) {
        this._altitudePlotVisible = visible;
        this._update();
    }

    private String _getXAxisLabel() {
        if (this._model.getTimeZoneId().equals("Site Time")) {
            return _I18N.getString("time") + " (" + this._model.getTimeZone().getDisplayName() + ")";
        }
        return _I18N.getString("time") + " (" + this._model.getTimeZoneId() + ")";
    }

    public void setY2AxisLabel(String label) {
        this._y2AxisLabel = label;
        if (this._valueAxis2 != null) {
            this._valueAxis2.setLabel(label);
        }
        this._update();
    }

    public String getY2AxisLabel() {
        return this._y2AxisLabel;
    }

    private void _update() {
        XYPlot xyPlot;
        if (this._model == null) {
            return;
        }
        XYDataset dataset = this._model.getXYDataset();
        if (this._chart == null) {
            this._chartPanel = this._makeElevationChart(dataset);
            this.add((Component)this._chartPanel, "Center");
        } else {
            xyPlot = this._chart.getXYPlot();
            xyPlot.setDomainAxis((ValueAxis)this._makeDateAxis());
            xyPlot.setDataset(dataset);
        }
        this._chart.setTitle(this._model.getTitle());
        this._updateSecondaryYAxis(dataset);
        if (this._legendItems == null) {
            this._setDefaultLegendItems();
        }
        xyPlot = this._chart.getXYPlot();
        DateAxis axis = (DateAxis)xyPlot.getDomainAxis();
        axis.setRange(this._model.getStartDate(), this._model.getEndDate());
        axis.setLabel(this._getXAxisLabel());
        xyPlot.clearDomainMarkers();
        this._addDarknessMarker(xyPlot, this._model.getNauticalTwilightStart(), this._model.getNauticalTwilightEnd(), 0.05f, Color.gray);
        this._addDarknessMarker(xyPlot, this._model.getAstronomicalTwilightStart(), this._model.getAstronomicalTwilightEnd(), 0.1f, Color.black);
    }

    private DateAxis _makeDateAxis() {
        DateAxis timeAxis = new DateAxis(this._getXAxisLabel(), this._model.getTimeZone(), Locale.getDefault());
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm"){

            @Override
            public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
                if (ElevationPanel.this._model.getTimeZoneId().equals("LST")) {
                    date = ElevationPanel.this._model.getLst(date);
                }
                return super.format(date, toAppendTo, pos);
            }
        };
        dateFormat.setTimeZone(this._model.getTimeZone());
        timeAxis.setDateFormatOverride((DateFormat)dateFormat);
        return timeAxis;
    }

    private ChartPanel _makeElevationChart(XYDataset dataset) {
        String title = this._model.getTitle();
        this._chart = this._createTimeSeriesChart(title, this._yAxisLabel, this._y2AxisLabel, dataset);
        this._chart.setBackgroundPaint((Paint)this.getBackground());
        this._updateYAxisSize();
        TextTitle textTitle = this._chart.getTitle();
        textTitle.setFont(textTitle.getFont().deriveFont(12.0f));
        XYPlot xyPlot = this._chart.getXYPlot();
        xyPlot.addRangeMarker((Marker)new ValueMarker(ElevationPlotModel.getObsThreshold()));
        ChartPanel chartPanel = new ChartPanel(this._chart, false, false, false, false, false);
        chartPanel.setMaximumDrawWidth(100000);
        chartPanel.setMaximumDrawHeight(100000);
        return chartPanel;
    }

    private JFreeChart _createTimeSeriesChart(String title, String valueAxisLabel, String valueAxisLabel2, XYDataset dataset) {
        DateAxis timeAxis = this._makeDateAxis();
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        valueAxis.setAutoRangeIncludesZero(false);
        valueAxis.setNumberFormatOverride(_yAxisNumberFormat);
        XYPlot plot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, (XYItemRenderer)this._elevationItemRenderer){

            public LegendItemCollection getLegendItems() {
                if (ElevationPanel.this._legendItems == null) {
                    return super.getLegendItems();
                }
                return ElevationPanel.this._legendItems;
            }
        };
        this._valueAxis2 = new NumberAxis(valueAxisLabel2);
        plot.setRangeAxis(1, (ValueAxis)this._valueAxis2);
        plot.mapDatasetToRangeAxis(1, 1);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        if (this._showLegend) {
            chart.addLegend(new LegendTitle((LegendItemSource)plot));
        }
        return chart;
    }

    private void _updateSecondaryYAxis(XYDataset dataset) {
        XYPlot xyPlot = this._chart.getXYPlot();
        if (this._y2AxisLabel.equals(Y2_AXIS_AIRMASS)) {
            xyPlot.setDataset(1, dataset);
            this._valueAxis2.setAutoRangeIncludesZero(false);
            this._valueAxis2.setNumberFormatOverride(_y2AxisAirmassNumberFormat);
            xyPlot.setRenderer(1, (XYItemRenderer)this._hiddenItemRenderer);
        } else {
            XYDataset dataset2 = this._model.getSecondaryDataset();
            xyPlot.setDataset(1, dataset2);
            this._valueAxis2.setAutoRangeIncludesZero(true);
            this._valueAxis2.setNumberFormatOverride(_y2AxisPaNumberFormat);
            if (this._paPlotVisible) {
                xyPlot.setRenderer(1, (XYItemRenderer)this._paItemRenderer);
            } else {
                xyPlot.setRenderer(1, (XYItemRenderer)this._hiddenItemRenderer);
            }
        }
        this._updateYAxisSize();
    }

    public void setLegendItems(LegendItemCollection l) {
        this._legendItems = l;
    }

    private void _setDefaultLegendItems() {
        TargetDesc[] targets = this._model.getTargets();
        int colorIndex = 0;
        Paint[] colors = new Paint[targets.length];
        TreeMap<String, Paint> paintMap = new TreeMap<String, Paint>();
        LegendItemCollection lic = new LegendItemCollection();
        Rectangle shape = new Rectangle(-3, -3, 7, 7);
        for (int i = 0; i < targets.length; ++i) {
            String name = targets[i].getName();
            colors[i] = (Paint)paintMap.get(name);
            if (colors[i] != null) continue;
            Paint color = _COLORS[colorIndex++ % _COLORS.length];
            paintMap.put(name, color);
            colors[i] = color;
            lic.add(new LegendItem(name, name, null, null, (Shape)shape, color));
        }
        this._itemColors = colors;
        this._legendItems = lic;
    }

    public void setItemColors(Paint[] colors) {
        this._itemColors = colors;
    }

    private void _addDarknessMarker(XYPlot xyPlot, Date startDate, Date endDate, float alpha, Color color) {
        double end;
        double start = startDate.getTime();
        if (start < (end = (double)endDate.getTime())) {
            IntervalMarker m = new IntervalMarker(start, end, (Paint)color, DARKNESS_STROKE, (Paint)color, DARKNESS_STROKE, alpha);
            xyPlot.addDomainMarker((Marker)m);
        } else {
            double first = this._model.getDateForHour(0.0).getTime();
            double last = this._model.getDateForHour(24.0).getTime();
            IntervalMarker m1 = new IntervalMarker(start, last, (Paint)color, DARKNESS_STROKE, (Paint)color, DARKNESS_STROKE, alpha);
            xyPlot.addDomainMarker((Marker)m1);
            IntervalMarker m2 = new IntervalMarker(first, end, (Paint)color, DARKNESS_STROKE, (Paint)color, DARKNESS_STROKE, alpha);
            xyPlot.addDomainMarker((Marker)m2);
        }
    }

    public void print() throws PrinterException {
        PrintUtil printUtil = new PrintUtil((Printable)this._chartPanel);
        printUtil.setUseBgThread(false);
        printUtil.setAttribute((Attribute)OrientationRequested.LANDSCAPE);
        printUtil.print();
    }

    public void saveAs() {
        try {
            this._chartPanel.doSaveAs();
        }
        catch (Exception e) {
            DialogUtil.error((Exception)e);
        }
    }

    public void setShowLegend(boolean show) {
        this._showLegend = show;
        if (this._chart != null) {
            if (show) {
                this._chart.addLegend(new LegendTitle((LegendItemSource)this._chart.getPlot()));
            } else {
                this._chart.removeLegend();
            }
        }
    }

    static {
        _yAxisNumberFormat.setMinimumFractionDigits(0);
        _yAxisNumberFormat.setMaximumFractionDigits(0);
        _y2AxisAirmassNumberFormat.setMinimumFractionDigits(2);
        _y2AxisAirmassNumberFormat.setMaximumFractionDigits(2);
        _y2AxisPaNumberFormat.setMinimumFractionDigits(1);
        _y2AxisPaNumberFormat.setMaximumFractionDigits(1);
    }
}

