/*
 * Decompiled with CFR 0.152.
 */
package jsky.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.coords.TargetDesc;
import jsky.plot.ElevationPlotModel;
import jsky.util.I18N;
import jsky.util.PrintableWithDialog;
import jsky.util.SaveableWithDialog;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.PrintUtil;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.GanttRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.ui.RectangleEdge;

public class ObservationPanel
extends JPanel
implements PrintableWithDialog,
SaveableWithDialog {
    private static final I18N _I18N = I18N.getInstance(ObservationPanel.class);
    private JTabbedPane _tabbedPane;
    private String[] _categories;
    private JFreeChart[] _chart;
    private ChartPanel[] _chartPanel;
    private static Font _labelFont = new Font("Monospaced", 0, 10);
    private static final float DARKNESS_ALPHA = 0.1f;
    private static final Composite DARKNESS_COMPOSITE = AlphaComposite.getInstance(3, 0.1f);
    private static final float TWILIGHT_ALPHA = 0.05f;
    private static final Composite TWILIGHT_COMPOSITE = AlphaComposite.getInstance(3, 0.05f);
    private static final Stroke DARKNESS_STROKE = new BasicStroke();
    private static String[] _availablePriorities = new String[]{"High", "Medium", "Low"};
    private static Paint[] _availablePriorityColors = new Paint[]{Color.red, Color.blue, Color.green};
    private Map<String, Paint> _priorityPaintMap;
    private ElevationPlotModel _model;
    private LegendItemCollection _priorityLegendItemCollection;
    private boolean _showLegend = true;
    private GanttRenderer _renderer = new GanttRenderer(){

        public Paint getItemPaint(int row, int column) {
            TargetDesc[] targets = ObservationPanel.this._model.getTargets();
            if (column < targets.length) {
                String prio = targets[column].getPriority();
                Paint paint = (Paint)ObservationPanel.this._priorityPaintMap.get(prio);
                if (paint != null) {
                    return paint;
                }
            }
            return super.getItemPaint(row, column);
        }

        public void drawRangeMarker(Graphics2D g2, CategoryPlot plot, ValueAxis rangeAxis, Marker marker, Rectangle2D dataArea) {
            if (ObservationPanel.this._model.getNumTargets() == 0) {
                return;
            }
            IntervalMarker m = (IntervalMarker)marker;
            double x1 = rangeAxis.valueToJava2D(m.getStartValue(), dataArea, RectangleEdge.BOTTOM);
            double x2 = rangeAxis.valueToJava2D(m.getEndValue(), dataArea, RectangleEdge.BOTTOM);
            Rectangle2D.Double rect = new Rectangle2D.Double(x1, dataArea.getMinY(), x2 - x1, dataArea.getHeight());
            g2.setPaint(m.getOutlinePaint());
            double alpha = m.getAlpha();
            if (alpha == (double)0.05f) {
                g2.setComposite(TWILIGHT_COMPOSITE);
            } else if (alpha == (double)0.1f) {
                g2.setComposite(DARKNESS_COMPOSITE);
            }
            g2.fill(rect);
            g2.setPaintMode();
        }
    };

    public ObservationPanel() {
        this.setLayout(new BorderLayout());
        this._tabbedPane = new JTabbedPane();
        this.add((Component)this._tabbedPane, "Center");
        this._priorityPaintMap = new Hashtable<String, Paint>();
        this._priorityLegendItemCollection = new LegendItemCollection();
        Rectangle shape = new Rectangle(-3, -3, 7, 7);
        for (int i = 0; i < _availablePriorities.length; ++i) {
            this._priorityPaintMap.put(_availablePriorities[i], _availablePriorityColors[i]);
            String s = _availablePriorities[i] + " Priority";
            this._priorityLegendItemCollection.add(new LegendItem(s, s, null, null, (Shape)shape, _availablePriorityColors[i]));
        }
    }

    public static void setAvailablePriorities(String[] priorities, Paint[] colors) {
        _availablePriorities = priorities;
        _availablePriorityColors = colors;
    }

    public void setModel(ElevationPlotModel model) {
        this._model = model;
        this._update();
        this._model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ObservationPanel.this._update();
            }
        });
    }

    public ElevationPlotModel getModel() {
        return this._model;
    }

    private void _update() {
        Object[] categories = this._model.getCategories();
        if (this._categories == null || !Arrays.equals(this._categories, categories)) {
            this._categories = categories;
            this._tabbedPane.removeAll();
            this._chart = new JFreeChart[this._categories.length];
            this._chartPanel = new ChartPanel[this._categories.length];
        }
        Dimension dim = new Dimension();
        for (int i = 0; i < this._categories.length; ++i) {
            IntervalCategoryDataset dataset = this._model.getIntervalCategoryDataset(this._categories[i]);
            if (this._chart[i] == null) {
                this._chartPanel[i] = this._makeObservationChart(dataset, i);
                this._tabbedPane.add((Component)new JScrollPane((Component)this._chartPanel[i]), this._categories[i]);
            } else {
                DateAxis dateAxis = this._makeDateAxis();
                CategoryPlot plot = this._chart[i].getCategoryPlot();
                plot.setRangeAxis(0, (ValueAxis)dateAxis);
                plot.setDataset((CategoryDataset)dataset);
            }
            this._chart[i].setTitle(this._model.getTitle() + " (" + this._categories[i] + ")");
            CategoryPlot plot = (CategoryPlot)this._chart[i].getPlot();
            DateAxis axis = (DateAxis)plot.getRangeAxis();
            axis.setRange(this._model.getStartDate(), this._model.getEndDate());
            axis.setLabel(this._getXAxisLabel());
            plot.clearRangeMarkers();
            this._addDarknessMarker(plot, this._model.getNauticalTwilightStart(), this._model.getNauticalTwilightEnd(), 0.05f, Color.gray);
            this._addDarknessMarker(plot, this._model.getAstronomicalTwilightStart(), this._model.getAstronomicalTwilightEnd(), 0.1f, Color.black);
            int numTargets = dataset.getColumnCount();
            if (numTargets <= 20) {
                this._chartPanel[i].setPreferredSize(null);
                continue;
            }
            this._chartPanel[i].getSize(dim);
            dim.height = 50 + numTargets * 24;
            this._chartPanel[i].setPreferredSize(dim);
        }
    }

    private DateAxis _makeDateAxis() {
        DateAxis timeAxis = new DateAxis(this._getXAxisLabel(), this._model.getTimeZone(), Locale.getDefault());
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm"){

            @Override
            public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
                if (ObservationPanel.this._model.getTimeZoneId().equals("LST")) {
                    date = ObservationPanel.this._model.getLst(date);
                }
                return super.format(date, toAppendTo, pos);
            }
        };
        dateFormat.setTimeZone(this._model.getTimeZone());
        timeAxis.setDateFormatOverride((DateFormat)dateFormat);
        return timeAxis;
    }

    private void _addDarknessMarker(CategoryPlot plot, Date startDate, Date endDate, float alpha, Color color) {
        double end;
        double start = startDate.getTime();
        if (start < (end = (double)endDate.getTime())) {
            IntervalMarker m = new IntervalMarker(start, end, (Paint)color, DARKNESS_STROKE, (Paint)color, DARKNESS_STROKE, alpha);
            plot.addRangeMarker((Marker)m);
        } else {
            double first = this._model.getDateForHour(0.0).getTime();
            double last = this._model.getDateForHour(24.0).getTime();
            IntervalMarker m1 = new IntervalMarker(start, last, (Paint)color, DARKNESS_STROKE, (Paint)color, DARKNESS_STROKE, alpha);
            plot.addRangeMarker((Marker)m1);
            IntervalMarker m2 = new IntervalMarker(first, end, (Paint)color, DARKNESS_STROKE, (Paint)color, DARKNESS_STROKE, alpha);
            plot.addRangeMarker((Marker)m2);
        }
    }

    private String _getXAxisLabel() {
        if (this._model.getTimeZoneId().equals("Site Time")) {
            return _I18N.getString("time") + " (" + this._model.getTimeZone().getDisplayName() + ")";
        }
        return _I18N.getString("time") + " (" + this._model.getTimeZoneId() + ")";
    }

    private ChartPanel _makeObservationChart(IntervalCategoryDataset dataset, int categoryIndex) {
        String title = this._model.getTitle();
        String categoryAxisLabel = _I18N.getString("Observation");
        this._chart[categoryIndex] = this._createGanttChart(title, categoryAxisLabel, dataset);
        this._chart[categoryIndex].setBackgroundPaint((Paint)this.getBackground());
        CategoryPlot plot = (CategoryPlot)this._chart[categoryIndex].getPlot();
        plot.setRangeGridlinesVisible(true);
        plot.setDomainGridlinesVisible(true);
        TextTitle textTitle = this._chart[categoryIndex].getTitle();
        textTitle.setFont(textTitle.getFont().deriveFont(12.0f));
        ChartPanel chartPanel = new ChartPanel(this._chart[categoryIndex], 680, 420, 300, 200, 1024, 768, true, false, false, false, false, true);
        chartPanel.setMaximumDrawWidth(100000);
        chartPanel.setMaximumDrawHeight(100000);
        return chartPanel;
    }

    private JFreeChart _createGanttChart(String title, String categoryAxisLabel, IntervalCategoryDataset data) {
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        categoryAxis.setTickLabelFont(_labelFont);
        DateAxis dateAxis = this._makeDateAxis();
        CategoryPlot plot = new CategoryPlot((CategoryDataset)data, categoryAxis, (ValueAxis)dateAxis, (CategoryItemRenderer)this._renderer){

            public LegendItemCollection getLegendItems() {
                return ObservationPanel.this._priorityLegendItemCollection;
            }
        };
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        plot.setOrientation(PlotOrientation.HORIZONTAL);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        if (this._showLegend) {
            chart.addLegend(new LegendTitle((LegendItemSource)plot));
        }
        return chart;
    }

    public void print() throws PrinterException {
        int index = this._tabbedPane.getSelectedIndex();
        if (index != -1) {
            PrintUtil printUtil = new PrintUtil((Printable)this._chartPanel[index]);
            printUtil.setUseBgThread(false);
            printUtil.print();
        }
    }

    public void saveAs() {
        int index = this._tabbedPane.getSelectedIndex();
        if (index != -1) {
            try {
                this._chartPanel[index].doSaveAs();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    }

    public void setShowLegend(boolean show) {
        block4: {
            this._showLegend = show;
            if (this._chart == null) break block4;
            if (show) {
                for (JFreeChart chart : this._chart) {
                    chart.addLegend(new LegendTitle((LegendItemSource)chart.getPlot()));
                }
            } else {
                for (JFreeChart chart : this._chart) {
                    chart.removeLegend();
                }
            }
        }
    }
}

